/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Transaction;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.DatabaseVersion;
import org.jumpmind.db.platform.IAlterDatabaseInterceptor;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.properties.TypedProperties;

public interface IDatabasePlatform {
    public String getName();

    public DatabaseInfo getDatabaseInfo();

    public void shutdown();

    public IDdlBuilder getDdlBuilder();

    public IDdlReader getDdlReader();

    public ISqlTemplate getSqlTemplate();

    public ISqlTemplate getSqlTemplateDirty();

    public void setClearCacheModelTimeoutInMs(long var1);

    public long getClearCacheModelTimeoutInMs();

    public String getDefaultSchema();

    public String getDefaultCatalog();

    public Database readDatabase(String var1, String var2, String[] var3);

    public Database readFromDatabase(Table ... var1);

    public Table readTableFromDatabase(String var1, String var2, String var3);

    public Table readTableFromDatabase(ISqlTransaction var1, String var2, String var3, String var4);

    public void resetCachedTableModel();

    public Table getTableFromCache(String var1, boolean var2);

    public Table getTableFromCache(String var1, String var2, String var3, boolean var4);

    public void createDatabase(Database var1, boolean var2, boolean var3);

    public void createTables(boolean var1, boolean var2, Table ... var3);

    public void alterDatabase(Database var1, String var2, boolean var3);

    public void alterDatabase(Database var1, String var2, boolean var3, IAlterDatabaseInterceptor[] var4);

    public void alterTables(boolean var1, Table ... var2);

    public void alterTables(boolean var1, boolean var2, String var3, IAlterDatabaseInterceptor[] var4, Table ... var5);

    public void dropDatabase(Database var1, boolean var2);

    public void dropTables(boolean var1, Table ... var2);

    public DmlStatement createDmlStatement(DmlStatement.DmlType var1, Table var2, String var3);

    public DmlStatement createDmlStatement(DmlStatement.DmlType var1, String var2, String var3, String var4, Column[] var5, Column[] var6, boolean[] var7, String var8);

    public DmlStatement createDmlStatement(DmlStatement.DmlType var1, String var2, String var3, String var4, Column[] var5, Column[] var6, boolean[] var7, String var8, boolean var9);

    public DmlStatement createDmlStatement(DmlStatementOptions var1);

    public Object[] getObjectValues(BinaryEncoding var1, String[] var2, Column[] var3);

    public Object[] getObjectValues(BinaryEncoding var1, Table var2, String[] var3, String[] var4);

    public Object[] getObjectValues(BinaryEncoding var1, Table var2, String[] var3, String[] var4, boolean var5, boolean var6);

    public Object[] getObjectValues(BinaryEncoding var1, String[] var2, Column[] var3, boolean var4, boolean var5);

    public String[] getStringValues(BinaryEncoding var1, Column[] var2, Row var3, boolean var4, boolean var5);

    public String getCsvStringValue(BinaryEncoding var1, Column[] var2, Row var3, boolean[] var4);

    public Database readDatabaseFromXml(String var1, boolean var2);

    public Database readDatabaseFromXml(InputStream var1, boolean var2);

    public String[] alterCaseToMatchDatabaseDefaultCase(String[] var1);

    public String alterCaseToMatchDatabaseDefaultCase(String var1);

    public void alterCaseToMatchDatabaseDefaultCase(Table var1);

    public void alterCaseToMatchDatabaseDefaultCase(Table ... var1);

    public void alterCaseToMatchDatabaseDefaultCase(Database var1);

    public void prefixDatabase(String var1, Database var2);

    public boolean isLob(Column var1);

    public boolean isClob(Column var1);

    public boolean isBlob(Column var1);

    public List<Column> getLobColumns(Table var1);

    public Map<String, String> getSqlScriptReplacementTokens();

    public String scrubSql(String var1);

    public boolean isStoresLowerCaseIdentifiers();

    public boolean isStoresUpperCaseIdentifiers();

    public boolean isStoresMixedCaseQuotedIdentifiers();

    public <T> T getDataSource();

    public void setMetadataIgnoreCase(boolean var1);

    public boolean isMetadataIgnoreCase();

    public Date parseDate(int var1, String var2, boolean var3);

    public Map<String, String> parseQualifiedTableName(String var1);

    public Table makeAllColumnsPrimaryKeys(Table var1);

    public boolean canColumnBeUsedInWhereClause(Column var1);

    public void makePlatformSpecific(Database var1);

    public boolean hasMatchingPlatform(Database var1);

    public List<PermissionResult> checkSymTablePermissions(PermissionType ... var1);

    public PermissionResult getLogMinePermission();

    public boolean isUseMultiThreadSyncTriggers();

    public boolean supportsTransactions();

    public boolean supportsMultiThreadedTransactions();

    public boolean allowsUniqueIndexDuplicatesWithNulls();

    public long getEstimatedRowCount(Table var1);

    public String getTruncateSql(Table var1);

    public String getDeleteSql(Table var1);

    public List<Transaction> getTransactions();

    public boolean supportsLimitOffset();

    public String massageForLimitOffset(String var1, int var2, int var3);

    public String massageForObjectAlreadyExists(String var1);

    public String massageForObjectDoesNotExist(String var1);

    public boolean supportsSliceTables();

    public String getSliceTableSql(String var1, int var2, int var3);

    public String getCharSetName();

    public boolean supportsParametersInSelect();

    public void setDatabaseVersion(DatabaseVersion var1);

    public DatabaseVersion getDatabaseVersion();

    public TypedProperties getProperties();
}

