/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jumpmind.db.model.PlatformFunction;

public class Function
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String functionName;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String triggerName;
    Map<String, PlatformFunction> platformFunctions;

    public Function(String functionName, String catalogName, String schemaName, String tableName) {
        this.functionName = functionName;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public Function() {
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public void removePlatformFunction(String databaseName) {
        if (this.platformFunctions != null) {
            this.platformFunctions.remove(databaseName);
        }
    }

    public void addPlatformFunction(PlatformFunction platformFunction) {
        if (this.platformFunctions == null) {
            this.platformFunctions = new HashMap<String, PlatformFunction>();
        }
        this.platformFunctions.put(platformFunction.getName(), platformFunction);
    }

    public Map<String, PlatformFunction> getPlatformFunctions() {
        return this.platformFunctions;
    }

    public PlatformFunction findPlatformFunction(String name) {
        PlatformFunction platformFunction = null;
        if (this.platformFunctions != null && (platformFunction = this.platformFunctions.get(name)) == null) {
            if (name.contains("mssql")) {
                return this.findDifferentVersionPlatformFunction("mssql");
            }
            if (name.contains("oracle")) {
                return this.findDifferentVersionPlatformFunction("oracle");
            }
            if (name.contains("postgres")) {
                return this.findDifferentVersionPlatformFunction("postgres");
            }
            if (name.contains("sqlanywhere")) {
                return this.findDifferentVersionPlatformFunction("sqlanywhere");
            }
            if (name.contains("firebird")) {
                return this.findDifferentVersionPlatformFunction("firebird");
            }
            if (name.contains("hsqldb")) {
                return this.findDifferentVersionPlatformFunction("hsqldb");
            }
        }
        return platformFunction;
    }

    private PlatformFunction findDifferentVersionPlatformFunction(String name) {
        if (this.platformFunctions != null) {
            for (Map.Entry<String, PlatformFunction> entry : this.platformFunctions.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().contains(name)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public boolean anyPlatformFunctionNameContains(String name) {
        if (this.platformFunctions != null) {
            for (String platformTriggerName : this.platformFunctions.keySet()) {
                if (platformTriggerName == null || !platformTriggerName.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allPlatformFunctionNamesContain(String name) {
        if (this.platformFunctions != null) {
            for (String platformTriggerName : this.platformFunctions.keySet()) {
                if (platformTriggerName == null || platformTriggerName.contains(name)) continue;
                return false;
            }
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        Function result = (Function)super.clone();
        result.catalogName = this.catalogName;
        result.schemaName = this.schemaName;
        result.tableName = this.tableName;
        result.functionName = this.functionName;
        result.triggerName = this.triggerName;
        if (this.platformFunctions != null) {
            result.platformFunctions = new HashMap<String, PlatformFunction>(this.platformFunctions.size());
            for (Map.Entry<String, PlatformFunction> platformFunction : this.platformFunctions.entrySet()) {
                result.platformFunctions.put(platformFunction.getKey(), (PlatformFunction)platformFunction.getValue().clone());
            }
        }
        return result;
    }

    public String getFullyQualifiedName() {
        return Function.getFullyQualifiedName(this.catalogName, this.schemaName, this.tableName, this.triggerName);
    }

    public static String getFullyQualifiedName(String catalog, String schema, String tableName, String functionName) {
        Object fullName = "";
        if (catalog != null) {
            fullName = (String)fullName + catalog + ".";
        }
        if (schema != null) {
            fullName = (String)fullName + schema + ".";
        }
        fullName = (String)fullName + tableName + "." + functionName;
        return fullName;
    }
}

