/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.util.HashMap;
import java.util.Map;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.SqlScript;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.jumpmind.symmetric.model.JobDefinition;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class SqlJob
extends AbstractJob {
    static final boolean AUTO_COMMIT = true;

    public SqlJob(String jobName, ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super(jobName, engine, taskScheduler);
    }

    public JobDefinition.JobType getJobType() {
        return JobDefinition.JobType.SQL;
    }

    @Override
    protected void doJob(boolean force) throws Exception {
        try {
            if (this.getJobDefinition().getJobExpression() != null) {
                ISqlTemplate sqlTemplate = this.engine.getDatabasePlatform().getSqlTemplate();
                Map<String, String> replacementTokens = this.getReplacementTokens(this.engine, this.engine.getSymmetricDialect().getPlatform().getSqlScriptReplacementTokens());
                SqlScript script = new SqlScript(this.getJobDefinition().getJobExpression(), sqlTemplate, true, replacementTokens);
                script.execute(true);
            }
        }
        catch (Exception ex) {
            this.log.error("Exception during sql job '" + this.getName() + "'\n" + this.getJobDefinition().getJobExpression(), (Throwable)ex);
        }
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults();
    }

    protected Map<String, String> getReplacementTokens(ISymmetricEngine engine, Map<String, String> startingReplacementTokens) {
        HashMap<String, String> replacementTokens = new HashMap<String, String>();
        if (startingReplacementTokens != null) {
            replacementTokens.putAll(startingReplacementTokens);
        }
        replacementTokens.put(":NODE_ID", engine.getNodeId());
        replacementTokens.put(":NODE_GROUP_ID", engine.getNodeService().findIdentity().getNodeGroupId());
        return replacementTokens;
    }
}

