/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.sqlanywhere;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.IConnectionCallback;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlUtils;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.sqlanywhere.SqlAnywhereTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.SymmetricUtils;

public class SqlAnywhereSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    static final String SQL_DROP_FUNCTION = "drop function $(defaultSchema).$(functionName)";
    static final String SQL_FUNCTION_INSTALLED = "select count(object_name(object_id('$(functionName)')))";
    static final String SYNC_TRIGGERS_DISABLED = "sync_triggers_disabled";
    static final String SYNC_NODE_DISABLED = "sync_node_disabled";

    public SqlAnywhereSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new SqlAnywhereTriggerTemplate(this);
    }

    public void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
        String txId;
        String nodeDisabled;
        String triggersDisabled = this.parameterService.getTablePrefix() + "_triggers_disabled";
        if (!this.installed(SQL_FUNCTION_INSTALLED, triggersDisabled)) {
            String sql = "create function $(defaultSchema).$(functionName)(@unused smallint) returns smallint as                                                                                                                                                              begin                                                                                                                                                                                                     declare @ret smallint                                   select @ret=0                                    begin                                          if varexists('sync_triggers_disabled') = 1                                               select sync_triggers_disabled into @ret                                       end                                      return @ret                                                                                                                                                                end                                                                                                                                                                    ";
            System.out.println("install triggers_disabled: " + sql);
            this.install(sql, triggersDisabled, ddl);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, nodeDisabled = this.parameterService.getTablePrefix() + "_node_disabled")) {
            String sql = "create function $(defaultSchema).$(functionName)(@unused smallint) returns varchar(50) as                                                                                                                                                           begin                                                                                                                                                                                                      declare @ret varchar(50)                                        begin                                              if varexists('sync_node_disabled') = 1                                                   select sync_node_disabled into @ret                                          end                                       return @ret                                                                                                                                                                                 end                                                                                                                                                                    ";
            this.install(sql, nodeDisabled, ddl);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, txId = this.parameterService.getTablePrefix() + "_txid")) {
            String sql = "create function $(defaultSchema).$(functionName)(@unused smallint) returns varchar(50) as                                                                                                                                                           begin                                                                                                                                                                                                      declare @txid varchar(50)                                                                                                                                                                              if (connection_property ('TransactionStartTime') is not null and                                       connection_property ('TransactionStartTime') <> '' ) begin                                                                                                                                                                                 select @txid = connection_property ('TransactionStartTime') + ' ' + CONNECTION_PROPERTY( 'number' )                                                                                                end                                                                                                                                                                                                    return @txid                                                                                                                                                                                       end                                                                                                                                                                    ";
            this.install(sql, txId, ddl);
        }
    }

    public void dropRequiredDatabaseObjects() {
        String txId;
        String nodeDisabled;
        String triggersDisabled;
        String encode = this.parameterService.getTablePrefix() + "_base64_encode";
        if (this.installed(SQL_FUNCTION_INSTALLED, encode)) {
            this.uninstall(SQL_DROP_FUNCTION, encode);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, triggersDisabled = this.parameterService.getTablePrefix() + "_triggers_disabled")) {
            this.uninstall(SQL_DROP_FUNCTION, triggersDisabled);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, nodeDisabled = this.parameterService.getTablePrefix() + "_node_disabled")) {
            this.uninstall(SQL_DROP_FUNCTION, nodeDisabled);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, txId = this.parameterService.getTablePrefix() + "_txid")) {
            this.uninstall(SQL_DROP_FUNCTION, txId);
        }
    }

    public void removeTrigger(StringBuilder sqlBuffer, final String catalogName, String schemaName, final String triggerName, String tableName, ISqlTransaction transaction) {
        final String sql = "drop trigger " + (StringUtils.isBlank((CharSequence)schemaName) ? SqlUtils.sanitizeIdentifier((String)this.platform.getDefaultSchema()) : SqlUtils.sanitizeIdentifier((String)schemaName)) + "." + SqlUtils.sanitizeIdentifier((String)tableName) + "." + SqlUtils.sanitizeIdentifier((String)triggerName);
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers") && sqlBuffer == null) {
            this.log.info("Dropping {} trigger for {}", (Object)triggerName, (Object)((StringUtils.isBlank((CharSequence)schemaName) ? this.platform.getDefaultSchema() : schemaName) + "." + tableName + "." + triggerName));
            ((JdbcSqlTransaction)transaction).executeCallback((IConnectionCallback)new IConnectionCallback<Boolean>(){

                public Boolean execute(Connection con) throws SQLException {
                    String previousCatalog = con.getCatalog();
                    Statement stmt = null;
                    try {
                        if (catalogName != null) {
                            con.setCatalog(catalogName);
                        }
                        stmt = con.createStatement();
                        stmt.execute(sql);
                    }
                    catch (Exception e) {
                        SqlAnywhereSymmetricDialect.this.log.warn("Error removing {}: {}", (Object)triggerName, (Object)e.getMessage());
                        throw e;
                    }
                    finally {
                        if (catalogName != null) {
                            con.setCatalog(previousCatalog);
                        }
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    return Boolean.FALSE;
                }
            });
        }
    }

    protected String switchCatalogForTriggerInstall(String catalog, ISqlTransaction transaction) {
        if (catalog != null) {
            Connection c = ((JdbcSqlTransaction)transaction).getConnection();
            try {
                String previousCatalog = c.getCatalog();
                c.setCatalog(catalog);
                return previousCatalog;
            }
            catch (SQLException e) {
                throw new SqlException((Throwable)e);
            }
        }
        return null;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    protected boolean doesTriggerExistOnPlatform(StringBuilder sqlBuffer, final String catalogName, String schema, String tableName, final String triggerName) {
        return (Boolean)((JdbcSqlTemplate)this.platform.getSqlTemplate()).execute((IConnectionCallback)new IConnectionCallback<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean execute(Connection con) throws SQLException {
                String previousCatalog = con.getCatalog();
                PreparedStatement stmt = con.prepareStatement("select count(*) from dbo.sysobjects where type = 'TR' AND name = ?");
                try {
                    if (catalogName != null) {
                        con.setCatalog(catalogName);
                    }
                    stmt.setString(1, triggerName);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        int count = rs.getInt(1);
                        Boolean bl = count > 0;
                        return bl;
                    }
                }
                finally {
                    if (catalogName != null) {
                        con.setCatalog(previousCatalog);
                    }
                    stmt.close();
                }
                return Boolean.FALSE;
            }
        });
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("IF VAREXISTS('sync_triggers_disabled')=1 THEN drop variable sync_triggers_disabled END IF;create variable sync_triggers_disabled smallint;set sync_triggers_disabled=1;", new Object[0]);
        transaction.prepareAndExecute("IF VAREXISTS('sync_node_disabled')=1 THEN drop variable sync_node_disabled END IF;create variable sync_node_disabled varchar(50);", new Object[0]);
        if (nodeId != null) {
            transaction.prepareAndExecute("set sync_node_disabled = '" + nodeId + "'", new Object[0]);
        }
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("IF VAREXISTS('sync_triggers_disabled')=1 THEN drop variable sync_triggers_disabled END IF;create variable sync_triggers_disabled smallint;set sync_triggers_disabled= 0;", new Object[0]);
        transaction.prepareAndExecute("IF VAREXISTS('sync_node_disabled')=1 THEN drop variable sync_node_disabled END IF;create variable sync_node_disabled varchar(50);", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return SymmetricUtils.quote((ISymmetricDialect)this, (String)this.platform.getDefaultCatalog()) + ".$(defaultSchema)" + this.parameterService.getTablePrefix() + "_triggers_disabled(0) = 0";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return SymmetricUtils.quote((ISymmetricDialect)this, (String)this.platform.getDefaultCatalog()) + ".$(defaultSchema)" + this.parameterService.getTablePrefix() + "_txid(0)";
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public boolean isTransactionIdOverrideSupported() {
        return false;
    }

    public void cleanDatabase() {
    }

    public boolean needsToSelectLobData() {
        return true;
    }
}

