/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.db2;

import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.db2.Db2SymmetricDialect;
import org.jumpmind.symmetric.service.IParameterService;

public class Db2v9SymmetricDialect
extends Db2SymmetricDialect
implements ISymmetricDialect {
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "sync_node_disabled";
    String syncTriggersDisabledUserVariable;
    String syncTriggersDisabledNodeVariable;

    public Db2v9SymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.syncTriggersDisabledUserVariable = this.parameterService.getTablePrefix() + "_sync_triggers_disabled";
        this.syncTriggersDisabledNodeVariable = this.parameterService.getTablePrefix() + "_sync_node_disabled";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.platform.getSqlTemplate().startSqlTransaction();
            this.enableSyncTriggers(transaction);
            transaction.commit();
        }
        catch (Exception e) {
            this.logSql("CREATE VARIABLE " + this.syncTriggersDisabledNodeVariable + " VARCHAR(50)", ddl);
            this.logSql("GRANT READ on VARIABLE " + this.syncTriggersDisabledNodeVariable + " TO PUBLIC", ddl);
            this.logSql("GRANT WRITE on VARIABLE " + this.syncTriggersDisabledNodeVariable + " TO PUBLIC", ddl);
            this.logSql("CREATE VARIABLE " + this.syncTriggersDisabledUserVariable + " INTEGER", ddl);
            this.logSql("GRANT READ on VARIABLE " + this.syncTriggersDisabledUserVariable + " TO PUBLIC", ddl);
            this.logSql("GRANT WRITE on VARIABLE " + this.syncTriggersDisabledUserVariable + " TO PUBLIC", ddl);
            if (ddl == null) {
                try {
                    this.log.info("Creating environment variables {} and {}", (Object)this.syncTriggersDisabledUserVariable, (Object)this.syncTriggersDisabledNodeVariable);
                    ISqlTemplate template = this.getPlatform().getSqlTemplate();
                    template.update("CREATE VARIABLE " + this.syncTriggersDisabledNodeVariable + " VARCHAR(50)", new Object[0]);
                    template.update("GRANT READ on VARIABLE " + this.syncTriggersDisabledNodeVariable + " TO PUBLIC", new Object[0]);
                    template.update("GRANT WRITE on VARIABLE " + this.syncTriggersDisabledNodeVariable + " TO PUBLIC", new Object[0]);
                    template.update("CREATE VARIABLE " + this.syncTriggersDisabledUserVariable + " INTEGER", new Object[0]);
                    template.update("GRANT READ on VARIABLE " + this.syncTriggersDisabledUserVariable + " TO PUBLIC", new Object[0]);
                    template.update("GRANT WRITE on VARIABLE " + this.syncTriggersDisabledUserVariable + " TO PUBLIC", new Object[0]);
                }
                catch (Exception ex) {
                    this.log.error("Error while initializing DB2 dialect", (Throwable)ex);
                }
            }
        }
        finally {
            this.close(transaction);
        }
        super.createRequiredDatabaseObjectsImpl(ddl);
    }

    @Override
    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.execute("set " + this.syncTriggersDisabledUserVariable + "=1");
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            transaction.execute("set " + this.syncTriggersDisabledNodeVariable + "='" + nodeId + "'");
        }
    }

    @Override
    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.execute("set " + this.syncTriggersDisabledUserVariable + "=null");
        transaction.execute("set " + this.syncTriggersDisabledNodeVariable + "=null");
    }

    @Override
    public String getSyncTriggersExpression() {
        return this.syncTriggersDisabledUserVariable + " is null";
    }

    @Override
    public String getSourceNodeExpression() {
        return this.syncTriggersDisabledNodeVariable;
    }
}

