/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.ase;

import java.util.HashMap;
import org.apache.commons.lang3.NotImplementedException;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.ase.AseSymmetricDialect;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.util.FormatUtils;

public class AseTriggerTemplate
extends AbstractTriggerTemplate {
    private int pagesize;

    public AseTriggerTemplate(ISymmetricDialect symmetricDialect) {
        super(symmetricDialect);
        this.pagesize = ((AseSymmetricDialect)symmetricDialect).getPageSize();
        String quote = symmetricDialect.getPlatform().getDatabaseInfo().getDelimiterToken();
        quote = quote == null ? "\"" : quote;
        this.emptyColumnTemplate = "null";
        this.stringColumnTemplate = "case when $(tableAlias)." + quote + "$(columnName)" + quote + " is null then null else '\"' + str_replace(str_replace($(tableAlias)." + quote + "$(columnName)" + quote + ",'\\','\\\\'),'\"','\\\"') + '\"' end";
        this.numberColumnTemplate = "case when $(tableAlias)." + quote + "$(columnName)" + quote + " is null then null else ('\"' + convert(varchar,$(tableAlias)." + quote + "$(columnName)" + quote + ") + '\"') end";
        this.datetimeColumnTemplate = "case when $(tableAlias)." + quote + "$(columnName)" + quote + " is null then null else ('\"' + str_replace(convert(varchar,$(tableAlias)." + quote + "$(columnName)" + quote + ",102),'.','-') + ' ' + right('00'+convert(varchar,datepart(HOUR,$(tableAlias)." + quote + "$(columnName)" + quote + ")),2)+':'+right('00'+convert(varchar,datepart(MINUTE,$(tableAlias)." + quote + "$(columnName)" + quote + ")),2)+':'+right('00'+convert(varchar,datepart(SECOND,$(tableAlias)." + quote + "$(columnName)" + quote + ")),2)+'.'+right('000'+convert(varchar,datepart(MILLISECOND,$(tableAlias)." + quote + "$(columnName)" + quote + ")),3) + '\"') end";
        this.timeColumnTemplate = "case when $(tableAlias)." + quote + "$(columnName)" + quote + " is null then null else ('\"' + right('00'+convert(varchar,datepart(HOUR,$(tableAlias)." + quote + "$(columnName)" + quote + ")),2)+':'+right('00'+convert(varchar,datepart(MINUTE,$(tableAlias)." + quote + "$(columnName)" + quote + ")),2)+':'+right('00'+convert(varchar,datepart(SECOND,$(tableAlias)." + quote + "$(columnName)" + quote + ")),2)+'.'+right('000'+convert(varchar,datepart(MILLISECOND,$(tableAlias)." + quote + "$(columnName)" + quote + ")),3) + '\"') end";
        this.clobColumnTemplate = "case when datalength($(origTableAlias)." + quote + "$(columnName)" + quote + ") is null or datalength($(origTableAlias)." + quote + "$(columnName)" + quote + ")=0 then null when char_length($(origTableAlias)." + quote + "$(columnName)" + quote + ") > 16384 then '\"\\b\"' else '\"' + str_replace(str_replace(cast($(origTableAlias)." + quote + "$(columnName)" + quote + " as varchar(16384)),'\\','\\\\'),'\"','\\\"') + '\"' end";
        this.blobColumnTemplate = "case when $(origTableAlias)." + quote + "$(columnName)" + quote + " is null then null else '\"' + bintostr(convert(varbinary(16384),$(origTableAlias)." + quote + "$(columnName)" + quote + ")) + '\"' end";
        this.binaryColumnTemplate = "case when $(tableAlias)." + quote + "$(columnName)" + quote + " is null then null else '\"' + bintostr(convert(varbinary(16384),$(tableAlias)." + quote + "$(columnName)" + quote + ")) + '\"' end";
        this.imageColumnTemplate = "case when datalength($(origTableAlias)." + quote + "$(columnName)" + quote + ") is null or datalength($(origTableAlias)." + quote + "$(columnName)" + quote + ")=0 then null else '\"' + bintostr(convert(varbinary(16384),$(origTableAlias)." + quote + "$(columnName)" + quote + ")) + '\"' end";
        this.booleanColumnTemplate = "case when $(tableAlias)." + quote + "$(columnName)" + quote + " is null then null when $(tableAlias)." + quote + "$(columnName)" + quote + " = 1 then '\"1\"' else '\"0\"' end";
        this.triggerConcatCharacter = "+";
        this.newTriggerValue = "inserted";
        this.oldTriggerValue = "deleted";
        this.oldColumnPrefix = "";
        this.newColumnPrefix = "";
        this.sqlTemplates = new HashMap();
        this.sqlTemplates.put("insertTriggerTemplate", "create trigger $(triggerName) on $(schemaName)$(tableName) for insert " + this.getOrderClause() + " as\n                                begin                                                                                                                                                                  \n                                  set nocount on      \n                                  declare @txid varchar(50)             \n                                  if (@@TRANCOUNT > 0) begin                                                                                                                                         \n                                      select @txid = $(txIdExpression)                              \n                                  end                                                                                                                                                                \n                                  declare @clientapplname varchar(50)  \n                                  declare @clientname varchar(50)    \n                                  select @clientapplname = clientapplname, @clientname = case when clientapplname = 'SymmetricDS' then clientname else null end from master.dbo.sysprocesses where spid = @@spid     \n                                  $(custom_before_insert_text) \n                                  if ($(syncOnIncomingBatchCondition)) begin                                                                                                                           \n                                           insert into $(defaultCatalog)$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, row_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n                                             select '$(targetTableName)','I', $(triggerHistoryId), $(columns), $(channelExpression), @txid, @clientname, $(externalSelect), getdate()                                   \n                                    $(if:containsBlobClobColumns)                                              from inserted inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin)\n                                    $(else:containsBlobClobColumns)                                              from inserted\n                                    $(end:containsBlobClobColumns)                                              where $(syncOnInsertCondition)\n                                  end                                                                                                                                                                  \n                                  $(custom_on_insert_text) \n                                  set nocount off      \n                                end                                                                                                                                                                    ");
        IParameterService parameterService = symmetricDialect.getParameterService();
        if (parameterService.is("trigger.use.insert.delete.for.primary.key.changes", true)) {
            this.sqlTemplates.put("updateTriggerTemplate", "create trigger $(triggerName) on $(schemaName)$(tableName) for update " + this.getOrderClause() + " as\n                                begin                                                                                                                                                                  \n                                  set nocount on      \n                                  declare @LOCALROWCOUNT int                                                                                   \n                                  declare @LOCALPKCHANGED int                                                                                  \n                                  select @LOCALROWCOUNT = count(*) from inserted \n                                  select @LOCALPKCHANGED = 0 \n                                  if ($(hasPrimaryKeysDefined)) begin\n                                    select @LOCALPKCHANGED = count(*) from inserted, deleted where $(oldNewPrimaryKeyJoin)\n                                  end                                            \n                                  declare @txid varchar(50)                                                                                                                                            \n                                  if (@@TRANCOUNT > 0) begin                                                                                                                                         \n                                      select @txid = $(txIdExpression)                             \n                                  end                                                                                                                                                                \n                                  declare @clientapplname varchar(50)  \n                                  declare @clientname varchar(50)    \n                                  select @clientapplname = clientapplname, @clientname = case when clientapplname = 'SymmetricDS' then clientname else null end from master.dbo.sysprocesses where spid = @@spid     \n                                  $(custom_before_update_text) \n                                  if ($(syncOnIncomingBatchCondition)) begin                                                                                                                           \n                                   if ($(hasPrimaryKeysDefined) $(primaryKeysUpdated) AND @LOCALROWCOUNT <> @LOCALPKCHANGED ) \n                                    begin \n                                     if (@LOCALROWCOUNT = 1)                                                                                  \n                                     begin                                                                                                    \n                                       insert into $(defaultCatalog)$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, row_data, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n                                       select '$(targetTableName)','U', $(triggerHistoryId), $(columns), $(oldKeys), $(oldColumns), \n                                         $(channelExpression), @txid, @clientname, $(externalSelect), getdate()\n                                    $(if:containsBlobClobColumns)                                                                                                                                      \n                                       from inserted inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin) inner join deleted on 1=1\n                                    $(else:containsBlobClobColumns)                                                                                                                                    \n                                       from inserted inner join deleted on 1=1                                     \n                                    $(end:containsBlobClobColumns)                                                                                                                                     \n                                       where $(syncOnUpdateCondition)\n                                     end                                                                                                      \n                                     else                                                                                                     \n                                     begin                                                                                                    \n                                       insert into $(defaultCatalog)$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n                                       select '$(targetTableName)','D', $(triggerHistoryId), $(oldKeys), $(oldColumns), $(specialSqlServerSybaseChannelExpression), @txid, @clientname, $(externalSelectForDelete), getdate()\n                                       from deleted where $(syncOnDeleteCondition)\n                                       insert into $(defaultCatalog)$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, row_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n                                       select '$(targetTableName)','I', $(triggerHistoryId), $(columns), $(channelExpression), @txid, @clientname, $(externalSelectForInsert), getdate()\n                                     $(if:containsBlobClobColumns)                                                                                                                                      \n                                       from inserted inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin)\n                                     $(else:containsBlobClobColumns)                                                                                                                                    \n                                       from inserted                                                                                   \n                                     $(end:containsBlobClobColumns)                                                                                                                                     \n                                       where $(syncOnInsertCondition)\n                                     end \n                                    end                                                                                                        \n                                   else \n                                    begin                                                                                                                           \n                                       insert into $(defaultCatalog)$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, row_data, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n                                       select '$(targetTableName)','U', $(triggerHistoryId), $(columns), $(oldKeys), $(oldColumns), $(channelExpression), @txid, @clientname, $(externalSelect), getdate()\n                                    $(if:containsBlobClobColumns)                                                                                                                                      \n                                       from inserted inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin) inner join deleted on $(oldNewPrimaryKeyJoin)\n                                    $(else:containsBlobClobColumns)                                                                                                                                    \n                                       from inserted inner join deleted on $(oldNewPrimaryKeyJoin)                                    \n                                    $(end:containsBlobClobColumns)                                                                                                                                     \n                                       where $(syncOnUpdateCondition)\n                                    end                                                                                                                                                                \n                                   end                                                                                                                                                                  \n                                   $(custom_on_update_text)                                                                                                                                             \n                                   set nocount off                                                                                                                                        \n                                  end                                                                                                                                                                    \n");
        } else {
            this.sqlTemplates.put("updateTriggerTemplate", "create trigger $(triggerName) on $(schemaName)$(tableName) for update " + this.getOrderClause() + " as\n   begin                                                                                                                                                                  \n     set nocount on                                                                                                                                                       \n     declare @TransactionId varchar(1000)                                                                                                                                 \n     declare @DataRow varchar(16384)                                                                                                                                      \n     declare @OldPk varchar(2000)                                                                                                                                         \n     declare @OldDataRow varchar(16384)                                                                                                                                     \n     declare @clientapplname varchar(50)                                                                                                                                   \n     declare @clientname varchar(50)                                                                                                                                      \n     select @clientapplname = clientapplname, @clientname = case when clientapplname = 'SymmetricDS' then clientname else null end from master.dbo.sysprocesses where spid = @@spid     \n     declare @ChannelId varchar(128)                                                                                                                                       \n     $(declareOldKeyVariables)                                                                                                                                            \n     $(declareNewKeyVariables)                                                                                                                                            \n                                  declare @txid varchar(50)                                                                                                                                            \n                                  if (@@TRANCOUNT > 0) begin                                                                                                                                         \n                                      select @txid = $(txIdExpression)                             \n                                  end                                                                                                                                                                \n                                  $(custom_before_update_text) \n     if ($(syncOnIncomingBatchCondition)) begin                                                                                                                           \n       declare DeleteCursor cursor  for                                                                                                                                \n          select $(oldKeys), $(oldColumns) $(oldKeyNames) from deleted where $(syncOnDeleteCondition)                                                                      \n       declare InsertCursor cursor for                                                                                                                                \n          $(if:containsBlobClobColumns)                                                                                                                                      \n             select $(columns) $(newKeyNames), $(channelExpression) from inserted inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin) where $(syncOnInsertCondition)\n          $(else:containsBlobClobColumns)                                                                                                                                    \n             select $(columns) $(newKeyNames), $(channelExpression) from inserted where $(syncOnInsertCondition)                                                                                   \n          $(end:containsBlobClobColumns)                                                                                                                                     \n          open DeleteCursor                                                                                                                                                 \n          open InsertCursor                                                                                                                                                 \n          fetch DeleteCursor into @OldPk, @OldDataRow $(oldKeyVariables)                                                                                          \n          fetch InsertCursor into @DataRow $(newKeyVariables), @ChannelId                                                                                                    \n          while @@sqlstatus = 0 begin                                                                                                                                  \n            if ($(dataHasChangedCondition)) begin                                                                                                                                \n              insert into $(defaultCatalog)$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, row_data, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n                values('$(targetTableName)','U', $(triggerHistoryId), @DataRow, @OldPk, @OldDataRow, @ChannelId, @txid, @clientname, $(externalSelect), getdate())\n            end                                                                                                                                                             \n            fetch DeleteCursor into @OldPk, @OldDataRow $(oldKeyVariables)                                                                                      \n            fetch InsertCursor into @DataRow $(newKeyVariables), @ChannelId                                                                                              \n          end                                                                                                                                                             \n          close DeleteCursor                                                                                                                                                \n          close InsertCursor                                                                                                                                                \n          deallocate cursor DeleteCursor                                                                                                                                           \n          deallocate cursor InsertCursor                                                                                                                                           \n       end                                                                                                                                                                \n       $(custom_on_update_text)                                                                                                                                             \n     set nocount off                                                                                                                                        \n   end                                                                                                                                                                    \n");
        }
        this.sqlTemplates.put("deleteTriggerTemplate", "create trigger $(triggerName) on $(schemaName)$(tableName) for delete " + this.getOrderClause() + " as\n                                begin                                                                                                                                                                  \n                                  set nocount on      \n                                  declare @txid varchar(50)                                                                                                                                            \n                                  if (@@TRANCOUNT > 0) begin                                                                                                                                         \n                                      select @txid = $(txIdExpression)                            \n                                  end                                                                                                                                                                \n                                  declare @clientapplname varchar(50)    \n                                  declare @clientname varchar(50)    \n                                  select @clientapplname = clientapplname, @clientname = case when clientapplname = 'SymmetricDS' then clientname else null end from master.dbo.sysprocesses where spid = @@spid     \n                                  $(custom_before_delete_text) \n                                  if ($(syncOnIncomingBatchCondition)) begin                                                                                                                           \n                                     insert into $(defaultCatalog)$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n                                     select '$(targetTableName)','D', $(triggerHistoryId), $(oldKeys), $(oldColumns), $(channelExpression), @txid, @clientname, $(externalSelect), getdate()\n                                     from deleted where $(syncOnDeleteCondition)\n                                  end                                                                                                                                                                  \n                                  $(custom_on_delete_text) \n                                  set nocount off          \n                                end                                                                                                                                                                    ");
        this.sqlTemplates.put("initialLoadSqlTemplate", "select $(columns) from $(schemaName)$(tableName) t where $(whereClause)                                                                                                                                ");
    }

    protected String getOrderClause() {
        return "";
    }

    protected String replaceTemplateVariables(DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table originalTable, Table table, String defaultCatalog, String defaultSchema, String ddl) {
        ddl = FormatUtils.replace((String)"oldColumns", (String)(trigger.isUseCaptureOldData() ? super.buildColumnsString("orig", this.oldTriggerValue, this.oldColumnPrefix, table, table.getColumns(), dml, true, channel, trigger).toString() : "convert(VARCHAR,null)"), (String)ddl);
        ddl = super.replaceTemplateVariables(dml, trigger, history, channel, tablePrefix, originalTable, table, defaultCatalog, defaultSchema, ddl);
        Column[] columns = table.getPrimaryKeyColumns();
        ddl = FormatUtils.replace((String)"declareOldKeyVariables", (String)this.buildKeyVariablesDeclare(columns, "old"), (String)ddl);
        ddl = FormatUtils.replace((String)"declareNewKeyVariables", (String)this.buildKeyVariablesDeclare(columns, "new"), (String)ddl);
        return ddl;
    }

    protected String buildKeyVariablesDeclare(Column[] columns, String prefix) {
        Object text = "";
        block13: for (int i = 0; i < columns.length; ++i) {
            text = (String)text + "declare @" + prefix + "pk" + i + " ";
            switch (columns[i].getMappedTypeCode()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    text = (String)text + "NUMERIC(18,0)\n";
                    continue block13;
                }
                case 2: 
                case 3: {
                    text = (String)text + "decimal(30,6)\n";
                    continue block13;
                }
                case 6: 
                case 7: 
                case 8: {
                    text = (String)text + "float\n";
                    continue block13;
                }
                case -1: 
                case 1: 
                case 12: {
                    text = (String)text + "varchar(1000)\n";
                    continue block13;
                }
                case 91: {
                    text = (String)text + "date\n";
                    continue block13;
                }
                case 92: {
                    text = (String)text + "time\n";
                    continue block13;
                }
                case 93: {
                    text = (String)text + "datetime\n";
                    continue block13;
                }
                case -7: 
                case 16: {
                    text = (String)text + "bit\n";
                    continue block13;
                }
                case 2005: {
                    text = (String)text + "varchar(" + this.pagesize + ")\n";
                    continue block13;
                }
                case -10: 
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    text = (String)text + "varbinary(" + this.pagesize + ")\n";
                    continue block13;
                }
                case 1111: {
                    text = (String)text + "varbinary(" + this.pagesize + ")\n";
                    continue block13;
                }
                default: {
                    if (columns[i].getJdbcTypeName() != null && columns[i].getJdbcTypeName().equalsIgnoreCase("interval")) {
                        text = (String)text + "interval";
                        continue block13;
                    }
                    throw new NotImplementedException(String.valueOf(columns[i]) + " is of type " + columns[i].getMappedType());
                }
            }
        }
        return text;
    }
}

