/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.security.Provider;
import java.security.Security;
import java.sql.Connection;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.util.BasicDataSourcePropertyConstants;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ClientSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ITypedPropertiesFactory;
import org.jumpmind.symmetric.Message;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.ParameterConstants;
import org.jumpmind.symmetric.transport.TransportManagerFactory;
import org.jumpmind.symmetric.util.LogSummaryAppenderUtils;
import org.jumpmind.symmetric.util.PropertiesUtil;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommandLauncher {
    private static final Logger log;
    public static final String DEFAULT_SERVER_PROPERTIES;
    protected static final String HELP = "help";
    protected static final String OPTION_PROPERTIES_FILE = "properties";
    protected static final String OPTION_ENGINE = "engine";
    protected static final String OPTION_VERBOSE_CONSOLE = "verbose";
    protected static final String OPTION_DEBUG = "debug";
    protected static final String OPTION_NO_LOG_CONSOLE = "no-log-console";
    protected static final String OPTION_NO_LOG_FILE = "no-log-file";
    protected static final String OPTION_KEYSTORE_PASSWORD = "storepass";
    protected static final String OPTION_KEYSTORE_TYPE = "storetype";
    protected static final String OPTION_JCE_PROVIDER = "providerClass";
    protected static final String COMMON_MESSAGE_KEY_PREFIX = "Common.Option.";
    protected String app;
    protected String argSyntax;
    protected String messageKeyPrefix;
    protected File propertiesFile;
    protected ISymmetricEngine engine;
    protected IDatabasePlatform platform;
    private static boolean serverPropertiesInitialized;

    public AbstractCommandLauncher(String app, String argSyntax, String messageKeyPrefix) {
        this.app = app;
        this.argSyntax = argSyntax;
        this.messageKeyPrefix = messageKeyPrefix;
        TypedProperties serverProperties = new TypedProperties(System.getProperties());
        boolean allowSelfSignedCerts = serverProperties.is("https.allow.self.signed.certs", true);
        String allowServerNames = serverProperties.get("https.verified.server.names", "all");
        boolean https2Enabled = serverProperties.is("https2.enable", false);
        TransportManagerFactory.initHttps((String)allowServerNames, (boolean)allowSelfSignedCerts, (boolean)https2Enabled);
    }

    protected static void initFromServerProperties() {
        if (!serverPropertiesInitialized) {
            File serverPropertiesFile = new File(DEFAULT_SERVER_PROPERTIES);
            TypedProperties serverProperties = new TypedProperties();
            if (serverPropertiesFile.exists() && serverPropertiesFile.isFile()) {
                try (FileInputStream fis = new FileInputStream(serverPropertiesFile);){
                    serverProperties.load((InputStream)fis);
                    serverProperties.merge(System.getProperties());
                    System.getProperties().putAll((Map<?, ?>)serverProperties);
                }
                catch (IOException ex) {
                    log.error("Failed to load " + DEFAULT_SERVER_PROPERTIES, (Throwable)ex);
                }
            } else if (!serverPropertiesFile.exists()) {
                log.debug("Failed to load " + DEFAULT_SERVER_PROPERTIES + ". File does not exist.");
            } else if (!serverPropertiesFile.isFile()) {
                log.debug("Failed to load " + DEFAULT_SERVER_PROPERTIES + ". Object is not a file.");
            }
            serverPropertiesInitialized = true;
        }
    }

    protected abstract boolean printHelpIfNoOptionsAreProvided();

    protected abstract boolean requiresPropertiesFile(CommandLine var1);

    public void execute(String[] args) {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        this.buildOptions(options);
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(HELP) || line.getArgList().contains(HELP) || (args == null || args.length == 0) && line.getOptions().length == 0 && this.printHelpIfNoOptionsAreProvided()) {
                this.printHelp(line, options);
                System.exit(2);
            }
            this.configureLogging(line);
            this.configurePropertiesFile(line);
            String[] cmdArgs = line.getArgs();
            if (cmdArgs != null) {
                log.info("Command: {}", (Object)this.scrubCommandLine(cmdArgs));
            }
            if (line.getOptions() != null) {
                for (Option option : line.getOptions()) {
                    log.info("Option: name={}, value={}", (Object)(option.getLongOpt() != null ? option.getLongOpt() : option.getOpt()), (Object)this.scrubOptionValues(option));
                }
            }
            this.executeWithOptions(line);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            this.printUsage(options);
            System.exit(4);
        }
        catch (Exception e) {
            System.err.println("-------------------------------------------------------------------------------");
            System.err.println("An exception occurred.  Please see the following for details:");
            System.err.println("-------------------------------------------------------------------------------");
            ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)System.err);
            System.err.println("-------------------------------------------------------------------------------");
            System.exit(1);
        }
    }

    protected String scrubCommandLine(String[] cmdArgs) {
        return ArrayUtils.toString((Object)cmdArgs);
    }

    protected String scrubOptionValues(Option option) {
        String name;
        String string = name = option.getLongOpt() != null ? option.getLongOpt() : option.getOpt();
        if (name != null && name.equals(OPTION_KEYSTORE_PASSWORD)) {
            return "***";
        }
        return ArrayUtils.toString((Object)option.getValues());
    }

    protected void printHelp(CommandLine cmd, Options options) {
        new HelpFormatter().printHelp(this.app + " " + this.argSyntax, options);
    }

    protected void printUsage(Options options) {
        PrintWriter writer = new PrintWriter(System.out);
        new HelpFormatter().printUsage(writer, 80, this.app, options);
        writer.write("For more options, use " + this.app + " --help\n");
        writer.flush();
    }

    protected void configureLogging(CommandLine line) throws MalformedURLException {
        String overrideLogFileName = null;
        if (line.hasOption(OPTION_PROPERTIES_FILE)) {
            File file = new File(line.getOptionValue(OPTION_PROPERTIES_FILE));
            String name = file.getName();
            int index = name.lastIndexOf(".");
            if (index > 0) {
                name = name.substring(0, index);
            }
            overrideLogFileName = name + ".log";
        }
        LogSummaryAppenderUtils.initialize((boolean)line.hasOption(OPTION_DEBUG), (boolean)line.hasOption(OPTION_VERBOSE_CONSOLE), (boolean)line.hasOption(OPTION_NO_LOG_CONSOLE), (boolean)line.hasOption(OPTION_NO_LOG_FILE), overrideLogFileName);
    }

    protected void configurePropertiesFile(CommandLine line) throws ParseException {
        if (line.hasOption(OPTION_PROPERTIES_FILE)) {
            String propertiesFilename = line.getOptionValue(OPTION_PROPERTIES_FILE);
            this.propertiesFile = new File(propertiesFilename);
            if (!this.propertiesFile.exists()) {
                throw new SymmetricException("Could not find the properties file specified: %s", new Object[]{line.getOptionValue(OPTION_PROPERTIES_FILE)});
            }
        } else if (line.hasOption(OPTION_ENGINE)) {
            this.propertiesFile = PropertiesUtil.findPropertiesFileForEngineWithName((String)line.getOptionValue(OPTION_ENGINE));
            if (this.propertiesFile == null || this.propertiesFile != null && !this.propertiesFile.exists()) {
                throw new SymmetricException("Could not find the properties file for the engine specified: %s", new Object[]{line.getOptionValue(OPTION_ENGINE)});
            }
        } else {
            this.propertiesFile = this.findSingleEnginesPropertiesFile();
            if (this.propertiesFile == null && this.requiresPropertiesFile(line)) {
                throw new ParseException(String.format("You must specify either --%s or --%s", OPTION_ENGINE, OPTION_PROPERTIES_FILE));
            }
        }
    }

    public File findSingleEnginesPropertiesFile() {
        File[] files = PropertiesUtil.findEnginePropertiesFiles();
        if (files.length == 1) {
            return files[0];
        }
        return null;
    }

    protected void configureCrypto(CommandLine line) throws Exception {
        if (line.hasOption(OPTION_KEYSTORE_PASSWORD)) {
            System.setProperty("javax.net.ssl.keyStorePassword", line.getOptionValue(OPTION_KEYSTORE_PASSWORD));
        }
        if (line.hasOption(OPTION_KEYSTORE_TYPE)) {
            System.setProperty("sym.keystore.type", line.getOptionValue(OPTION_KEYSTORE_TYPE));
        }
        if (line.hasOption(OPTION_JCE_PROVIDER)) {
            Provider provider = (Provider)Class.forName(line.getOptionValue(OPTION_JCE_PROVIDER)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Security.addProvider(provider);
        }
    }

    protected ISymmetricEngine getSymmetricEngine() {
        return this.getSymmetricEngine(true);
    }

    protected ISymmetricEngine getSymmetricEngine(boolean testConnection) {
        if (this.engine == null) {
            if (testConnection) {
                this.testConnection();
            }
            this.engine = new ClientSymmetricEngine(this.propertiesFile);
            this.platform = this.engine.getSymmetricDialect().getPlatform();
        }
        return this.engine;
    }

    protected void testConnection() {
        try {
            BasicDataSource ds = ClientSymmetricEngine.createBasicDataSource(this.propertiesFile);
            Connection conn = ds.getConnection();
            conn.close();
            ds.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected IDatabasePlatform getDatabasePlatform(boolean testConnection) {
        return this.getDatabasePlatform(testConnection, false);
    }

    protected IDatabasePlatform getDatabasePlatform(boolean testConnection, boolean symmetricPlatform) {
        if (this.platform == null) {
            ITypedPropertiesFactory factory;
            TypedProperties properties;
            if (testConnection) {
                this.testConnection();
            }
            if ((properties = (factory = PropertiesUtil.createTypedPropertiesFactory((File)this.propertiesFile, null)).reload(this.propertiesFile)).is("load.only", false) && !symmetricPlatform) {
                TypedProperties copiedProperties = new TypedProperties();
                String prefix = "target.";
                this.copyProperties(properties, copiedProperties, prefix, BasicDataSourcePropertyConstants.ALL_PROPS);
                this.copyProperties(properties, copiedProperties, prefix, ParameterConstants.ALL_JDBC_PARAMS);
                properties = copiedProperties;
            }
            this.platform = ClientSymmetricEngine.createDatabasePlatform(null, properties, null, false);
        }
        return this.platform;
    }

    private void copyProperties(TypedProperties sourceProperties, TypedProperties targetProperties, String prefix, String[] parameterNames) {
        for (String name : parameterNames) {
            targetProperties.put((Object)name, (Object)sourceProperties.get(prefix + name));
        }
    }

    protected TypedProperties getTypedProperties() {
        ITypedPropertiesFactory factory = PropertiesUtil.createTypedPropertiesFactory((File)this.propertiesFile, null);
        return factory.reload(this.propertiesFile);
    }

    protected void buildOptions(Options options) {
        this.addCommonOption(options, "h", HELP, false);
        this.addCommonOption(options, "p", OPTION_PROPERTIES_FILE, true);
        this.addCommonOption(options, "e", OPTION_ENGINE, true);
        this.addCommonOption(options, "v", OPTION_VERBOSE_CONSOLE, false);
        this.addCommonOption(options, null, OPTION_DEBUG, false);
        this.addCommonOption(options, null, OPTION_NO_LOG_CONSOLE, false);
        this.addCommonOption(options, null, OPTION_NO_LOG_FILE, false);
    }

    protected void buildCryptoOptions(Options options) {
        this.addCommonOption(options, OPTION_KEYSTORE_PASSWORD, true);
        this.addCommonOption(options, OPTION_KEYSTORE_TYPE, true);
        this.addCommonOption(options, OPTION_JCE_PROVIDER, true);
    }

    protected void addOption(Options options, String opt, String longOpt, boolean hasArg) {
        options.addOption(opt, longOpt, hasArg, Message.get(this.messageKeyPrefix + longOpt));
    }

    protected void addOption(Options options, String opt, boolean hasArg) {
        options.addOption(opt, null, hasArg, Message.get(this.messageKeyPrefix + opt));
    }

    protected void addCommonOption(Options options, String opt, String longOpt, boolean hasArg) {
        options.addOption(opt, longOpt, hasArg, Message.get(COMMON_MESSAGE_KEY_PREFIX + longOpt));
    }

    protected void addCommonOption(Options options, String opt, boolean hasArg) {
        options.addOption(opt, null, hasArg, Message.get(COMMON_MESSAGE_KEY_PREFIX + opt));
    }

    protected abstract boolean executeWithOptions(CommandLine var1) throws Exception;

    static {
        serverPropertiesInitialized = false;
        System.setProperty("symmetric.launcher", "true");
        String symHome = AppUtils.getSymHome();
        if (StringUtils.isBlank((CharSequence)System.getProperty("h2.baseDir.disable")) && StringUtils.isBlank((CharSequence)System.getProperty("h2.baseDir"))) {
            System.setProperty("h2.baseDir", symHome + "/db/h2");
        }
        if (StringUtils.isBlank((CharSequence)System.getProperty("derby.baseDir"))) {
            System.setProperty("derby.baseDir", symHome + "/db/derby");
        }
        DEFAULT_SERVER_PROPERTIES = System.getProperty("symmetric.server.properties.path", symHome + "/conf/symmetric-server.properties");
        log = LoggerFactory.getLogger(AbstractCommandLauncher.class);
        AbstractCommandLauncher.initFromServerProperties();
    }
}

