/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.pdfjson.type3.tool;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import stirling.software.SPDF.service.pdfjson.type3.Type3FontSignatureCalculator;
import stirling.software.SPDF.service.pdfjson.type3.Type3GlyphExtractor;
import stirling.software.SPDF.service.pdfjson.type3.model.Type3GlyphOutline;
import stirling.software.SPDF.service.pdfjson.type3.tool.Type3SignatureTool;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Type3SignatureTool {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    private Type3SignatureTool() {
    }

    public static void main(String[] args) throws Exception {
        ObjectWriter writer;
        List fonts;
        Arguments arguments = Arguments.parse((String[])args);
        if (arguments.showHelp || arguments.pdf == null) {
            Type3SignatureTool.printUsage();
            return;
        }
        Path pdfPath = arguments.pdf.toAbsolutePath();
        if (!Files.exists(pdfPath, new LinkOption[0])) {
            throw new IOException("PDF not found: " + String.valueOf(pdfPath));
        }
        try (PDDocument document = Loader.loadPDF((File)pdfPath.toFile());){
            fonts = Type3SignatureTool.collectType3Fonts((PDDocument)document);
        }
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        output.put("pdf", pdfPath.toString());
        output.put("fonts", fonts);
        ObjectWriter objectWriter = writer = arguments.pretty ? OBJECT_MAPPER.writerWithDefaultPrettyPrinter() : OBJECT_MAPPER.writer();
        if (arguments.output != null) {
            Path parent = arguments.output.toAbsolutePath().getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            writer.writeValue(arguments.output.toFile(), output);
            Type3SignatureTool.verifyOutput((Path)arguments.output, (int)fonts.size());
        } else {
            writer.writeValue((OutputStream)System.out, output);
        }
    }

    private static List<Map<String, Object>> collectType3Fonts(PDDocument document) throws IOException {
        if (document == null || document.getNumberOfPages() == 0) {
            return List.of();
        }
        ArrayList<Map<String, Object>> fonts = new ArrayList<Map<String, Object>>();
        Type3GlyphExtractor glyphExtractor = new Type3GlyphExtractor();
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        for (int pageIndex = 0; pageIndex < document.getNumberOfPages(); ++pageIndex) {
            PDPage page = document.getPage(pageIndex);
            PDResources resources = page.getResources();
            if (resources == null) continue;
            Type3SignatureTool.scanResources((PDDocument)document, (int)(pageIndex + 1), (PDResources)resources, (Type3GlyphExtractor)glyphExtractor, visited, fonts);
        }
        return fonts;
    }

    private static void scanResources(PDDocument document, int pageNumber, PDResources resources, Type3GlyphExtractor glyphExtractor, Set<Object> visited, List<Map<String, Object>> fonts) throws IOException {
        if (resources == null) {
            return;
        }
        for (COSName name : resources.getFontNames()) {
            PDType3Font type3Font;
            COSDictionary cosObject;
            PDFont font = resources.getFont(name);
            if (!(font instanceof PDType3Font) || (cosObject = (type3Font = (PDType3Font)font).getCOSObject()) != null && !visited.add(cosObject)) continue;
            fonts.add(Type3SignatureTool.describeFont((PDDocument)document, (int)pageNumber, (String)name.getName(), (PDType3Font)type3Font, (Type3GlyphExtractor)glyphExtractor));
        }
        ArrayDeque<PDResources> embedded = new ArrayDeque<PDResources>();
        for (COSName name : resources.getXObjectNames()) {
            PDFormXObject form;
            PDXObject xobject = resources.getXObject(name);
            if (!(xobject instanceof PDFormXObject) || (form = (PDFormXObject)xobject).getResources() == null) continue;
            embedded.add(form.getResources());
        }
        while (!embedded.isEmpty()) {
            Type3SignatureTool.scanResources((PDDocument)document, (int)pageNumber, (PDResources)((PDResources)embedded.pop()), (Type3GlyphExtractor)glyphExtractor, visited, fonts);
        }
    }

    private static Map<String, Object> describeFont(PDDocument document, int pageNumber, String fontId, PDType3Font font, Type3GlyphExtractor glyphExtractor) throws IOException {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("pageNumber", pageNumber);
        payload.put("fontId", fontId);
        payload.put("baseName", Type3SignatureTool.safeFontName((PDType3Font)font));
        payload.put("alias", Type3SignatureTool.normalizeAlias((String)Type3SignatureTool.safeFontName((PDType3Font)font)));
        payload.put("encoding", Type3SignatureTool.resolveEncoding((PDType3Font)font));
        payload.put("signature", Type3FontSignatureCalculator.computeSignature((PDType3Font)font));
        List glyphs = glyphExtractor.extractGlyphs(document, font, fontId, pageNumber);
        payload.put("glyphCount", glyphs != null ? glyphs.size() : 0);
        TreeSet<Integer> coverage = new TreeSet<Integer>();
        if (glyphs != null) {
            for (Type3GlyphOutline glyph : glyphs) {
                if (glyph == null) continue;
                if (glyph.getUnicode() != null) {
                    coverage.add(glyph.getUnicode());
                    continue;
                }
                if (glyph.getCharCode() < 0) continue;
                coverage.add(0xF000 | glyph.getCharCode() & 0xFF);
            }
            ArrayList warnings = new ArrayList();
            for (Type3GlyphOutline glyph : glyphs) {
                if (glyph == null || glyph.getWarnings() == null) continue;
                LinkedHashMap<String, String> warning = new LinkedHashMap<String, String>();
                warning.put("glyphName", glyph.getGlyphName());
                warning.put("message", glyph.getWarnings());
                warnings.add(warning);
            }
            if (!warnings.isEmpty()) {
                payload.put("warnings", warnings);
            }
        }
        if (!coverage.isEmpty()) {
            payload.put("glyphCoverage", new ArrayList(coverage));
        }
        return payload;
    }

    private static void verifyOutput(Path output, int fontCount) throws IOException {
        Path absolute = output.toAbsolutePath();
        if (!Files.exists(absolute, new LinkOption[0])) {
            throw new IOException("Expected output file not found: " + String.valueOf(absolute));
        }
        long size = Files.size(absolute);
        if (size == 0L) {
            throw new IOException("Output file is empty: " + String.valueOf(absolute));
        }
        System.out.println("Wrote " + fontCount + " fonts to " + String.valueOf(absolute) + " (" + size + " bytes, verified)");
    }

    private static String resolveEncoding(PDType3Font font) {
        if (font == null || font.getEncoding() == null) {
            return null;
        }
        COSBase encoding = font.getCOSObject().getDictionaryObject(COSName.ENCODING);
        return encoding != null ? encoding.toString() : font.getEncoding().getClass().getSimpleName();
    }

    private static String safeFontName(PDType3Font font) {
        if (font == null) {
            return null;
        }
        try {
            if (font.getName() != null) {
                return font.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (font.getCOSObject() != null) {
            return font.getCOSObject().getNameAsString(COSName.BASE_FONT);
        }
        return null;
    }

    private static String normalizeAlias(String name) {
        if (name == null) {
            return null;
        }
        int plus = name.indexOf(43);
        String normalized = plus >= 0 ? name.substring(plus + 1) : name;
        normalized = normalized.trim();
        return normalized.isEmpty() ? null : normalized.toLowerCase(Locale.ROOT);
    }

    private static void printUsage() {
        System.out.println("Type3SignatureTool - dump Type3 font signatures for library building\nUsage:\n  --pdf <file.pdf>          Input PDF to analyse (required)\n  --output <file.json>      Optional output file (defaults to stdout)\n  --pretty                  Pretty-print JSON output\n  --help                    Show this help\n\nExample:\n  ./gradlew :proprietary:type3SignatureTool --args=\"--pdf samples/foo.pdf --output foo.json --pretty\"\n");
    }
}

