/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.pdfjson.type3.library;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import stirling.software.SPDF.service.pdfjson.type3.Type3FontSignatureCalculator;
import stirling.software.SPDF.service.pdfjson.type3.library.Type3FontLibrary;
import stirling.software.SPDF.service.pdfjson.type3.library.Type3FontLibraryEntry;
import stirling.software.SPDF.service.pdfjson.type3.library.Type3FontLibraryMatch;
import stirling.software.SPDF.service.pdfjson.type3.library.Type3FontLibraryPayload;
import stirling.software.common.model.ApplicationProperties;

@Component
public class Type3FontLibrary {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Type3FontLibrary.class);
    private final ObjectMapper objectMapper;
    private final ResourceLoader resourceLoader;
    private final ApplicationProperties applicationProperties;
    private String indexLocation;
    private final Map<String, Type3FontLibraryEntry> signatureIndex = new ConcurrentHashMap();
    private final Map<String, Type3FontLibraryEntry> aliasIndex = new ConcurrentHashMap();
    private List<Type3FontLibraryEntry> entries = List.of();

    @PostConstruct
    void initialise() {
        if (this.applicationProperties.getPdfEditor() == null || this.applicationProperties.getPdfEditor().getType3() == null || this.applicationProperties.getPdfEditor().getType3().getLibrary() == null) {
            log.warn("[TYPE3] PdfEditor Type3 library configuration not available; Type3 library disabled");
            this.entries = List.of();
            return;
        }
        this.indexLocation = this.applicationProperties.getPdfEditor().getType3().getLibrary().getIndex();
        Resource resource = this.resourceLoader.getResource(this.indexLocation);
        if (!resource.exists()) {
            log.info("[TYPE3] Library index {} not found; Type3 library disabled", (Object)this.indexLocation);
            this.entries = List.of();
            return;
        }
        try (InputStream inputStream = resource.getInputStream();){
            List rawEntries = (List)this.objectMapper.readValue(inputStream, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            ArrayList<Type3FontLibraryEntry> loaded = new ArrayList<Type3FontLibraryEntry>();
            for (RawEntry rawEntry : rawEntries) {
                Type3FontLibraryEntry entry = this.toEntry(rawEntry);
                if (entry == null || !entry.hasAnyPayload()) continue;
                loaded.add(entry);
            }
            this.entries = Collections.unmodifiableList(loaded);
            this.signatureIndex.clear();
            this.aliasIndex.clear();
            for (Type3FontLibraryEntry entry : this.entries) {
                if (entry.getSignatures() != null) {
                    for (String signature : entry.getSignatures()) {
                        if (signature == null) continue;
                        String key = signature.toLowerCase(Locale.ROOT);
                        this.signatureIndex.putIfAbsent(key, entry);
                    }
                }
                if (entry.getAliases() == null) continue;
                for (String alias : entry.getAliases()) {
                    String normalized = this.normalizeAlias(alias);
                    if (normalized == null) continue;
                    this.aliasIndex.putIfAbsent(normalized, entry);
                }
            }
            log.info("[TYPE3] Loaded {} Type3 library entries (signatures={}, aliases={}) from {}", new Object[]{this.entries.size(), this.signatureIndex.size(), this.aliasIndex.size(), this.indexLocation});
        }
        catch (IOException ex) {
            log.warn("[TYPE3] Failed to load Type3 library index {}: {}", new Object[]{this.indexLocation, ex.getMessage(), ex});
            this.entries = List.of();
            this.signatureIndex.clear();
            this.aliasIndex.clear();
        }
    }

    public boolean isLoaded() {
        return !this.entries.isEmpty();
    }

    public Type3FontLibraryMatch match(PDType3Font font, String fontUid) throws IOException {
        Type3FontLibraryEntry entry;
        String aliasKey;
        if (font == null || this.entries.isEmpty()) {
            return null;
        }
        String signature = Type3FontSignatureCalculator.computeSignature((PDType3Font)font);
        if (signature != null) {
            Type3FontLibraryEntry entry2 = (Type3FontLibraryEntry)this.signatureIndex.get(signature.toLowerCase(Locale.ROOT));
            if (entry2 != null) {
                log.debug("[TYPE3] Matched Type3 font {} to library entry {} via signature {}", new Object[]{fontUid, entry2.getId(), signature});
                return Type3FontLibraryMatch.builder().entry(entry2).matchType("signature").signature(signature).build();
            }
            log.debug("[TYPE3] No library entry for signature {} (font {})", (Object)signature, (Object)(fontUid != null ? fontUid : font.getName()));
        }
        if ((aliasKey = this.normalizeAlias(this.resolveBaseFontName(font))) != null && (entry = (Type3FontLibraryEntry)this.aliasIndex.get(aliasKey)) != null) {
            log.debug("[TYPE3] Matched Type3 font {} to library entry {} via alias {}", new Object[]{fontUid, entry.getId(), aliasKey});
            return Type3FontLibraryMatch.builder().entry(entry).matchType("alias:" + aliasKey).signature(signature).build();
        }
        if (signature != null) {
            log.debug("[TYPE3] Library had no alias match for signature {} (font {})", (Object)signature, (Object)(fontUid != null ? fontUid : font.getName()));
        }
        return null;
    }

    private Type3FontLibraryEntry toEntry(RawEntry rawEntry) {
        if (rawEntry == null || rawEntry.id == null) {
            return null;
        }
        try {
            Type3FontLibraryEntry.Type3FontLibraryEntryBuilder builder = Type3FontLibraryEntry.builder().id(rawEntry.id).label(rawEntry.label != null ? rawEntry.label : rawEntry.id).signatures((Collection)this.normalizeList(rawEntry.signatures)).aliases((Collection)this.normalizeList(rawEntry.aliases)).program(this.loadPayload(rawEntry.program)).webProgram(this.loadPayload(rawEntry.webProgram)).pdfProgram(this.loadPayload(rawEntry.pdfProgram)).source(rawEntry.source);
            if (rawEntry.glyphCoverage != null && !rawEntry.glyphCoverage.isEmpty()) {
                for (Integer codePoint : rawEntry.glyphCoverage) {
                    if (codePoint == null) continue;
                    builder.glyphCode(codePoint);
                }
            }
            return builder.build();
        }
        catch (IOException ex) {
            log.warn("[TYPE3] Failed to load Type3 library entry {}: {}", (Object)rawEntry.id, (Object)ex.getMessage());
            return null;
        }
    }

    private Type3FontLibraryPayload loadPayload(RawPayload payload) throws IOException {
        if (payload == null) {
            return null;
        }
        byte[] data = null;
        if (payload.base64 != null && !payload.base64.isBlank()) {
            try {
                data = Base64.getDecoder().decode(payload.base64);
            }
            catch (IllegalArgumentException ex) {
                log.warn("[TYPE3] Invalid base64 payload in Type3 library: {}", (Object)ex.getMessage());
            }
        } else if (payload.resource != null && !payload.resource.isBlank()) {
            data = this.loadResourceBytes(payload.resource);
        }
        if (data == null || data.length == 0) {
            return null;
        }
        String base64 = Base64.getEncoder().encodeToString(data);
        return new Type3FontLibraryPayload(base64, this.normalizeFormat(payload.format));
    }

    private byte[] loadResourceBytes(String location) throws IOException {
        if (location == null || location.isBlank()) {
            throw new IOException("Resource location is null or blank");
        }
        String resolved = this.resolveLocation(location);
        Resource resource = this.resourceLoader.getResource(resolved);
        if (!resource.exists()) {
            throw new IOException("Resource not found: " + resolved);
        }
        try (InputStream inputStream = resource.getInputStream();){
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
    }

    private String resolveLocation(String location) {
        if (location == null || location.isBlank()) {
            return location;
        }
        if (location.contains(":")) {
            return location;
        }
        if (location.startsWith("/")) {
            return "classpath:" + location;
        }
        return "classpath:/" + location;
    }

    private List<String> normalizeList(List<String> values) {
        if (values == null || values.isEmpty()) {
            return List.of();
        }
        return values.stream().filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private String normalizeAlias(String alias) {
        if (alias == null) {
            return null;
        }
        String value = alias.trim();
        int plus = value.indexOf(43);
        if (plus >= 0 && plus < value.length() - 1) {
            value = value.substring(plus + 1);
        }
        return value.isEmpty() ? null : value.toLowerCase(Locale.ROOT);
    }

    private String normalizeFormat(String format) {
        if (format == null) {
            return null;
        }
        return format.trim().toLowerCase(Locale.ROOT);
    }

    private String resolveBaseFontName(PDType3Font font) {
        if (font == null) {
            return null;
        }
        String baseName = null;
        try {
            baseName = font.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (baseName == null && font.getCOSObject() != null) {
            baseName = font.getCOSObject().getNameAsString(COSName.BASE_FONT);
        }
        return baseName;
    }

    @Generated
    public Type3FontLibrary(ObjectMapper objectMapper, ResourceLoader resourceLoader, ApplicationProperties applicationProperties) {
        this.objectMapper = objectMapper;
        this.resourceLoader = resourceLoader;
        this.applicationProperties = applicationProperties;
    }
}

