/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import stirling.software.SPDF.model.json.PdfJsonCosValue;
import stirling.software.SPDF.model.json.PdfJsonStream;
import stirling.software.SPDF.service.PdfJsonCosMapper;

@Component
public class PdfJsonCosMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfJsonCosMapper.class);

    public PdfJsonStream serializeStream(PDStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return this.serializeStream(stream.getCOSObject(), Collections.newSetFromMap(new IdentityHashMap()));
    }

    public PdfJsonStream serializeStream(COSStream cosStream) throws IOException {
        if (cosStream == null) {
            return null;
        }
        return this.serializeStream(cosStream, Collections.newSetFromMap(new IdentityHashMap()));
    }

    public PdfJsonCosValue serializeCosValue(COSBase base) throws IOException {
        return this.serializeCosValue(base, Collections.newSetFromMap(new IdentityHashMap()));
    }

    public COSBase deserializeCosValue(PdfJsonCosValue value, PDDocument document) throws IOException {
        if (value == null || value.getType() == null) {
            return null;
        }
        switch (1.$SwitchMap$stirling$software$SPDF$model$json$PdfJsonCosValue$Type[value.getType().ordinal()]) {
            case 1: {
                return COSNull.NULL;
            }
            case 2: {
                Object object = value.getValue();
                if (object instanceof Boolean) {
                    Boolean bool = (Boolean)object;
                    return COSBoolean.getBoolean((Boolean)bool);
                }
                return null;
            }
            case 3: {
                Object object = value.getValue();
                if (object instanceof Number) {
                    Number number = (Number)object;
                    return COSInteger.get((long)number.longValue());
                }
                return null;
            }
            case 4: {
                Object object = value.getValue();
                if (object instanceof Number) {
                    Number number = (Number)object;
                    return new COSFloat(number.floatValue());
                }
                return null;
            }
            case 5: {
                Object object = value.getValue();
                if (object instanceof String) {
                    String name = (String)object;
                    return COSName.getPDFName((String)name);
                }
                return null;
            }
            case 6: {
                Object object = value.getValue();
                if (object instanceof String) {
                    String encoded = (String)object;
                    try {
                        byte[] bytes = Base64.getDecoder().decode(encoded);
                        return new COSString(bytes);
                    }
                    catch (IllegalArgumentException ex) {
                        log.debug("Failed to decode COSString value: {}", (Object)ex.getMessage());
                    }
                }
                return null;
            }
            case 7: {
                COSArray array = new COSArray();
                if (value.getItems() != null) {
                    for (PdfJsonCosValue item : value.getItems()) {
                        COSBase entry = this.deserializeCosValue(item, document);
                        if (entry != null) {
                            array.add(entry);
                            continue;
                        }
                        array.add((COSBase)COSNull.NULL);
                    }
                }
                return array;
            }
            case 8: {
                COSDictionary dictionary = new COSDictionary();
                if (value.getEntries() != null) {
                    for (Map.Entry entry : value.getEntries().entrySet()) {
                        COSName key = COSName.getPDFName((String)((String)entry.getKey()));
                        COSBase entryValue = this.deserializeCosValue((PdfJsonCosValue)entry.getValue(), document);
                        if (entryValue == null) continue;
                        dictionary.setItem(key, entryValue);
                    }
                }
                return dictionary;
            }
            case 9: {
                if (value.getStream() != null) {
                    return this.buildStreamFromModel(value.getStream(), document);
                }
                return null;
            }
        }
        return null;
    }

    public COSStream buildStreamFromModel(PdfJsonStream streamModel, PDDocument document) throws IOException {
        String rawData;
        if (streamModel == null) {
            return null;
        }
        COSStream cosStream = document.getDocument().createCOSStream();
        if (streamModel.getDictionary() != null) {
            for (Map.Entry entry : streamModel.getDictionary().entrySet()) {
                COSName key = COSName.getPDFName((String)((String)entry.getKey()));
                COSBase value = this.deserializeCosValue((PdfJsonCosValue)entry.getValue(), document);
                if (value == null) continue;
                cosStream.setItem(key, value);
            }
        }
        if ((rawData = streamModel.getRawData()) != null && !rawData.isBlank()) {
            byte[] data;
            try {
                data = Base64.getDecoder().decode(rawData);
            }
            catch (IllegalArgumentException ex) {
                log.debug("Invalid base64 content stream data: {}", (Object)ex.getMessage());
                data = new byte[]{};
            }
            try (OutputStream outputStream = cosStream.createRawOutputStream();){
                outputStream.write(data);
            }
            cosStream.setItem(COSName.LENGTH, (COSBase)COSInteger.get((long)data.length));
        } else {
            cosStream.setItem(COSName.LENGTH, (COSBase)COSInteger.get((long)0L));
        }
        return cosStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PdfJsonCosValue serializeCosValue(COSBase base, Set<COSBase> visited) throws IOException {
        boolean complex;
        COSObject cosObject;
        if (base == null) {
            return null;
        }
        if (base instanceof COSObject && (base = (cosObject = (COSObject)base).getObject()) == null) {
            return null;
        }
        boolean bl = complex = base instanceof COSDictionary || base instanceof COSArray || base instanceof COSStream;
        if (complex && !visited.add(base)) {
            return PdfJsonCosValue.builder().type(PdfJsonCosValue.Type.NAME).value((Object)"__circular__").build();
        }
        try {
            PdfJsonCosValue.PdfJsonCosValueBuilder builder = PdfJsonCosValue.builder();
            if (base instanceof COSNull) {
                builder.type(PdfJsonCosValue.Type.NULL);
                PdfJsonCosValue pdfJsonCosValue = builder.build();
                return pdfJsonCosValue;
            }
            if (base instanceof COSBoolean) {
                COSBoolean booleanValue = (COSBoolean)base;
                builder.type(PdfJsonCosValue.Type.BOOLEAN).value((Object)booleanValue.getValue());
                PdfJsonCosValue pdfJsonCosValue = builder.build();
                return pdfJsonCosValue;
            }
            if (base instanceof COSInteger) {
                COSInteger integer = (COSInteger)base;
                builder.type(PdfJsonCosValue.Type.INTEGER).value((Object)integer.longValue());
                PdfJsonCosValue pdfJsonCosValue = builder.build();
                return pdfJsonCosValue;
            }
            if (base instanceof COSFloat) {
                COSFloat floatValue = (COSFloat)base;
                builder.type(PdfJsonCosValue.Type.FLOAT).value((Object)Float.valueOf(floatValue.floatValue()));
                PdfJsonCosValue pdfJsonCosValue = builder.build();
                return pdfJsonCosValue;
            }
            if (base instanceof COSName) {
                COSName name = (COSName)base;
                builder.type(PdfJsonCosValue.Type.NAME).value((Object)name.getName());
                PdfJsonCosValue pdfJsonCosValue = builder.build();
                return pdfJsonCosValue;
            }
            if (base instanceof COSString) {
                COSString cosString = (COSString)base;
                builder.type(PdfJsonCosValue.Type.STRING).value((Object)Base64.getEncoder().encodeToString(cosString.getBytes()));
                PdfJsonCosValue pdfJsonCosValue = builder.build();
                return pdfJsonCosValue;
            }
            if (base instanceof COSArray) {
                COSArray array = (COSArray)base;
                ArrayList<PdfJsonCosValue> items = new ArrayList<PdfJsonCosValue>(array.size());
                for (COSBase item : array) {
                    PdfJsonCosValue serialized = this.serializeCosValue(item, visited);
                    items.add(serialized);
                }
                builder.type(PdfJsonCosValue.Type.ARRAY).items(items);
                Iterator iterator = builder.build();
                return iterator;
            }
            if (base instanceof COSStream) {
                COSStream stream = (COSStream)base;
                builder.type(PdfJsonCosValue.Type.STREAM).stream(this.serializeStream(stream, visited));
                PdfJsonCosValue items = builder.build();
                return items;
            }
            if (base instanceof COSDictionary) {
                COSDictionary dictionary = (COSDictionary)base;
                LinkedHashMap<String, PdfJsonCosValue> entries = new LinkedHashMap<String, PdfJsonCosValue>();
                for (COSName key : dictionary.keySet()) {
                    PdfJsonCosValue serialized = this.serializeCosValue(dictionary.getDictionaryObject(key), visited);
                    entries.put(key.getName(), serialized);
                }
                builder.type(PdfJsonCosValue.Type.DICTIONARY).entries(entries);
                PdfJsonCosValue pdfJsonCosValue = builder.build();
                return pdfJsonCosValue;
            }
            PdfJsonCosValue pdfJsonCosValue = null;
            return pdfJsonCosValue;
        }
        finally {
            if (complex) {
                visited.remove(base);
            }
        }
    }

    private PdfJsonStream serializeStream(COSStream cosStream, Set<COSBase> visited) throws IOException {
        LinkedHashMap<String, PdfJsonCosValue> dictionary = new LinkedHashMap<String, PdfJsonCosValue>();
        for (COSName key : cosStream.keySet()) {
            COSBase value = cosStream.getDictionaryObject(key);
            PdfJsonCosValue serialized = this.serializeCosValue(value, visited);
            if (serialized == null) continue;
            dictionary.put(key.getName(), serialized);
        }
        String rawData = null;
        try (InputStream inputStream = cosStream.createRawInputStream();
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] data;
            if (inputStream != null) {
                inputStream.transferTo(baos);
            }
            if ((data = baos.toByteArray()).length > 0) {
                rawData = Base64.getEncoder().encodeToString(data);
            }
        }
        return PdfJsonStream.builder().dictionary(dictionary).rawData(rawData).build();
    }
}

