/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;
import stirling.software.common.model.ApplicationProperties;

@Service
public class LanguageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LanguageService.class);
    private final ApplicationProperties applicationProperties;
    private final PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public LanguageService(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public Set<String> getSupportedLanguages() {
        try {
            Resource[] resources = this.getResourcesFromPattern("classpath*:messages_*.properties");
            return Arrays.stream(resources).map(Resource::getFilename).filter(filename -> filename != null && filename.startsWith("messages_") && filename.endsWith(".properties")).map(filename -> filename.replace("messages_", "").replace(".properties", "")).filter(languageCode -> {
                HashSet allowedLanguages = new HashSet(this.applicationProperties.getUi().getLanguages());
                return allowedLanguages.isEmpty() || allowedLanguages.contains(languageCode) || "en_GB".equals(languageCode);
            }).collect(Collectors.toSet());
        }
        catch (IOException e) {
            log.error("Error retrieving supported languages", (Throwable)e);
            return new HashSet<String>();
        }
    }

    protected Resource[] getResourcesFromPattern(String pattern) throws IOException {
        return this.resourcePatternResolver.getResources(pattern);
    }
}

