/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.Generated;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import stirling.software.SPDF.service.CertificateValidationService;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.ServerCertificateServiceInterface;

@Service
public class CertificateValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateValidationService.class);
    private KeyStore signingTrustAnchors;
    private final ServerCertificateServiceInterface serverCertificateService;
    private final ApplicationProperties applicationProperties;
    private static final String NS_TSL = "http://uri.etsi.org/02231/v2#";
    private static final Set<String> EUTL_SERVICE_TYPES = new HashSet<String>(Arrays.asList("http://uri.etsi.org/TrstSvc/Svctype/CA/QC", "http://uri.etsi.org/TrstSvc/Svctype/NationalRootCA-QC"));
    private static final String STATUS_UNDER_SUPERVISION = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/undersupervision";
    private static final String STATUS_ACCREDITED = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/accredited";
    private static final String STATUS_SUPERVISION_IN_CESSATION = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/supervisionincessation";

    public CertificateValidationService(@Autowired(required=false) ServerCertificateServiceInterface serverCertificateService, ApplicationProperties applicationProperties) {
        this.serverCertificateService = serverCertificateService;
        this.applicationProperties = applicationProperties;
    }

    @PostConstruct
    private void initializeTrustStore() throws Exception {
        this.signingTrustAnchors = KeyStore.getInstance(KeyStore.getDefaultType());
        this.signingTrustAnchors.load(null, null);
        ApplicationProperties.Security.Validation validation = this.applicationProperties.getSecurity().getValidation();
        if (validation.isAllowAIA()) {
            Security.setProperty("ocsp.enable", "true");
            System.setProperty("com.sun.security.enableCRLDP", "true");
            System.setProperty("com.sun.security.enableAIAcaIssuers", "true");
            log.info("Enabled AIA certificate fetching and revocation checking");
        }
        if (validation.getTrust().isServerAsAnchor()) {
            this.loadServerCertAsAnchor();
        }
        if (validation.getTrust().isUseSystemTrust()) {
            this.loadJavaSystemTrustStore();
        }
        if (validation.getTrust().isUseMozillaBundle()) {
            this.loadBundledMozillaCACerts();
        }
        if (validation.getTrust().isUseAATL()) {
            this.loadAATLCertificates();
        }
        if (validation.getTrust().isUseEUTL()) {
            this.loadEUTLCertificates();
        }
    }

    public PKIXCertPathBuilderResult buildAndValidatePath(X509Certificate signerCert, Collection<X509Certificate> intermediates, X509Certificate customTrustAnchor, Date validationTime) throws GeneralSecurityException {
        HashSet<TrustAnchor> anchors = new HashSet<TrustAnchor>();
        if (customTrustAnchor != null) {
            anchors.add(new TrustAnchor(customTrustAnchor, null));
        } else {
            Enumeration<String> aliases = this.signingTrustAnchors.aliases();
            while (aliases.hasMoreElements()) {
                Certificate c = this.signingTrustAnchors.getCertificate(aliases.nextElement());
                if (!(c instanceof X509Certificate)) continue;
                X509Certificate x = (X509Certificate)c;
                anchors.add(new TrustAnchor(x, null));
            }
        }
        if (anchors.isEmpty()) {
            throw new CertPathBuilderException("No trust anchors available");
        }
        X509CertSelector target = new X509CertSelector();
        target.setCertificate(signerCert);
        ArrayList<X509Certificate> allCerts = new ArrayList<X509Certificate>(intermediates);
        CertStore intermediateStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(allCerts));
        PKIXBuilderParameters params = new PKIXBuilderParameters(anchors, (CertSelector)target);
        params.addCertStore(intermediateStore);
        String revocationMode = this.applicationProperties.getSecurity().getValidation().getRevocation().getMode();
        params.setRevocationEnabled(!"none".equalsIgnoreCase(revocationMode));
        if (validationTime != null) {
            params.setDate(validationTime);
        }
        if (!"none".equalsIgnoreCase(revocationMode)) {
            try {
                PKIXRevocationChecker rc = (PKIXRevocationChecker)CertPathValidator.getInstance("PKIX").getRevocationChecker();
                EnumSet<PKIXRevocationChecker.Option> options = EnumSet.noneOf(PKIXRevocationChecker.Option.class);
                boolean revocationHardFail = this.applicationProperties.getSecurity().getValidation().getRevocation().isHardFail();
                if (!revocationHardFail) {
                    options.add(PKIXRevocationChecker.Option.SOFT_FAIL);
                }
                if ("ocsp".equalsIgnoreCase(revocationMode)) {
                    options.add(PKIXRevocationChecker.Option.NO_FALLBACK);
                } else if ("crl".equalsIgnoreCase(revocationMode)) {
                    options.add(PKIXRevocationChecker.Option.PREFER_CRLS);
                    options.add(PKIXRevocationChecker.Option.NO_FALLBACK);
                }
                rc.setOptions(options);
                params.addCertPathChecker(rc);
            }
            catch (Exception e) {
                log.warn("Failed to configure revocation checker: {}", (Object)e.getMessage());
            }
        }
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
        return (PKIXCertPathBuilderResult)builder.build(params);
    }

    public ValidationTime extractValidationTime(SignerInformation signerInfo) {
        try {
            Attribute st;
            AttributeTable signedAttrs;
            Attribute attr;
            AttributeTable unsignedAttrs = signerInfo.getUnsignedAttributes();
            if (unsignedAttrs != null && (attr = unsignedAttrs.get(new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.14"))) != null) {
                try {
                    TimeStampToken tst = new TimeStampToken(new CMSSignedData(attr.getAttributeValues()[0].toASN1Primitive().getEncoded()));
                    Date tstTime = tst.getTimeStampInfo().getGenTime();
                    log.debug("Using timestamp token time: {}", (Object)tstTime);
                    return new ValidationTime(tstTime, "timestamp");
                }
                catch (Exception e) {
                    log.debug("Failed to parse timestamp token: {}", (Object)e.getMessage());
                }
            }
            if ((signedAttrs = signerInfo.getSignedAttributes()) != null && (st = signedAttrs.get(CMSAttributes.signingTime)) != null) {
                ASN1Encodable val = st.getAttributeValues()[0];
                Date signingTime = null;
                if (val instanceof ASN1UTCTime) {
                    ASN1UTCTime ut = (ASN1UTCTime)val;
                    signingTime = ut.getDate();
                } else if (val instanceof ASN1GeneralizedTime) {
                    ASN1GeneralizedTime gt = (ASN1GeneralizedTime)val;
                    signingTime = gt.getDate();
                }
                if (signingTime != null) {
                    log.debug("Using signingTime attribute: {}", (Object)signingTime);
                    return new ValidationTime(signingTime, "signing-time");
                }
            }
        }
        catch (Exception e) {
            log.debug("Error extracting validation time: {}", (Object)e.getMessage());
        }
        return null;
    }

    public boolean isOutsideValidityPeriod(X509Certificate cert, Date at) {
        try {
            cert.checkValidity(at);
            return false;
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            return true;
        }
    }

    public boolean isRevocationEnabled() {
        String revocationMode = this.applicationProperties.getSecurity().getValidation().getRevocation().getMode();
        return !"none".equalsIgnoreCase(revocationMode);
    }

    public boolean isCA(X509Certificate cert) {
        return cert.getBasicConstraints() >= 0;
    }

    public boolean isSelfSigned(X509Certificate cert) {
        try {
            if (!cert.getSubjectX500Principal().equals(cert.getIssuerX500Principal())) {
                return false;
            }
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String sha256Fingerprint(X509Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(cert.getEncoded());
            return this.bytesToHex(hash);
        }
        catch (Exception e) {
            return "";
        }
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public Collection<X509Certificate> extractIntermediateCertificates(Store<X509CertificateHolder> certStore, X509Certificate signerCert) {
        ArrayList<X509Certificate> intermediates = new ArrayList<X509Certificate>();
        try {
            JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
            Collection holders = certStore.getMatches(null);
            for (X509CertificateHolder holder : holders) {
                X509Certificate cert = converter.getCertificate(holder);
                if (cert.equals(signerCert)) continue;
                intermediates.add(cert);
            }
        }
        catch (Exception e) {
            log.debug("Error extracting intermediate certificates: {}", (Object)e.getMessage());
        }
        return intermediates;
    }

    private void loadJavaSystemTrustStore() {
        try {
            log.info("Loading certificates from Java system trust store");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            int loadedCount = 0;
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                X509TrustManager x509tm = (X509TrustManager)tm;
                for (X509Certificate cert : x509tm.getAcceptedIssuers()) {
                    if (!this.isCA(cert)) continue;
                    String fingerprint = this.sha256Fingerprint(cert);
                    String alias = "system-" + fingerprint;
                    this.signingTrustAnchors.setCertificateEntry(alias, cert);
                    ++loadedCount;
                }
            }
            log.info("Loaded {} CA certificates from Java system trust store", (Object)loadedCount);
        }
        catch (Exception e) {
            log.error("Failed to load Java system trust store: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void loadBundledMozillaCACerts() {
        try {
            log.info("Loading bundled Mozilla CA certificates from resources");
            try (InputStream certStream = this.getClass().getClassLoader().getResourceAsStream("certs/cacert.pem");){
                if (certStream == null) {
                    log.warn("Bundled Mozilla CA certificate file not found in resources");
                    return;
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certs = cf.generateCertificates(certStream);
                int loadedCount = 0;
                int skippedCount = 0;
                for (Certificate certificate : certs) {
                    if (!(certificate instanceof X509Certificate)) continue;
                    X509Certificate x509 = (X509Certificate)certificate;
                    if (this.isCA(x509)) {
                        String fingerprint = this.sha256Fingerprint(x509);
                        String alias = "mozilla-" + fingerprint;
                        this.signingTrustAnchors.setCertificateEntry(alias, x509);
                        ++loadedCount;
                        continue;
                    }
                    ++skippedCount;
                }
                log.info("Loaded {} Mozilla CA certificates as trust anchors (skipped {} non-CA certs)", (Object)loadedCount, (Object)skippedCount);
            }
        }
        catch (Exception e) {
            log.error("Failed to load bundled Mozilla CA certificates: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void loadServerCertAsAnchor() {
        try {
            if (this.serverCertificateService != null && this.serverCertificateService.isEnabled() && this.serverCertificateService.hasServerCertificate()) {
                X509Certificate serverCert = this.serverCertificateService.getServerCertificate();
                boolean selfSigned = this.isSelfSigned(serverCert);
                boolean ca = this.isCA(serverCert);
                if (selfSigned || ca) {
                    this.signingTrustAnchors.setCertificateEntry("server-anchor", serverCert);
                    log.info("Loaded server certificate as trust anchor (self-signed: {}, CA: {})", (Object)selfSigned, (Object)ca);
                } else {
                    log.warn("Server certificate is neither self-signed nor a CA; not adding as trust anchor");
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed loading server certificate as anchor: {}", (Object)e.getMessage());
        }
    }

    private void loadAATLCertificates() {
        try {
            String aatlUrl = this.applicationProperties.getSecurity().getValidation().getAatl().getUrl();
            log.info("Loading Adobe Approved Trust List (AATL) from: {}", (Object)aatlUrl);
            byte[] pdfBytes = this.downloadTrustList(aatlUrl);
            if (pdfBytes == null) {
                log.warn("AATL download returned no data");
                return;
            }
            int added = this.parseAATLPdf(pdfBytes);
            log.info("Loaded {} AATL CA certificates into signing trust", (Object)added);
        }
        catch (Exception e) {
            log.warn("Failed to load AATL: {}", (Object)e.getMessage());
            log.debug("AATL loading error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] downloadTrustList(String urlStr) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(30000);
            conn.setInstanceFollowRedirects(true);
            int code = conn.getResponseCode();
            if (code == 200) {
                try (InputStream in = conn.getInputStream();){
                    byte[] byArray;
                    try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                        int r;
                        byte[] buf = new byte[8192];
                        while ((r = in.read(buf)) != -1) {
                            out.write(buf, 0, r);
                        }
                        byArray = out.toByteArray();
                    }
                    return byArray;
                }
            }
            log.warn("AATL download failed: HTTP {}", (Object)code);
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e) {
            log.warn("AATL download error: {}", (Object)e.getMessage());
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private int parseAATLPdf(byte[] pdfBytes) throws Exception {
        try (PDDocument doc = Loader.loadPDF((byte[])pdfBytes);){
            Integer count;
            PDDocumentNameDictionary names = doc.getDocumentCatalog().getNames();
            if (names == null) {
                log.warn("AATL PDF has no name dictionary");
                int n = 0;
                return n;
            }
            PDEmbeddedFilesNameTreeNode efRoot = names.getEmbeddedFiles();
            if (efRoot == null) {
                log.warn("AATL PDF has no embedded files");
                int n = 0;
                return n;
            }
            Map top = efRoot.getNames();
            if (top != null && (count = this.tryParseSecuritySettingsXML(top)) != null) {
                int n = count;
                return n;
            }
            List kids = efRoot.getKids();
            if (kids != null) {
                for (Object kidObj : kids) {
                    Integer count2;
                    PDEmbeddedFilesNameTreeNode kid;
                    Map map;
                    if (!(kidObj instanceof PDEmbeddedFilesNameTreeNode) || (map = (kid = (PDEmbeddedFilesNameTreeNode)kidObj).getNames()) == null || (count2 = this.tryParseSecuritySettingsXML(map)) == null) continue;
                    int n = count2;
                    return n;
                }
            }
            log.warn("AATL PDF did not contain SecuritySettings.xml");
            int n = 0;
            return n;
        }
    }

    private Integer tryParseSecuritySettingsXML(Map<String, PDComplexFileSpecification> nameMap) {
        Integer n;
        block10: {
            PDComplexFileSpecification fileSpec = nameMap.get("SecuritySettings.xml");
            if (fileSpec == null) {
                return null;
            }
            PDEmbeddedFile ef = fileSpec.getEmbeddedFile();
            if (ef == null) {
                return null;
            }
            COSInputStream xmlStream = ef.createInputStream();
            try {
                n = this.parseSecuritySettingsXML((InputStream)xmlStream);
                if (xmlStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (xmlStream != null) {
                        try {
                            xmlStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Failed parsing SecuritySettings.xml: {}", (Object)e.getMessage());
                    log.debug("SecuritySettings.xml parse error", (Throwable)e);
                    return null;
                }
            }
            xmlStream.close();
        }
        return n;
    }

    private int parseSecuritySettingsXML(InputStream xmlStream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(xmlStream);
        NodeList certNodes = doc.getElementsByTagName("Certificate");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        int added = 0;
        for (int i = 0; i < certNodes.getLength(); ++i) {
            String base64 = certNodes.item(i).getTextContent().trim();
            if (base64.isEmpty()) continue;
            try {
                byte[] certBytes = Base64.getMimeDecoder().decode(base64);
                X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
                if (this.isCA(cert)) {
                    String fingerprint = this.sha256Fingerprint(cert);
                    String alias = "aatl-" + fingerprint;
                    if (this.signingTrustAnchors.getCertificate(alias) != null) continue;
                    this.signingTrustAnchors.setCertificateEntry(alias, cert);
                    ++added;
                    continue;
                }
                log.debug("Skipping non-CA certificate from AATL: {}", (Object)cert.getSubjectX500Principal().getName());
                continue;
            }
            catch (Exception e) {
                log.debug("Failed to parse an AATL certificate node: {}", (Object)e.getMessage());
            }
        }
        return added;
    }

    private void loadEUTLCertificates() {
        try {
            String lotlUrl = this.applicationProperties.getSecurity().getValidation().getEutl().getLotlUrl();
            log.info("Loading EU Trusted List (LOTL) from: {}", (Object)lotlUrl);
            byte[] lotlBytes = this.downloadXml(lotlUrl);
            if (lotlBytes == null) {
                log.warn("LOTL download returned no data");
                return;
            }
            List tslUrls = this.parseLotlForTslLocations(lotlBytes);
            log.info("Found {} national TSL locations in LOTL", (Object)tslUrls.size());
            int totalAdded = 0;
            for (String tslUrl : tslUrls) {
                try {
                    byte[] tslBytes = this.downloadXml(tslUrl);
                    if (tslBytes == null) {
                        log.warn("TSL download failed: {}", (Object)tslUrl);
                        continue;
                    }
                    int added = this.parseTslAndAddCas(tslBytes, tslUrl);
                    totalAdded += added;
                }
                catch (Exception e) {
                    log.warn("Failed to parse TSL {}: {}", (Object)tslUrl, (Object)e.getMessage());
                    log.debug("TSL parse error", (Throwable)e);
                }
            }
            log.info("Imported {} qualified CA certificates from EUTL", (Object)totalAdded);
        }
        catch (Exception e) {
            log.warn("EUTL load failed: {}", (Object)e.getMessage());
            log.debug("EUTL load error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] downloadXml(String urlStr) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(30000);
            conn.setInstanceFollowRedirects(true);
            int code = conn.getResponseCode();
            if (code == 200) {
                try (InputStream in = conn.getInputStream();){
                    byte[] byArray;
                    try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                        int r;
                        byte[] buf = new byte[8192];
                        while ((r = in.read(buf)) != -1) {
                            out.write(buf, 0, r);
                        }
                        byArray = out.toByteArray();
                    }
                    return byArray;
                }
            }
            log.warn("XML download failed: HTTP {} for {}", (Object)code, (Object)urlStr);
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e) {
            log.warn("XML download error for {}: {}", (Object)urlStr, (Object)e.getMessage());
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private List<String> parseLotlForTslLocations(byte[] lotlBytes) throws Exception {
        DocumentBuilderFactory dbf = this.secureDbfWithNamespaces();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new ByteArrayInputStream(lotlBytes));
        ArrayList<String> out = new ArrayList<String>();
        NodeList ptrs = doc.getElementsByTagNameNS(NS_TSL, "PointersToOtherTSL");
        if (ptrs.getLength() == 0) {
            return out;
        }
        Element ptrRoot = (Element)ptrs.item(0);
        NodeList locations = ptrRoot.getElementsByTagNameNS(NS_TSL, "TSLLocation");
        for (int i = 0; i < locations.getLength(); ++i) {
            String url = locations.item(i).getTextContent().trim();
            if (url.isEmpty()) continue;
            out.add(url);
        }
        return out;
    }

    private int parseTslAndAddCas(byte[] tslBytes, String sourceUrl) throws Exception {
        DocumentBuilderFactory dbf = this.secureDbfWithNamespaces();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new ByteArrayInputStream(tslBytes));
        int added = 0;
        NodeList services = doc.getElementsByTagNameNS(NS_TSL, "TSPService");
        for (int i = 0; i < services.getLength(); ++i) {
            Element sdi;
            String status;
            String type;
            Element svc = (Element)services.item(i);
            Element info = this.firstChildNS(svc, "ServiceInformation");
            if (info == null || !EUTL_SERVICE_TYPES.contains(type = this.textOf(info, "ServiceTypeIdentifier")) || !this.isActiveStatus(status = this.textOf(info, "ServiceStatus")) || (sdi = this.firstChildNS(info, "ServiceDigitalIdentity")) == null) continue;
            NodeList digitalIds = sdi.getElementsByTagNameNS(NS_TSL, "DigitalId");
            for (int d = 0; d < digitalIds.getLength(); ++d) {
                Element did = (Element)digitalIds.item(d);
                NodeList certNodes = did.getElementsByTagNameNS(NS_TSL, "X509Certificate");
                for (int c = 0; c < certNodes.getLength(); ++c) {
                    String base64 = certNodes.item(c).getTextContent().trim();
                    if (base64.isEmpty()) continue;
                    try {
                        byte[] certBytes = Base64.getMimeDecoder().decode(base64);
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
                        if (!this.isCA(cert)) {
                            log.debug("Skipping non-CA in TSL {}: {}", (Object)sourceUrl, (Object)cert.getSubjectX500Principal().getName());
                            continue;
                        }
                        String fp = this.sha256Fingerprint(cert);
                        String alias = "eutl-" + fp;
                        if (this.signingTrustAnchors.getCertificate(alias) != null) continue;
                        this.signingTrustAnchors.setCertificateEntry(alias, cert);
                        ++added;
                        continue;
                    }
                    catch (Exception e) {
                        log.debug("Failed to import a certificate from {}: {}", (Object)sourceUrl, (Object)e.getMessage());
                    }
                }
            }
        }
        log.debug("TSL {} \u2192 imported {} CA certificates", (Object)sourceUrl, (Object)added);
        return added;
    }

    private boolean isActiveStatus(String statusUri) {
        if (STATUS_UNDER_SUPERVISION.equals(statusUri)) {
            return true;
        }
        if (STATUS_ACCREDITED.equals(statusUri)) {
            return true;
        }
        boolean acceptTransitional = this.applicationProperties.getSecurity().getValidation().getEutl().isAcceptTransitional();
        return acceptTransitional && STATUS_SUPERVISION_IN_CESSATION.equals(statusUri);
    }

    private DocumentBuilderFactory secureDbfWithNamespaces() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        return factory;
    }

    private Element firstChildNS(Element parent, String localName) {
        NodeList nl = parent.getElementsByTagNameNS(NS_TSL, localName);
        return nl.getLength() == 0 ? null : (Element)nl.item(0);
    }

    private String textOf(Element parent, String localName) {
        Element e = this.firstChildNS(parent, localName);
        return e == null ? "" : e.getTextContent().trim();
    }

    public KeyStore getSigningTrustStore() {
        return this.signingTrustAnchors;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

