/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.security;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.core.ValidationException;
import stirling.software.SPDF.model.api.security.PDFVerificationRequest;
import stirling.software.SPDF.model.api.security.PDFVerificationResult;
import stirling.software.SPDF.service.VeraPDFService;
import stirling.software.common.util.ExceptionUtils;

@RestController
@RequestMapping(value={"/api/v1/security"})
@Tag(name="Security", description="Security APIs")
public class VerifyPDFController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerifyPDFController.class);
    private final VeraPDFService veraPDFService;

    @Operation(summary="Verify PDF Standards Compliance", description="Validates PDF files against the standards declared in their metadata. Automatically detects PDF/A, PDF/UA-1, PDF/UA-2, and WTPDF standards from the document's XMP metadata and validates compliance. Input:PDF Output:JSON Type:SISO")
    @PostMapping(value={"/verify-pdf"}, consumes={"multipart/form-data"})
    public ResponseEntity<List<PDFVerificationResult>> verifyPDF(@ModelAttribute PDFVerificationRequest request) {
        MultipartFile file = request.getFileInput();
        if (file == null || file.isEmpty()) {
            throw ExceptionUtils.createRuntimeException((String)"error.pdfRequired", (String)"PDF file is required", null, (Object[])new Object[0]);
        }
        try {
            log.info("Detecting and verifying standards in PDF '{}'", (Object)file.getOriginalFilename());
            List results = this.veraPDFService.validatePDF(file.getInputStream());
            log.info("Verification complete for '{}': {} standard(s) checked", (Object)file.getOriginalFilename(), (Object)results.size());
            return ResponseEntity.ok((Object)results);
        }
        catch (ValidationException e) {
            log.error("Validation exception for file: {}", (Object)file.getOriginalFilename(), (Object)e);
            throw ExceptionUtils.createRuntimeException((String)"error.validationFailed", (String)"PDF validation failed: {0}", (Exception)((Object)e), (Object[])new Object[]{e.getMessage()});
        }
        catch (ModelParsingException e) {
            log.error("Model parsing exception for file: {}", (Object)file.getOriginalFilename(), (Object)e);
            throw ExceptionUtils.createRuntimeException((String)"error.modelParsingFailed", (String)"PDF model parsing failed: {0}", (Exception)((Object)e), (Object[])new Object[]{e.getMessage()});
        }
        catch (EncryptedPdfException e) {
            log.error("Encrypted PDF exception for file: {}", (Object)file.getOriginalFilename(), (Object)e);
            throw ExceptionUtils.createRuntimeException((String)"error.encryptedPdf", (String)"Cannot verify encrypted PDF. Please remove password first: {0}", (Exception)((Object)e), (Object[])new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            log.error("IO exception for file: {}", (Object)file.getOriginalFilename(), (Object)e);
            throw ExceptionUtils.createRuntimeException((String)"error.ioException", (String)"IO error during PDF verification: {0}", (Exception)e, (Object[])new Object[]{e.getMessage()});
        }
    }

    @Generated
    public VerifyPDFController(VeraPDFService veraPDFService) {
        this.veraPDFService = veraPDFService;
    }
}

