/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.awt.image.BufferedImage;
import java.io.IOException;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.misc.FlattenRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ApplicationContextProvider;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class FlattenController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlattenController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/flatten"})
    @StandardPdfResponse
    @Operation(summary="Flatten PDF form fields or full page", description="Flattening just PDF form fields or converting each page to images to make text unselectable. Input:PDF, Output:PDF. Type:SISO")
    public ResponseEntity<byte[]> flatten(@ModelAttribute FlattenRequest request) throws Exception {
        MultipartFile file = request.getFileInput();
        try (PDDocument document = this.pdfDocumentFactory.load(file);){
            ResponseEntity responseEntity;
            block31: {
                Boolean flattenOnlyForms = request.getFlattenOnlyForms();
                if (Boolean.TRUE.equals(flattenOnlyForms)) {
                    PDAcroForm acroForm = document.getDocumentCatalog().getAcroForm();
                    if (acroForm != null) {
                        acroForm.flatten();
                    }
                    ResponseEntity responseEntity2 = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)Filenames.toSimpleFileName((String)file.getOriginalFilename()));
                    return responseEntity2;
                }
                PDFRenderer pdfRenderer = new PDFRenderer(document);
                pdfRenderer.setSubsamplingAllowed(true);
                PDDocument newDocument = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(document);
                try {
                    int defaultRenderDpi = 100;
                    ApplicationProperties properties = (ApplicationProperties)ApplicationContextProvider.getBean(ApplicationProperties.class);
                    Integer configuredMaxDpi = null;
                    if (properties != null && properties.getSystem() != null) {
                        configuredMaxDpi = properties.getSystem().getMaxDPI();
                    }
                    int maxDpi = configuredMaxDpi != null && configuredMaxDpi > 0 ? configuredMaxDpi : defaultRenderDpi;
                    Integer requestedDpi = request.getRenderDpi();
                    int renderDpiTemp = maxDpi;
                    if (requestedDpi != null) {
                        renderDpiTemp = Math.min(requestedDpi, maxDpi);
                        renderDpiTemp = Math.max(renderDpiTemp, 72);
                    }
                    int renderDpi = renderDpiTemp;
                    int numPages = document.getNumberOfPages();
                    for (int i = 0; i < numPages; ++i) {
                        int pageIndex = i;
                        BufferedImage image = null;
                        try {
                            ExceptionUtils.validateRenderingDimensions((PDPage)document.getPage(pageIndex), (int)(pageIndex + 1), (int)renderDpi);
                            image = (BufferedImage)ExceptionUtils.handleOomRendering((int)(pageIndex + 1), (int)renderDpi, () -> pdfRenderer.renderImageWithDPI(pageIndex, (float)renderDpi, ImageType.RGB));
                            PDPage page = new PDPage();
                            page.setMediaBox(document.getPage(i).getMediaBox());
                            newDocument.addPage(page);
                            try (PDPageContentStream contentStream = new PDPageContentStream(newDocument, page, PDPageContentStream.AppendMode.OVERWRITE, true, true);){
                                PDImageXObject pdImage = JPEGFactory.createFromImage((PDDocument)newDocument, (BufferedImage)image);
                                float pageWidth = page.getMediaBox().getWidth();
                                float pageHeight = page.getMediaBox().getHeight();
                                contentStream.drawImage(pdImage, 0.0f, 0.0f, pageWidth, pageHeight);
                                continue;
                            }
                        }
                        catch (ExceptionUtils.OutOfMemoryDpiException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            log.error("IOException during page processing: ", (Throwable)e);
                            continue;
                        }
                        catch (OutOfMemoryError e) {
                            throw ExceptionUtils.createOutOfMemoryDpiException((int)(i + 1), (int)renderDpi, (OutOfMemoryError)e);
                        }
                        finally {
                            image = null;
                        }
                    }
                    responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)newDocument, (String)Filenames.toSimpleFileName((String)file.getOriginalFilename()));
                    if (newDocument == null) break block31;
                }
                catch (Throwable throwable) {
                    if (newDocument != null) {
                        try {
                            newDocument.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                newDocument.close();
            }
            return responseEntity;
        }
    }

    @Generated
    public FlattenController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

