/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import lombok.Generated;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.controller.api.misc.CompressController;
import stirling.software.SPDF.model.api.misc.OptimizePdfRequest;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.service.LineArtConversionService;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/misc"})
@Tag(name="Misc", description="Miscellaneous APIs")
public class CompressController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompressController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final EndpointConfiguration endpointConfiguration;
    private final TempFileManager tempFileManager;
    @Autowired(required=false)
    private LineArtConversionService lineArtConversionService;

    private boolean isQpdfEnabled() {
        return this.endpointConfiguration.isGroupEnabled("qpdf");
    }

    private boolean isGhostscriptEnabled() {
        return this.endpointConfiguration.isGroupEnabled("Ghostscript");
    }

    private boolean isImageMagickEnabled() {
        return this.endpointConfiguration.isGroupEnabled("ImageMagick");
    }

    private static void replaceImages(PDDocument doc, Map<ImageIdentity, List<ImageReference>> uniqueImages, Map<ImageIdentity, PDImageXObject> compressedVersions) throws IOException {
        for (Map.Entry<ImageIdentity, List<ImageReference>> entry : uniqueImages.entrySet()) {
            ImageIdentity imageIdentity = entry.getKey();
            List<ImageReference> references = entry.getValue();
            PDImageXObject compressedImage = compressedVersions.get(imageIdentity);
            if (compressedImage == null) continue;
            for (ImageReference ref : references) {
                CompressController.replaceImageReference((PDDocument)doc, (ImageReference)ref, (PDImageXObject)compressedImage);
            }
        }
    }

    private static Map<ImageIdentity, List<ImageReference>> findImages(PDDocument doc) throws IOException {
        HashMap<ImageIdentity, List<ImageReference>> uniqueImages = new HashMap<ImageIdentity, List<ImageReference>>();
        for (int pageNum = 0; pageNum < doc.getNumberOfPages(); ++pageNum) {
            PDPage page = doc.getPage(pageNum);
            PDResources res = page.getResources();
            if (res == null || res.getXObjectNames() == null) continue;
            for (COSName name : res.getXObjectNames()) {
                PDXObject xobj = res.getXObject(name);
                if (CompressController.isImage((PDXObject)xobj)) {
                    CompressController.addDirectImage((int)pageNum, (COSName)name, (PDImageXObject)((PDImageXObject)xobj), uniqueImages);
                    log.info("Found direct image '{}' on page {} - {}x{}", new Object[]{name.getName(), pageNum + 1, ((PDImage)xobj).getWidth(), ((PDImage)xobj).getHeight()});
                    continue;
                }
                if (!CompressController.isForm((PDXObject)xobj)) continue;
                CompressController.checkFormForImages((int)pageNum, (COSName)name, (PDFormXObject)((PDFormXObject)xobj), uniqueImages);
            }
        }
        return uniqueImages;
    }

    private static ImageReference addDirectImage(int pageNum, COSName name, PDImageXObject image, Map<ImageIdentity, List<ImageReference>> uniqueImages) throws IOException {
        ImageReference ref = new ImageReference();
        ref.pageNum = pageNum;
        ref.name = name;
        ImageIdentity identity = new ImageIdentity(image);
        uniqueImages.computeIfAbsent(identity, k -> new ArrayList()).add(ref);
        return ref;
    }

    private static void checkFormForImages(int pageNum, COSName formName, PDFormXObject formXObj, Map<ImageIdentity, List<ImageReference>> uniqueImages) throws IOException {
        PDResources formResources = formXObj.getResources();
        if (formResources == null || formResources.getXObjectNames() == null) {
            return;
        }
        log.info("Checking form XObject '{}' on page {} for nested images", (Object)formName.getName(), (Object)(pageNum + 1));
        for (COSName nestedName : formResources.getXObjectNames()) {
            PDXObject nestedXobj = formResources.getXObject(nestedName);
            if (!CompressController.isImage((PDXObject)nestedXobj)) continue;
            PDImageXObject nestedImage = (PDImageXObject)nestedXobj;
            log.info("Found nested image '{}' in form '{}' on page {} - {}x{}", new Object[]{nestedName.getName(), formName.getName(), pageNum + 1, nestedImage.getWidth(), nestedImage.getHeight()});
            NestedImageReference nestedRef = new NestedImageReference();
            nestedRef.pageNum = pageNum;
            nestedRef.formName = formName;
            nestedRef.imageName = nestedName;
            ImageIdentity identity = new ImageIdentity(nestedImage);
            uniqueImages.computeIfAbsent(identity, k -> new ArrayList()).add(nestedRef);
        }
    }

    private static void calculateImageStats(Map<ImageIdentity, List<ImageReference>> uniqueImages, CompressionStats stats) {
        for (List<ImageReference> references : uniqueImages.values()) {
            for (ImageReference ref : references) {
                ++stats.totalImages;
                if (!(ref instanceof NestedImageReference)) continue;
                ++stats.nestedImages;
            }
        }
    }

    private static boolean isImage(PDXObject xobj) {
        return xobj instanceof PDImageXObject;
    }

    private static boolean isForm(PDXObject xobj) {
        return xobj instanceof PDFormXObject;
    }

    private static Map<ImageIdentity, PDImageXObject> createCompressedImages(PDDocument doc, Map<ImageIdentity, List<ImageReference>> uniqueImages, double scaleFactor, float jpegQuality, boolean convertToGrayscale, CompressionStats stats) throws IOException {
        HashMap<ImageIdentity, PDImageXObject> compressedVersions = new HashMap<ImageIdentity, PDImageXObject>();
        for (Map.Entry<ImageIdentity, List<ImageReference>> entry : uniqueImages.entrySet()) {
            ImageIdentity imageIdentity = entry.getKey();
            List<ImageReference> references = entry.getValue();
            if (references.isEmpty()) continue;
            PDImageXObject originalImage = CompressController.getOriginalImage((PDDocument)doc, (ImageReference)references.get(0));
            int originalSize = (int)originalImage.getCOSObject().getLength();
            stats.totalOriginalBytes += (long)originalSize;
            PDImageXObject compressedImage = CompressController.compressImage((PDDocument)doc, (PDImageXObject)originalImage, (int)originalSize, (double)scaleFactor, (float)jpegQuality, (boolean)convertToGrayscale);
            if (compressedImage != null) {
                compressedVersions.put(imageIdentity, compressedImage);
                ++stats.compressedImages;
                int compressedSize = (int)compressedImage.getCOSObject().getLength();
                stats.totalCompressedBytes += (long)compressedSize * (long)references.size();
                double reductionPercentage = 100.0 - (double)compressedSize * 100.0 / (double)originalSize;
                log.info("Image identity {}: Compressed from {} to {} (reduced by {}%)", new Object[]{imageIdentity, GeneralUtils.formatBytes((long)originalSize), GeneralUtils.formatBytes((long)compressedSize), String.format(Locale.ROOT, "%.1f", reductionPercentage)});
                continue;
            }
            log.info("Image identity {}: Not suitable for compression, skipping", (Object)imageIdentity);
            stats.totalCompressedBytes += (long)originalSize * (long)references.size();
            ++stats.skippedImages;
        }
        return compressedVersions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String generateImageHash(PDImageXObject image) {
        try (InputStream stream = image.getCOSObject().createRawInputStream();){
            byte[] buffer = new byte[16384];
            int bytesRead = stream.read(buffer);
            if (bytesRead > 0) {
                byte[] dataToHash = bytesRead == buffer.length ? buffer : Arrays.copyOf(buffer, bytesRead);
                String enhancedData = new String(dataToHash, StandardCharsets.UTF_8) + "_" + image.getWidth() + "_" + image.getHeight() + "_" + image.getColorSpace().getName() + "_" + image.getBitsPerComponent();
                String string2 = CompressController.bytesToHexString((byte[])CompressController.generateMD5((byte[])enhancedData.getBytes()));
                return string2;
            }
            String string = "empty-stream";
            return string;
        }
        catch (Exception e) {
            ExceptionUtils.logException((String)"image hash generation", (Exception)e);
            return "fallback-" + System.identityHashCode(image);
        }
    }

    public TempFile compressImagesInPDF(Path pdfFile, double scaleFactor, float jpegQuality, boolean convertToGrayscale) throws Exception {
        TempFile tempFile;
        block8: {
            TempFile newCompressedPDF = this.tempFileManager.createManagedTempFile(".pdf");
            long originalFileSize = Files.size(pdfFile);
            log.info("Starting image compression with scale factor: {}, JPEG quality: {}, grayscale: {} on file size: {}", new Object[]{scaleFactor, Float.valueOf(jpegQuality), convertToGrayscale, GeneralUtils.formatBytes((long)originalFileSize)});
            PDDocument doc = this.pdfDocumentFactory.load(pdfFile);
            try {
                Map uniqueImages = CompressController.findImages((PDDocument)doc);
                CompressionStats stats = new CompressionStats();
                stats.uniqueImagesCount = uniqueImages.size();
                CompressController.calculateImageStats((Map)uniqueImages, (CompressionStats)stats);
                Map compressedVersions = CompressController.createCompressedImages((PDDocument)doc, (Map)uniqueImages, (double)scaleFactor, (float)jpegQuality, (boolean)convertToGrayscale, (CompressionStats)stats);
                CompressController.replaceImages((PDDocument)doc, (Map)uniqueImages, (Map)compressedVersions);
                CompressController.logCompressionStats((CompressionStats)stats, (long)originalFileSize);
                compressedVersions.clear();
                uniqueImages.clear();
                log.info("Saving compressed PDF to {}", (Object)newCompressedPDF.getPath());
                doc.save(newCompressedPDF.getAbsolutePath());
                long compressedFileSize = Files.size(newCompressedPDF.getPath());
                double overallReduction = 100.0 - (double)compressedFileSize * 100.0 / (double)originalFileSize;
                log.info("Overall PDF compression: {} \u2192 {} (reduced by {}%)", new Object[]{GeneralUtils.formatBytes((long)originalFileSize), GeneralUtils.formatBytes((long)compressedFileSize), String.format(Locale.ROOT, "%.1f", overallReduction)});
                tempFile = newCompressedPDF;
                if (doc == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (doc != null) {
                        try {
                            doc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    newCompressedPDF.close();
                    throw e;
                }
            }
            doc.close();
        }
        return tempFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String generateMaskHash(PDImageXObject image) {
        try {
            PDImageXObject mask = image.getMask();
            if (mask == null) {
                mask = image.getSoftMask();
            }
            if (mask == null) return "no-mask";
            try (InputStream stream = mask.getCOSObject().createRawInputStream();){
                byte[] buffer = new byte[4096];
                int bytesRead = stream.read(buffer);
                if (bytesRead > 0) {
                    byte[] dataToHash = bytesRead == buffer.length ? buffer : Arrays.copyOf(buffer, bytesRead);
                    String string = CompressController.bytesToHexString((byte[])CompressController.generateMD5((byte[])dataToHash));
                    return string;
                }
                String string = "empty-mask";
                return string;
            }
        }
        catch (Exception e) {
            ExceptionUtils.logException((String)"mask hash generation", (Exception)e);
            return "fallback-mask-" + System.identityHashCode(image);
        }
    }

    private static PDImageXObject getOriginalImage(PDDocument doc, ImageReference ref) throws IOException {
        if (ref instanceof NestedImageReference) {
            NestedImageReference nestedRef = (NestedImageReference)ref;
            PDPage page = doc.getPage(nestedRef.pageNum);
            PDResources pageResources = page.getResources();
            PDFormXObject formXObj = (PDFormXObject)pageResources.getXObject(nestedRef.formName);
            PDResources formResources = formXObj.getResources();
            return (PDImageXObject)formResources.getXObject(nestedRef.imageName);
        }
        PDPage page = doc.getPage(ref.pageNum);
        PDResources resources = page.getResources();
        return (PDImageXObject)resources.getXObject(ref.name);
    }

    private static PDImageXObject compressImage(PDDocument doc, PDImageXObject originalImage, int originalSize, double scaleFactor, float jpegQuality, boolean convertToGrayscale) throws IOException {
        BufferedImage processedImage = CompressController.processAndCompressImage((PDImageXObject)originalImage, (double)scaleFactor, (float)jpegQuality, (boolean)convertToGrayscale);
        if (processedImage == null) {
            return null;
        }
        byte[] compressedData = CompressController.convertToBytes((BufferedImage)processedImage, (float)jpegQuality);
        if (compressedData.length < originalSize || convertToGrayscale) {
            return PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])compressedData, (String)originalImage.getCOSObject().toString());
        }
        return null;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format(Locale.ROOT, "%02x", b));
        }
        return sb.toString();
    }

    private static void replaceImageReference(PDDocument doc, ImageReference ref, PDImageXObject compressedImage) throws IOException {
        if (ref instanceof NestedImageReference) {
            NestedImageReference nestedRef = (NestedImageReference)ref;
            PDPage page = doc.getPage(nestedRef.pageNum);
            PDResources pageResources = page.getResources();
            PDFormXObject formXObj = (PDFormXObject)pageResources.getXObject(nestedRef.formName);
            PDResources formResources = formXObj.getResources();
            formResources.put(nestedRef.imageName, (PDXObject)compressedImage);
            log.info("Replaced nested image '{}' in form '{}' on page {} with compressed version", new Object[]{nestedRef.imageName.getName(), nestedRef.formName.getName(), nestedRef.pageNum + 1});
        } else {
            PDPage page = doc.getPage(ref.pageNum);
            PDResources resources = page.getResources();
            resources.put(ref.name, (PDXObject)compressedImage);
            log.info("Replaced direct image on page {} with compressed version", (Object)(ref.pageNum + 1));
        }
    }

    private static void logCompressionStats(CompressionStats stats, long originalFileSize) {
        double overallImageReduction = stats.totalOriginalBytes > 0L ? 100.0 - (double)stats.totalCompressedBytes * 100.0 / (double)stats.totalOriginalBytes : 0.0;
        int duplicatedImages = stats.totalImages - stats.uniqueImagesCount;
        log.info("Image compression summary - Total unique: {}, Compressed: {}, Skipped: {}, Duplicates: {}, Nested: {}", new Object[]{stats.uniqueImagesCount, stats.compressedImages, stats.skippedImages, duplicatedImages, stats.nestedImages});
        log.info("Total original image size: {}, compressed: {} (reduced by {}%)", new Object[]{GeneralUtils.formatBytes((long)stats.totalOriginalBytes), GeneralUtils.formatBytes((long)stats.totalCompressedBytes), String.format(Locale.ROOT, "%.1f", overallImageReduction)});
    }

    private static BufferedImage convertToGrayscale(BufferedImage image) {
        BufferedImage grayImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        Graphics2D g = grayImage.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return grayImage;
    }

    private static BufferedImage processAndCompressImage(PDImageXObject image, double scaleFactor, float jpegQuality, boolean convertToGrayscale) throws IOException {
        BufferedImage bufferedImage = image.getImage();
        int originalWidth = bufferedImage.getWidth();
        int originalHeight = bufferedImage.getHeight();
        int MIN_WIDTH = 400;
        int MIN_HEIGHT = 400;
        log.info("Original dimensions: {}x{}", (Object)originalWidth, (Object)originalHeight);
        if (!(originalWidth > MIN_WIDTH && originalHeight > MIN_HEIGHT || convertToGrayscale)) {
            log.info("Skipping - below minimum dimensions threshold");
            return null;
        }
        if (convertToGrayscale) {
            bufferedImage = CompressController.convertToGrayscale((BufferedImage)bufferedImage);
            log.info("Converted image to grayscale");
        }
        double adjustedScaleFactor = scaleFactor;
        if (originalWidth > 3000 || originalHeight > 3000) {
            adjustedScaleFactor = Math.min(scaleFactor, 0.75);
            log.info("Very large image, using more aggressive scale: {}", (Object)adjustedScaleFactor);
        } else if (originalWidth < 1000 || originalHeight < 1000) {
            adjustedScaleFactor = Math.max(scaleFactor, 0.9);
            log.info("Smaller image, using conservative scale: {}", (Object)adjustedScaleFactor);
        }
        int newWidth = (int)((double)originalWidth * adjustedScaleFactor);
        int newHeight = (int)((double)originalHeight * adjustedScaleFactor);
        newWidth = Math.max(newWidth, MIN_WIDTH);
        newHeight = Math.max(newHeight, MIN_HEIGHT);
        if ((double)newWidth / (double)originalWidth > 0.95 && (double)newHeight / (double)originalHeight > 0.95 && !convertToGrayscale) {
            log.info("Change too small, skipping compression");
            return null;
        }
        log.info("Resizing to {}x{} ({}% of original)", new Object[]{newWidth, newHeight, Math.round((double)newWidth * 100.0 / (double)originalWidth)});
        BufferedImage scaledImage = convertToGrayscale ? new BufferedImage(newWidth, newHeight, 10) : new BufferedImage(newWidth, newHeight, bufferedImage.getColorModel().hasAlpha() ? 2 : 1);
        Graphics2D g2d = scaledImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage(bufferedImage, 0, 0, newWidth, newHeight, null);
        g2d.dispose();
        return scaledImage;
    }

    private static byte[] convertToBytes(BufferedImage scaledImage, float jpegQuality) throws IOException {
        String format = scaledImage.getColorModel().hasAlpha() ? "png" : "jpeg";
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if ("jpeg".equals(format)) {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = writers.next();
            JPEGImageWriteParam param = (JPEGImageWriteParam)writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(jpegQuality);
            param.setOptimizeHuffmanTables(true);
            param.setProgressiveMode(1);
            try (ImageOutputStream ios = ImageIO.createImageOutputStream(outputStream);){
                writer.setOutput(ios);
                writer.write(null, new IIOImage(scaledImage, null, null), param);
            }
            writer.dispose();
        } else {
            ImageIO.write((RenderedImage)scaledImage, format, outputStream);
        }
        return outputStream.toByteArray();
    }

    private static String getImageFilter(PDImageXObject image) {
        try {
            return image.getCOSObject().getDictionaryObject(COSName.FILTER).toString();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private static String getColorProfileInfo(PDImageXObject image) {
        try {
            if (image.getColorSpace() != null) {
                return image.getColorSpace().getName() + "_" + image.getColorSpace().getNumberOfComponents();
            }
            return "no-profile";
        }
        catch (Exception e) {
            return "error-profile";
        }
    }

    private static String getImageType(PDImageXObject image) {
        try {
            String filter = CompressController.getImageFilter((PDImageXObject)image);
            if (filter.contains("DCTDecode") || filter.contains("JPXDecode")) {
                return "JPEG";
            }
            if (filter.contains("FlateDecode")) {
                return "PNG";
            }
            if (filter.contains("CCITTFaxDecode")) {
                return "TIFF";
            }
            if (filter.contains("JBIG2Decode")) {
                return "JBIG2";
            }
            return "RAW";
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private static String generateDecodeParamsHash(PDImageXObject image) {
        try {
            StringBuilder params = new StringBuilder();
            params.append(CompressController.getImageFilter((PDImageXObject)image));
            params.append("_").append(image.getColorSpace().getNumberOfComponents());
            params.append("_").append(image.getBitsPerComponent());
            if (image.getDecode() != null) {
                params.append("_").append(image.getDecode().toString());
            }
            return CompressController.bytesToHexString((byte[])CompressController.generateMD5((byte[])params.toString().getBytes()));
        }
        catch (Exception e) {
            return "fallback-decode-" + System.identityHashCode(image);
        }
    }

    private static byte[] generateMD5(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw ExceptionUtils.createMd5AlgorithmException((Exception)e);
        }
    }

    private static double getScaleFactorForLevel(int optimizeLevel) {
        return switch (optimizeLevel) {
            case 1 -> 0.98;
            case 2 -> 0.95;
            case 3 -> 0.88;
            case 4 -> 0.78;
            case 5 -> 0.68;
            case 6 -> 0.58;
            case 7 -> 0.48;
            case 8 -> 0.38;
            case 9 -> 0.28;
            default -> 1.0;
        };
    }

    private static float getJpegQualityForLevel(int optimizeLevel) {
        return switch (optimizeLevel) {
            case 1 -> 0.92f;
            case 2 -> 0.88f;
            case 3 -> 0.85f;
            case 4 -> 0.8f;
            case 5 -> 0.72f;
            case 6 -> 0.65f;
            case 7 -> 0.55f;
            case 8 -> 0.45f;
            case 9 -> 0.35f;
            default -> 0.75f;
        };
    }

    private static int determineOptimizeLevel(double sizeReductionRatio) {
        if (sizeReductionRatio > 0.9) {
            return 1;
        }
        if (sizeReductionRatio > 0.8) {
            return 2;
        }
        if (sizeReductionRatio > 0.7) {
            return 3;
        }
        if (sizeReductionRatio > 0.6) {
            return 4;
        }
        if (sizeReductionRatio > 0.3) {
            return 5;
        }
        if (sizeReductionRatio > 0.2) {
            return 6;
        }
        if (sizeReductionRatio > 0.15) {
            return 7;
        }
        if (sizeReductionRatio > 0.1) {
            return 8;
        }
        return 9;
    }

    private static int incrementOptimizeLevel(int currentLevel, long currentSize, long targetSize) {
        double currentRatio = (double)currentSize / (double)targetSize;
        log.info("Current compression ratio: {}", (Object)String.format(Locale.ROOT, "%.2f", currentRatio));
        if (currentRatio > 2.0) {
            return Math.min(9, currentLevel + 3);
        }
        if (currentRatio > 1.5) {
            return Math.min(9, currentLevel + 2);
        }
        return Math.min(9, currentLevel + 1);
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/compress-pdf"})
    @Operation(summary="Optimize PDF file", description="This endpoint accepts a PDF file and optimizes it based on the provided parameters. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> optimizePdf(@ModelAttribute OptimizePdfRequest request) throws Exception {
        MultipartFile inputFile = request.getFileInput();
        if (inputFile == null || inputFile.isEmpty()) {
            throw ExceptionUtils.createFileNullOrEmptyException();
        }
        Integer optimizeLevel = request.getOptimizeLevel();
        String expectedOutputSizeString = request.getExpectedOutputSize();
        Boolean convertToGrayscale = request.getGrayscale();
        Boolean convertToLineArt = request.getLineArt();
        Double lineArtThreshold = request.getLineArtThreshold();
        Integer lineArtEdgeLevel = request.getLineArtEdgeLevel();
        if (expectedOutputSizeString == null && optimizeLevel == null) {
            throw ExceptionUtils.createIllegalArgumentException((ExceptionUtils.ErrorCode)ExceptionUtils.ErrorCode.COMPRESSION_OPTIONS, (Object[])new Object[0]);
        }
        Long expectedOutputSize = 0L;
        boolean autoMode = false;
        if (expectedOutputSizeString != null && expectedOutputSizeString.length() > 1) {
            expectedOutputSize = GeneralUtils.convertSizeToBytes((String)expectedOutputSizeString);
            autoMode = true;
        }
        ArrayList<TempFile> tempFiles = new ArrayList<TempFile>();
        TempFile originalTempFile = this.tempFileManager.createManagedTempFile(".pdf");
        tempFiles.add(originalTempFile);
        Path originalFile = originalTempFile.getPath();
        inputFile.transferTo(originalTempFile.getFile());
        long inputFileSize = Files.size(originalFile);
        TempFile currentTempFile = this.tempFileManager.createManagedTempFile(".pdf");
        tempFiles.add(currentTempFile);
        Path currentFile = currentTempFile.getPath();
        Files.copy(originalFile, currentFile, StandardCopyOption.REPLACE_EXISTING);
        try {
            ResponseEntity responseEntity;
            block40: {
                long finalFileSize;
                if (autoMode) {
                    double sizeReductionRatio = (double)expectedOutputSize.longValue() / (double)inputFileSize;
                    optimizeLevel = CompressController.determineOptimizeLevel((double)sizeReductionRatio);
                }
                if (Boolean.TRUE.equals(convertToLineArt)) {
                    if (this.lineArtConversionService == null) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, "Line art conversion is unavailable - ImageMagick service not found");
                    }
                    if (!this.isImageMagickEnabled()) {
                        throw new IOException("ImageMagick is not enabled but line art conversion was requested");
                    }
                    double thresholdValue = lineArtThreshold == null ? 55.0 : Math.min(100.0, Math.max(0.0, lineArtThreshold));
                    int edgeLevel = lineArtEdgeLevel == null ? 1 : Math.min(3, Math.max(1, lineArtEdgeLevel));
                    currentFile = this.applyLineArtConversion(currentFile, tempFiles, thresholdValue, edgeLevel);
                }
                boolean sizeMet = false;
                boolean imageCompressionApplied = false;
                while (!sizeMet && optimizeLevel <= 9) {
                    long outputFileSize;
                    boolean ghostscriptSuccess = false;
                    if (this.isGhostscriptEnabled() && optimizeLevel >= 6) {
                        try {
                            this.applyGhostscriptCompression(request, optimizeLevel.intValue(), currentFile);
                            log.info("Ghostscript compression applied successfully");
                            ghostscriptSuccess = true;
                        }
                        catch (ExceptionUtils.GhostscriptException e) {
                            log.error("Ghostscript encountered a critical error: {}", (Object)e.getMessage());
                            throw e;
                        }
                        catch (IOException e) {
                            log.warn("Ghostscript compression failed, continuing with other methods: {}", (Object)e.getMessage());
                        }
                    }
                    if (this.isQpdfEnabled()) {
                        try {
                            this.applyQpdfCompression(request, optimizeLevel.intValue(), currentFile);
                            log.info("QPDF compression applied successfully");
                        }
                        catch (IOException e) {
                            log.warn("QPDF compression failed: {}", (Object)e.getMessage());
                        }
                    } else if (!ghostscriptSuccess) {
                        log.info("No external compression tools available, using image compression only");
                    }
                    if (ghostscriptSuccess) {
                        imageCompressionApplied = true;
                    }
                    if ((optimizeLevel >= 4 || Boolean.TRUE.equals(convertToGrayscale)) && !imageCompressionApplied) {
                        double scaleFactor = CompressController.getScaleFactorForLevel((int)optimizeLevel);
                        float jpegQuality = CompressController.getJpegQualityForLevel((int)optimizeLevel);
                        log.info("Applying image compression with scale factor: {} and JPEG quality: {}", (Object)scaleFactor, (Object)Float.valueOf(jpegQuality));
                        TempFile compressedImageFile = this.compressImagesInPDF(currentFile, scaleFactor, jpegQuality, Boolean.TRUE.equals(convertToGrayscale));
                        tempFiles.add(compressedImageFile);
                        currentFile = compressedImageFile.getPath();
                        imageCompressionApplied = true;
                    }
                    if ((outputFileSize = Files.size(currentFile)) <= expectedOutputSize || !autoMode) {
                        sizeMet = true;
                        continue;
                    }
                    int newOptimizeLevel = CompressController.incrementOptimizeLevel((int)optimizeLevel, (long)outputFileSize, (long)expectedOutputSize);
                    if (newOptimizeLevel == optimizeLevel) {
                        log.info("Maximum optimization level reached without meeting target size.");
                        sizeMet = true;
                        continue;
                    }
                    imageCompressionApplied = false;
                    optimizeLevel = newOptimizeLevel;
                }
                if (!Files.exists(currentFile, new LinkOption[0])) {
                    log.warn("Optimized file missing or invalid. Using the original file instead.");
                    currentFile = originalFile;
                }
                if ((finalFileSize = Files.size(currentFile)) >= inputFileSize) {
                    log.warn("Optimized file is larger than the original. Using the original file instead.");
                    currentFile = originalFile;
                }
                String outputFilename = GeneralUtils.generateFilename((String)inputFile.getOriginalFilename(), (String)"_Optimized.pdf");
                PDDocument document = this.pdfDocumentFactory.load(currentFile.toFile());
                try {
                    responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)outputFilename);
                    if (document == null) break block40;
                }
                catch (Throwable throwable) {
                    try {
                        if (document != null) {
                            try {
                                document.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.handlePdfException((IOException)e, (String)"PDF optimization");
                    }
                }
                document.close();
            }
            return responseEntity;
        }
        finally {
            for (TempFile tempFile : tempFiles) {
                try {
                    tempFile.close();
                }
                catch (Exception e) {
                    log.warn("Failed to delete temporary file: {}", (Object)tempFile, (Object)e);
                }
            }
        }
    }

    private Path applyLineArtConversion(Path currentFile, List<TempFile> tempFiles, double threshold, int edgeLevel) throws IOException {
        TempFile lineArtFile = new TempFile(this.tempFileManager, ".pdf");
        tempFiles.add(lineArtFile);
        try (PDDocument doc = this.pdfDocumentFactory.load(currentFile.toFile());){
            Map uniqueImages = CompressController.findImages((PDDocument)doc);
            CompressionStats stats = new CompressionStats();
            stats.uniqueImagesCount = uniqueImages.size();
            CompressController.calculateImageStats((Map)uniqueImages, (CompressionStats)stats);
            Map convertedImages = this.createLineArtImages(doc, uniqueImages, stats, threshold, edgeLevel);
            CompressController.replaceImages((PDDocument)doc, (Map)uniqueImages, (Map)convertedImages);
            log.info("Applied line art conversion to {} unique images ({} total references)", (Object)stats.uniqueImagesCount, (Object)stats.totalImages);
            doc.save(lineArtFile.getPath().toString());
            Path path = lineArtFile.getPath();
            return path;
        }
    }

    private Map<ImageIdentity, PDImageXObject> createLineArtImages(PDDocument doc, Map<ImageIdentity, List<ImageReference>> uniqueImages, CompressionStats stats, double threshold, int edgeLevel) throws IOException {
        HashMap<ImageIdentity, PDImageXObject> convertedImages = new HashMap<ImageIdentity, PDImageXObject>();
        for (Map.Entry<ImageIdentity, List<ImageReference>> entry : uniqueImages.entrySet()) {
            ImageIdentity imageIdentity = entry.getKey();
            List<ImageReference> references = entry.getValue();
            if (references.isEmpty()) continue;
            PDImageXObject originalImage = CompressController.getOriginalImage((PDDocument)doc, (ImageReference)references.get(0));
            int originalSize = (int)originalImage.getCOSObject().getLength();
            stats.totalOriginalBytes += (long)originalSize;
            PDImageXObject converted = this.lineArtConversionService.convertImageToLineArt(doc, originalImage, threshold, edgeLevel);
            convertedImages.put(imageIdentity, converted);
            ++stats.compressedImages;
            int convertedSize = (int)converted.getCOSObject().getLength();
            stats.totalCompressedBytes += (long)(convertedSize * references.size());
            double reductionPercentage = 100.0 - (double)convertedSize * 100.0 / (double)originalSize;
            log.info("Image identity {}: Line art conversion {} \u2192 {} (reduced by {}%)", new Object[]{imageIdentity, GeneralUtils.formatBytes((long)originalSize), GeneralUtils.formatBytes((long)convertedSize), String.format("%.1f", reductionPercentage)});
        }
        return convertedImages;
    }

    private void applyGhostscriptCompression(OptimizePdfRequest request, int optimizeLevel, Path currentFile) throws IOException {
        block24: {
            long preGsSize = Files.size(currentFile);
            log.info("Pre-Ghostscript file size: {}", (Object)GeneralUtils.formatBytes((long)preGsSize));
            try (TempFile gsOutputFile = this.tempFileManager.createManagedTempFile(".pdf");){
                Path gsOutputPath = gsOutputFile.getPath();
                ArrayList<Object> command = new ArrayList<Object>();
                command.add("gs");
                command.add("-sDEVICE=pdfwrite");
                command.add("-dCompatibilityLevel=1.5");
                command.add("-dNOPAUSE");
                command.add("-dQUIET");
                command.add("-dBATCH");
                command.add("-dDetectDuplicateImages=true");
                command.add("-dDownsampleColorImages=true");
                command.add("-dCompressFonts=true");
                command.add("-dSubsetFonts=true");
                switch (optimizeLevel) {
                    case 1: {
                        command.add("-dPDFSETTINGS=/prepress");
                        break;
                    }
                    case 2: {
                        command.add("-dPDFSETTINGS=/printer");
                        break;
                    }
                    case 3: {
                        command.add("-dPDFSETTINGS=/ebook");
                        break;
                    }
                    case 4: 
                    case 5: {
                        command.add("-dPDFSETTINGS=/screen");
                        break;
                    }
                    case 6: 
                    case 7: {
                        command.add("-dPDFSETTINGS=/screen");
                        command.add("-dColorImageResolution=150");
                        command.add("-dGrayImageResolution=150");
                        command.add("-dMonoImageResolution=300");
                        break;
                    }
                    case 8: 
                    case 9: {
                        command.add("-dPDFSETTINGS=/screen");
                        if (optimizeLevel == 9) {
                            command.add("-dColorImageResolution=72");
                            command.add("-dGrayImageResolution=72");
                            command.add("-dMonoImageResolution=150");
                            break;
                        }
                        command.add("-dColorImageResolution=100");
                        command.add("-dGrayImageResolution=100");
                        command.add("-dMonoImageResolution=200");
                        break;
                    }
                    case 10: {
                        command.add("-dPDFSETTINGS=/screen");
                        command.add("-dColorImageResolution=72");
                        command.add("-dGrayImageResolution=72");
                        command.add("-dMonoImageResolution=150");
                        break;
                    }
                    default: {
                        command.add("-dPDFSETTINGS=/screen");
                    }
                }
                boolean grayscaleRequested = Boolean.TRUE.equals(request.getGrayscale());
                if (grayscaleRequested) {
                    command.add("-dColorConversionStrategy=/Gray");
                    command.add("-dProcessColorModel=/DeviceGray");
                }
                if (optimizeLevel >= 7 && !grayscaleRequested) {
                    command.add("-dConvertCMYKImagesToRGB=true");
                }
                command.add("-sOutputFile=" + gsOutputPath.toString());
                command.add(currentFile.toString());
                try {
                    ProcessExecutor.ProcessExecutorResult returnCode = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT).runCommandWithOutputHandling(command);
                    String gsOutput = returnCode.getMessages();
                    ExceptionUtils.GhostscriptException criticalError = ExceptionUtils.detectGhostscriptCriticalError((String)gsOutput);
                    if (criticalError != null) {
                        log.error("Ghostscript critical error detected: {}", (Object)criticalError.getMessage());
                        throw criticalError;
                    }
                    if (returnCode.getRc() == 0) {
                        Files.copy(gsOutputPath, currentFile, StandardCopyOption.REPLACE_EXISTING);
                        long postGsSize = Files.size(currentFile);
                        double gsReduction = 100.0 - (double)postGsSize * 100.0 / (double)preGsSize;
                        log.info("Post-Ghostscript file size: {} (reduced by {}%)", (Object)GeneralUtils.formatBytes((long)postGsSize), (Object)String.format(Locale.ROOT, "%.1f", gsReduction));
                        break block24;
                    }
                    log.warn("Ghostscript compression failed with return code: {}", (Object)returnCode.getRc());
                    throw ExceptionUtils.createGhostscriptCompressionException((String)gsOutput);
                }
                catch (InterruptedException e) {
                    throw ExceptionUtils.createProcessingInterruptedException((String)"Ghostscript", (InterruptedException)e);
                }
                catch (ExceptionUtils.GhostscriptException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.warn("Ghostscript compression failed, will fallback to other methods", (Throwable)e);
                    throw ExceptionUtils.createGhostscriptCompressionException((Exception)e);
                }
            }
        }
    }

    private void applyQpdfCompression(OptimizePdfRequest request, int optimizeLevel, Path currentFile) throws IOException {
        long preQpdfSize = Files.size(currentFile);
        log.info("Pre-QPDF file size: {}", (Object)GeneralUtils.formatBytes((long)preQpdfSize));
        int qpdfCompressionLevel = switch (optimizeLevel) {
            case 1 -> 3;
            case 2 -> 5;
            case 3, 4, 5 -> 7;
            default -> 9;
        };
        try (TempFile qpdfOutputFile = this.tempFileManager.createManagedTempFile(".pdf");){
            Path qpdfOutputPath = qpdfOutputFile.getPath();
            ArrayList<Object> command = new ArrayList<Object>();
            command.add("qpdf");
            if (Boolean.TRUE.equals(request.getNormalize())) {
                command.add("--normalize-content=y");
            }
            if (Boolean.TRUE.equals(request.getLinearize())) {
                command.add("--linearize");
            }
            command.add("--decode-level=generalized");
            command.add("--recompress-flate");
            command.add("--compression-level=" + qpdfCompressionLevel);
            command.add("--compress-streams=y");
            command.add("--stream-data=compress");
            if (optimizeLevel <= 3) {
                command.add("--preserve-unreferenced");
            }
            if (optimizeLevel >= 5) {
                command.add("--optimize-images");
                Integer jpegQuality = switch (optimizeLevel) {
                    case 5 -> 78;
                    case 6 -> 68;
                    case 7 -> 58;
                    case 8 -> 46;
                    default -> 34;
                };
                command.add("--jpeg-quality=" + jpegQuality);
            }
            command.add("--object-streams=generate");
            command.add(currentFile.toString());
            command.add(qpdfOutputPath.toString());
            ProcessExecutor.ProcessExecutorResult returnCode = null;
            try {
                String os;
                if (optimizeLevel >= 8 && !(os = System.getProperty("os.name").toLowerCase(Locale.ROOT)).contains("win")) {
                    ArrayList<Object> zopfliCommand = new ArrayList<Object>();
                    zopfliCommand.add("env");
                    zopfliCommand.add("QPDF_ZOPFLI=silent");
                    zopfliCommand.addAll(command);
                    command = zopfliCommand;
                }
                returnCode = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.QPDF).runCommandWithOutputHandling(command, null);
                Files.copy(qpdfOutputPath, currentFile, StandardCopyOption.REPLACE_EXISTING);
                long postQpdfSize = Files.size(currentFile);
                double qpdfReduction = 100.0 - (double)postQpdfSize * 100.0 / (double)preQpdfSize;
                log.info("Post-QPDF file size: {} (reduced by {}%)", (Object)GeneralUtils.formatBytes((long)postQpdfSize), (Object)String.format(Locale.ROOT, "%.1f", qpdfReduction));
            }
            catch (IOException e) {
                if (returnCode != null && returnCode.getRc() != 3) {
                    throw ExceptionUtils.createIOException((String)ExceptionUtils.ErrorCode.QPDF_COMPRESSION.getMessageKey(), (String)ExceptionUtils.ErrorCode.QPDF_COMPRESSION.getDefaultMessage(), (Exception)e, (Object[])new Object[0]);
                }
                log.warn("QPDF compression failed, continuing with current file", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw ExceptionUtils.createProcessingInterruptedException((String)"QPDF", (InterruptedException)e);
            }
        }
    }

    @Generated
    public CompressController(CustomPDFDocumentFactory pdfDocumentFactory, EndpointConfiguration endpointConfiguration, TempFileManager tempFileManager) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.endpointConfiguration = endpointConfiguration;
        this.tempFileManager = tempFileManager;
    }
}

