/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.filters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.PDFComparisonAndCount;
import stirling.software.SPDF.model.api.PDFWithPageNums;
import stirling.software.SPDF.model.api.filter.ContainsTextRequest;
import stirling.software.SPDF.model.api.filter.FileSizeRequest;
import stirling.software.SPDF.model.api.filter.PageRotationRequest;
import stirling.software.SPDF.model.api.filter.PageSizeRequest;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.PdfUtils;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/filter"})
@Tag(name="Filter", description="Filter APIs")
public class FilterController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @PostMapping(consumes={"multipart/form-data"}, value={"/filter-contains-text"})
    @Operation(summary="Checks if a PDF contains set text, returns true if does", description="Input:PDF Output:Boolean Type:SISO")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="PDF passed filter", content={@Content(mediaType="application/pdf")}), @ApiResponse(responseCode="204", description="PDF did not pass filter", content={@Content})})
    public ResponseEntity<byte[]> containsText(@ModelAttribute ContainsTextRequest request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        String text = request.getText();
        String pageNumber = request.getPageNumbers();
        try (PDDocument pdfDocument = this.pdfDocumentFactory.load(inputFile);){
            if (PdfUtils.hasText((PDDocument)pdfDocument, (String)pageNumber, (String)text)) {
                ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)pdfDocument, (String)Filenames.toSimpleFileName((String)inputFile.getOriginalFilename()));
                return responseEntity;
            }
        }
        return ResponseEntity.noContent().build();
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/filter-contains-image"})
    @Operation(summary="Checks if a PDF contains an image", description="Input:PDF Output:Boolean Type:SISO")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="PDF passed filter", content={@Content(mediaType="application/pdf")}), @ApiResponse(responseCode="204", description="PDF did not pass filter", content={@Content})})
    public ResponseEntity<byte[]> containsImage(@ModelAttribute PDFWithPageNums request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        String pageNumber = request.getPageNumbers();
        try (PDDocument pdfDocument = this.pdfDocumentFactory.load(inputFile);){
            if (PdfUtils.hasImages((PDDocument)pdfDocument, (String)pageNumber)) {
                ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)pdfDocument, (String)Filenames.toSimpleFileName((String)inputFile.getOriginalFilename()));
                return responseEntity;
            }
        }
        return ResponseEntity.noContent().build();
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/filter-page-count"})
    @Operation(summary="Checks if a PDF is greater, less or equal to a setPageCount", description="Input:PDF Output:Boolean Type:SISO")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="PDF passed filter", content={@Content(mediaType="application/pdf")}), @ApiResponse(responseCode="204", description="PDF did not pass filter", content={@Content})})
    public ResponseEntity<byte[]> pageCount(@ModelAttribute PDFComparisonAndCount request) throws IOException, InterruptedException {
        boolean valid;
        MultipartFile inputFile = request.getFileInput();
        int pageCount = request.getPageCount();
        String comparator = request.getComparator();
        try (PDDocument document = this.pdfDocumentFactory.load(inputFile);){
            int actualPageCount = document.getNumberOfPages();
            valid = FilterController.compare((Comparable)Integer.valueOf(actualPageCount), (Comparable)Integer.valueOf(pageCount), (String)comparator);
        }
        return valid ? WebResponseUtils.multiPartFileToWebResponse((MultipartFile)inputFile) : ResponseEntity.noContent().build();
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/filter-page-size"})
    @Operation(summary="Checks if a PDF is of a certain size", description="Input:PDF Output:Boolean Type:SISO")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="PDF passed filter", content={@Content(mediaType="application/pdf")}), @ApiResponse(responseCode="204", description="PDF did not pass filter", content={@Content})})
    public ResponseEntity<byte[]> pageSize(@ModelAttribute PageSizeRequest request) throws IOException, InterruptedException {
        boolean valid;
        MultipartFile inputFile = request.getFileInput();
        String standardPageSize = request.getStandardPageSize();
        String comparator = request.getComparator();
        try (PDDocument document = this.pdfDocumentFactory.load(inputFile);){
            PDPage firstPage = document.getPage(0);
            PDRectangle actualPageSize = firstPage.getMediaBox();
            float actualArea = actualPageSize.getWidth() * actualPageSize.getHeight();
            PDRectangle standardSize = PdfUtils.textToPageSize((String)standardPageSize);
            float standardArea = standardSize.getWidth() * standardSize.getHeight();
            valid = FilterController.compare((Comparable)Float.valueOf(actualArea), (Comparable)Float.valueOf(standardArea), (String)comparator);
        }
        return valid ? WebResponseUtils.multiPartFileToWebResponse((MultipartFile)inputFile) : ResponseEntity.noContent().build();
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/filter-file-size"})
    @Operation(summary="Checks if a PDF is a set file size", description="Input:PDF Output:Boolean Type:SISO")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="PDF passed filter", content={@Content(mediaType="application/pdf")}), @ApiResponse(responseCode="204", description="PDF did not pass filter", content={@Content})})
    public ResponseEntity<byte[]> fileSize(@ModelAttribute FileSizeRequest request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        long fileSize = request.getFileSize();
        String comparator = request.getComparator();
        long actualFileSize = inputFile.getSize();
        boolean valid = FilterController.compare((Comparable)Long.valueOf(actualFileSize), (Comparable)Long.valueOf(fileSize), (String)comparator);
        return valid ? WebResponseUtils.multiPartFileToWebResponse((MultipartFile)inputFile) : ResponseEntity.noContent().build();
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/filter-page-rotation"})
    @Operation(summary="Checks if a PDF is of a certain rotation", description="Input:PDF Output:Boolean Type:SISO")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="PDF passed filter", content={@Content(mediaType="application/pdf")}), @ApiResponse(responseCode="204", description="PDF did not pass filter", content={@Content})})
    public ResponseEntity<byte[]> pageRotation(@ModelAttribute PageRotationRequest request) throws IOException, InterruptedException {
        boolean valid;
        MultipartFile inputFile = request.getFileInput();
        int rotation = request.getRotation();
        String comparator = request.getComparator();
        try (PDDocument document = this.pdfDocumentFactory.load(inputFile);){
            PDPage firstPage = document.getPage(0);
            int actualRotation = firstPage.getRotation();
            valid = FilterController.compare((Comparable)Integer.valueOf(actualRotation), (Comparable)Integer.valueOf(rotation), (String)comparator);
        }
        return valid ? WebResponseUtils.multiPartFileToWebResponse((MultipartFile)inputFile) : ResponseEntity.noContent().build();
    }

    private static <T extends Comparable<T>> boolean compare(T actual, T expected, String comparator) {
        return switch (comparator) {
            case "Greater" -> {
                if (actual.compareTo(expected) > 0) {
                    yield true;
                }
                yield false;
            }
            case "Equal" -> {
                if (actual.compareTo(expected) == 0) {
                    yield true;
                }
                yield false;
            }
            case "Less" -> {
                if (actual.compareTo(expected) < 0) {
                    yield true;
                }
                yield false;
            }
            default -> throw ExceptionUtils.createInvalidArgumentException((String)"comparator", (String)comparator);
        };
    }

    @Generated
    public FilterController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

