/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.Color;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationHighlight;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.pdfbox.preflight.Format;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.SyntaxValidationException;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.parser.PreflightParser;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.converters.ConvertPDFToPDFA;
import stirling.software.SPDF.model.api.converters.PdfToPdfARequest;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/convert"})
@Tag(name="Convert", description="Convert APIs")
public class ConvertPDFToPDFA {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertPDFToPDFA.class);
    private static final Pattern NON_PRINTABLE_ASCII = Pattern.compile("[^\\x20-\\x7E]");
    private final RuntimePathConfig runtimePathConfig;
    private static final String ICC_RESOURCE_PATH = "/icc/sRGB2014.icc";
    private static final int PDFA_COMPATIBILITY_POLICY = 1;
    private static final String ANNOTATION_HIGHLIGHT = "Highlight";
    private static final String ANNOTATION_POPUP = "Popup";
    private static final String ANNOTATION_LINK = "Link";
    private static final COSName COS_AF_RELATIONSHIP = COSName.getPDFName((String)"AFRelationship");
    private static final COSName COS_AF = COSName.getPDFName((String)"AF");
    private static final COSName COS_UF = COSName.getPDFName((String)"UF");
    private static final String AF_RELATIONSHIP_UNSPECIFIED = "Unspecified";
    private static final Map<String, String> MIME_TYPE_MAP = Map.ofEntries(Map.entry(".xml", "application/xml"), Map.entry(".json", "application/json"), Map.entry(".txt", "text/plain"), Map.entry(".csv", "text/csv"), Map.entry(".pdf", "application/pdf"), Map.entry(".png", "image/png"), Map.entry(".jpg", "image/jpeg"), Map.entry(".jpeg", "image/jpeg"), Map.entry(".gif", "image/gif"), Map.entry(".html", "text/html"), Map.entry(".htm", "text/html"), Map.entry(".zip", "application/zip"), Map.entry(".doc", "application/msword"), Map.entry(".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"), Map.entry(".xls", "application/vnd.ms-excel"), Map.entry(".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"), Map.entry(".ppt", "application/vnd.ms-powerpoint"), Map.entry(".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation"), Map.entry(".svg", "image/svg+xml"), Map.entry(".webp", "image/webp"), Map.entry(".mp3", "audio/mpeg"), Map.entry(".mp4", "video/mp4"), Map.entry(".wav", "audio/wav"), Map.entry(".avi", "video/x-msvideo"), Map.entry(".tar", "application/x-tar"), Map.entry(".gz", "application/gzip"), Map.entry(".rar", "application/vnd.rar"), Map.entry(".7z", "application/x-7z-compressed"));
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";

    private static void fixCidSetIssues(PDDocument document) {
        for (PDPage page : document.getPages()) {
            PDResources resources = page.getResources();
            if (resources == null) continue;
            for (COSName fontName : resources.getFontNames()) {
                try {
                    COSDictionary fontDict;
                    COSBase cidSet;
                    PDFontDescriptor descriptor;
                    PDFont font = resources.getFont(fontName);
                    if (font == null || (descriptor = font.getFontDescriptor()) == null || (cidSet = (fontDict = descriptor.getCOSObject()).getDictionaryObject(COSName.getPDFName((String)"CIDSet"))) == null) continue;
                    fontDict.removeItem(COSName.getPDFName((String)"CIDSet"));
                    log.debug("Removed potentially invalid CIDSet from font {}", (Object)font.getName());
                }
                catch (Exception e) {
                    log.debug("Error processing CIDSet for font: {}", (Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateAndWarnPdfA(byte[] pdfBytes, PdfaProfile profile, String method) {
        Path tempPdfPath = null;
        try {
            tempPdfPath = Files.createTempFile("validate_", ".pdf", new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(tempPdfPath, new OpenOption[0]);){
                out.write(pdfBytes);
            }
            ValidationResult validationResult = ConvertPDFToPDFA.performComprehensivePdfAValidation((Path)tempPdfPath, (PdfaProfile)profile);
            if (validationResult.isValid()) {
                log.info("PDF/A validation passed for {} using {}", (Object)profile.getDisplayName(), (Object)method);
            } else {
                log.warn("PDF/A validation warning for {} using {}: {}", new Object[]{profile.getDisplayName(), method, ConvertPDFToPDFA.buildComprehensiveValidationMessage((ValidationResult)validationResult, (PdfaProfile)profile)});
            }
        }
        catch (Exception e) {
            log.warn("PDF/A validation warning for {} using {}: {}", new Object[]{profile.getDisplayName(), method, e.getMessage()});
        }
        finally {
            if (tempPdfPath != null) {
                try {
                    Files.deleteIfExists(tempPdfPath);
                }
                catch (IOException e) {
                    log.debug("Failed to delete temporary validation file", (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ValidationResult performComprehensivePdfAValidation(Path pdfPath, PdfaProfile profile) throws IOException {
        Optional format = profile.preflightFormat();
        if (format.isEmpty()) {
            return ConvertPDFToPDFA.performBasicPdfAValidation((Path)pdfPath, (PdfaProfile)profile);
        }
        try (RandomAccessReadBufferedFile rar = new RandomAccessReadBufferedFile(pdfPath.toFile());){
            ValidationResult validationResult;
            block16: {
                PreflightParser parser = new PreflightParser((RandomAccessRead)rar);
                PreflightDocument document = ConvertPDFToPDFA.parsePreflightDocument((PreflightParser)parser, (Format)((Format)format.get()), (PdfaProfile)profile);
                if (document == null) {
                    throw new IOException("PDF/A preflight returned no document for " + profile.getDisplayName());
                }
                PreflightDocument closeableDocument = document;
                try {
                    validationResult = closeableDocument.validate();
                    if (closeableDocument == null) break block16;
                }
                catch (Throwable throwable) {
                    if (closeableDocument != null) {
                        try {
                            closeableDocument.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                closeableDocument.close();
            }
            return validationResult;
        }
        catch (SyntaxValidationException e) {
            return e.getResult();
        }
        catch (ValidationException e) {
            throw new IOException("PDF/A preflight validation failed for " + profile.getDisplayName(), e);
        }
    }

    private static ValidationResult performBasicPdfAValidation(Path pdfPath, PdfaProfile profile) throws IOException {
        try (PDDocument doc = Loader.loadPDF((File)pdfPath.toFile());){
            PDDocumentCatalog catalog;
            float expectedVersion;
            ValidationResult result = new ValidationResult(true);
            float version = doc.getVersion();
            float f = expectedVersion = profile.getPart() == 1 ? 1.4f : 1.7f;
            if (version < expectedVersion) {
                result.addError(new ValidationResult.ValidationError("PDF_VERSION", "PDF version " + version + " is below required " + expectedVersion + " for " + profile.getDisplayName()));
            }
            if ((catalog = doc.getDocumentCatalog()).getMetadata() == null) {
                result.addError(new ValidationResult.ValidationError("MISSING_XMP", "XMP metadata is required for " + profile.getDisplayName()));
            }
            if (catalog.getOutputIntents().isEmpty()) {
                result.addError(new ValidationResult.ValidationError("MISSING_OUTPUT_INTENT", "Output intent (ICC profile) is required for " + profile.getDisplayName()));
            }
            ValidationResult validationResult = result;
            return validationResult;
        }
    }

    private static String buildComprehensiveValidationMessage(ValidationResult result, PdfaProfile profile) {
        if (result == null) {
            return "PDF/A validation failed for " + profile.getDisplayName() + ": no validation result available";
        }
        List errors = result.getErrorsList();
        StringBuilder message = new StringBuilder();
        message.append("PDF/A validation issues for ").append(profile.getDisplayName());
        if (errors != null && !errors.isEmpty()) {
            message.append(" - ").append(errors.size()).append(" errors");
        }
        message.append(":");
        if (errors != null && !errors.isEmpty()) {
            message.append(" ERRORS: ");
            message.append(errors.stream().limit(5L).map(error -> (error.getErrorCode() != null ? error.getErrorCode() : "UNKNOWN") + (String)(error.getDetails() != null ? ": " + error.getDetails() : "")).collect(Collectors.joining("; ")));
        }
        return message.toString();
    }

    private static void deleteQuietly(Path directory) {
        if (directory == null) {
            return;
        }
        try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    log.warn("Failed to delete temporary file: {}", path, (Object)e);
                }
            });
        }
        catch (IOException e) {
            log.warn("Failed to clean temporary directory: {}", (Object)directory, (Object)e);
        }
    }

    private static List<String> buildGhostscriptCommand(Path inputPdf, Path outputPdf, ColorProfiles colorProfiles, Path workingDir, PdfaProfile profile, Path pdfaDefFile) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("gs");
        command.add("--permit-file-read=" + String.valueOf(workingDir.toAbsolutePath()));
        command.add("--permit-file-read=" + String.valueOf(colorProfiles.rgb().toAbsolutePath()));
        command.add("--permit-file-read=" + String.valueOf(colorProfiles.gray().toAbsolutePath()));
        command.add("--permit-file-read=" + String.valueOf(inputPdf.toAbsolutePath()));
        command.add("--permit-file-read=" + String.valueOf(pdfaDefFile.toAbsolutePath()));
        command.add("--permit-file-write=" + String.valueOf(workingDir.toAbsolutePath()));
        command.add("-dPDFA=" + profile.getPart());
        command.add("-dPDFACompatibilityPolicy=1");
        command.add("-dCompatibilityLevel=" + profile.getCompatibilityLevel());
        command.add("-sDEVICE=pdfwrite");
        command.add("-sColorConversionStrategy=RGB");
        command.add("-dProcessColorModel=/DeviceRGB");
        command.add("-sOutputICCProfile=" + String.valueOf(colorProfiles.rgb().toAbsolutePath()));
        command.add("-sDefaultRGBProfile=" + String.valueOf(colorProfiles.rgb().toAbsolutePath()));
        command.add("-sDefaultGrayProfile=" + String.valueOf(colorProfiles.gray().toAbsolutePath()));
        command.add("-dEmbedAllFonts=true");
        command.add("-dSubsetFonts=true");
        command.add("-dCompressFonts=true");
        command.add("-dNOSUBSTFONTS=false");
        command.add("-dNOPAUSE");
        command.add("-dBATCH");
        command.add("-dNOOUTERSAVE");
        command.add("-sOutputFile=" + String.valueOf(outputPdf.toAbsolutePath()));
        command.add(pdfaDefFile.toAbsolutePath().toString());
        command.add(inputPdf.toAbsolutePath().toString());
        return command;
    }

    private static PreflightDocument parsePreflightDocument(PreflightParser parser, Format format, PdfaProfile profile) throws IOException {
        try {
            PreflightConfiguration config = PreflightConfiguration.createPdfA1BConfiguration();
            if (profile.getPart() != 1) {
                log.debug("Using PDF/A-1B configuration for PDF/A-{} validation", (Object)profile.getPart());
            }
            return (PreflightDocument)parser.parse(format, config);
        }
        catch (SyntaxValidationException e) {
            throw new IOException(ConvertPDFToPDFA.buildComprehensiveValidationMessage((ValidationResult)e.getResult(), (PdfaProfile)profile), e);
        }
        catch (ClassCastException e) {
            throw new IOException("PDF/A preflight did not produce a PreflightDocument for " + profile.getDisplayName(), e);
        }
    }

    private static void writeJavaIccProfile(ICC_Profile profile, Path target) throws IOException {
        try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
            out.write(profile.getData());
        }
    }

    private static Path createPdfaDefFile(Path workingDir, ColorProfiles colorProfiles, PdfaProfile profile) throws IOException {
        Path pdfaDefFile = workingDir.resolve("PDFA_def.ps");
        String title = "Converted to " + profile.getDisplayName();
        String rgbProfilePath = colorProfiles.rgb().toAbsolutePath().toString().replace("\\", "/");
        String pdfaDefContent = String.format("%% This is a sample prefix file for creating a PDF/A document.\n%% Feel free to modify entries marked with \"Customize\".\n\n%% Define entries in the document Info dictionary.\n[/Title (%s)\n /DOCINFO pdfmark\n\n%% Define an ICC profile.\n[/_objdef {icc_PDFA} /type /stream /OBJ pdfmark\n[{icc_PDFA} <<\n  /N 3\n>> /PUT pdfmark\n[{icc_PDFA} (%s) (r) file /PUT pdfmark\n\n%% Define the output intent dictionary.\n[/_objdef {OutputIntent_PDFA} /type /dict /OBJ pdfmark\n[{OutputIntent_PDFA} <<\n  /Type /OutputIntent\n  /S /GTS_PDFA1\n  /DestOutputProfile {icc_PDFA}\n  /OutputConditionIdentifier (sRGB IEC61966-2.1)\n  /Info (sRGB IEC61966-2.1)\n  /RegistryName (http://www.color.org)\n>> /PUT pdfmark\n[{Catalog} <</OutputIntents [ {OutputIntent_PDFA} ]>> /PUT pdfmark\n", title, rgbProfilePath);
        Files.writeString(pdfaDefFile, (CharSequence)pdfaDefContent, new OpenOption[0]);
        return pdfaDefFile;
    }

    private static List<String> buildGhostscriptCommandX(Path inputPdf, Path outputPdf, ColorProfiles colorProfiles, Path workingDir, PdfXProfile profile) {
        ArrayList<String> command = new ArrayList<String>(25);
        command.add("gs");
        command.add("--permit-file-read=" + String.valueOf(workingDir.toAbsolutePath()));
        command.add("--permit-file-read=" + String.valueOf(colorProfiles.rgb().toAbsolutePath()));
        command.add("--permit-file-read=" + String.valueOf(colorProfiles.gray().toAbsolutePath()));
        command.add("--permit-file-read=" + String.valueOf(inputPdf.toAbsolutePath()));
        command.add("--permit-file-write=" + String.valueOf(workingDir.toAbsolutePath()));
        command.add("-dPDFX=" + profile.getPdfxVersion());
        command.add("-dCompatibilityLevel=" + profile.getCompatibilityLevel());
        command.add("-sDEVICE=pdfwrite");
        command.add("-sColorConversionStrategy=RGB");
        command.add("-dProcessColorModel=/DeviceRGB");
        command.add("-sOutputICCProfile=" + String.valueOf(colorProfiles.rgb().toAbsolutePath()));
        command.add("-sDefaultRGBProfile=" + String.valueOf(colorProfiles.rgb().toAbsolutePath()));
        command.add("-sDefaultGrayProfile=" + String.valueOf(colorProfiles.gray().toAbsolutePath()));
        command.add("-dEmbedAllFonts=true");
        command.add("-dSubsetFonts=false");
        command.add("-dCompressFonts=true");
        command.add("-dNOSUBSTFONTS=false");
        command.add("-dPDFSETTINGS=/prepress");
        command.add("-dNOPAUSE");
        command.add("-dBATCH");
        command.add("-dNOOUTERSAVE");
        command.add("-sOutputFile=" + String.valueOf(outputPdf.toAbsolutePath()));
        command.add(inputPdf.toAbsolutePath().toString());
        return command;
    }

    private static void embedMissingFonts(PDDocument loDoc, PDDocument baseDoc, Set<String> missingFonts) throws IOException {
        ArrayList loPages = new ArrayList(loDoc.getNumberOfPages());
        loDoc.getPages().forEach(loPages::add);
        ArrayList basePages = new ArrayList(baseDoc.getNumberOfPages());
        baseDoc.getPages().forEach(basePages::add);
        for (int i = 0; i < loPages.size(); ++i) {
            PDResources loRes = ((PDPage)loPages.get(i)).getResources();
            PDResources baseRes = ((PDPage)basePages.get(i)).getResources();
            for (COSName fontKey : loRes.getFontNames()) {
                byte[] fontBytes;
                PDFontDescriptor desc;
                String psName;
                PDFont loFont = loRes.getFont(fontKey);
                if (loFont == null || !missingFonts.contains(psName = loFont.getName()) || (desc = loFont.getFontDescriptor()) == null) continue;
                PDStream fontStream = null;
                if (desc.getFontFile() != null) {
                    fontStream = desc.getFontFile();
                } else if (desc.getFontFile2() != null) {
                    fontStream = desc.getFontFile2();
                } else if (desc.getFontFile3() != null) {
                    fontStream = desc.getFontFile3();
                }
                if (fontStream == null) continue;
                try (COSInputStream in = fontStream.createInputStream();){
                    fontBytes = in.readAllBytes();
                }
                PDType0Font embeddedFont = null;
                try (ByteArrayInputStream tryIn = new ByteArrayInputStream(fontBytes);){
                    embeddedFont = PDType0Font.load((PDDocument)baseDoc, (InputStream)tryIn, (boolean)false);
                }
                catch (IOException e1) {
                    try (ByteArrayInputStream tryIn2 = new ByteArrayInputStream(fontBytes);){
                        try {
                            embeddedFont = PDTrueTypeFont.load((PDDocument)baseDoc, (InputStream)tryIn2, null);
                        }
                        catch (IOException | IllegalArgumentException e2) {
                            log.error("Could not embed font {}: {}", (Object)psName, (Object)e2.getMessage());
                        }
                    }
                }
                if (embeddedFont == null) continue;
                baseRes.put(fontKey, (PDFont)embeddedFont);
            }
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/pdf/pdfa"})
    @Operation(summary="Convert a PDF to a PDF/A or PDF/X", description="This endpoint converts a PDF file to a PDF/A or PDF/X file using Ghostscript (preferred) or PDFBox/LibreOffice (fallback). PDF/A is a format designed for long-term archiving, while PDF/X is optimized for print production. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> pdfToPdfA(@ModelAttribute PdfToPdfARequest request) throws Exception {
        boolean isPdfX;
        MultipartFile inputFile = request.getFileInput();
        String outputFormat = request.getOutputFormat();
        if (!"application/pdf".equals(inputFile.getContentType())) {
            log.error("Invalid input file type: {}", (Object)inputFile.getContentType());
            throw ExceptionUtils.createPdfFileRequiredException();
        }
        boolean bl = isPdfX = outputFormat != null && outputFormat.toLowerCase().startsWith("pdfx");
        if (isPdfX) {
            return this.handlePdfXConversion(inputFile, outputFormat);
        }
        return this.handlePdfAConversion(inputFile, outputFormat);
    }

    private static Set<String> findUnembeddedFontNames(PDDocument doc) throws IOException {
        HashSet<String> missing = new HashSet<String>(16);
        for (PDPage page : doc.getPages()) {
            PDResources res = page.getResources();
            for (COSName name : res.getFontNames()) {
                PDFont font = res.getFont(name);
                if (font == null || font.isEmbedded()) continue;
                missing.add(font.getName());
            }
        }
        return missing;
    }

    private ResponseEntity<byte[]> handlePdfXConversion(MultipartFile inputFile, String outputFormat) throws Exception {
        PdfXProfile profile = PdfXProfile.fromRequest((String)outputFormat);
        String originalFileName = Filenames.toSimpleFileName((String)inputFile.getOriginalFilename());
        if (originalFileName == null || originalFileName.trim().isEmpty()) {
            originalFileName = "output.pdf";
        }
        String baseFileName = originalFileName.contains(".") ? originalFileName.substring(0, originalFileName.lastIndexOf(46)) : originalFileName;
        Path workingDir = Files.createTempDirectory("pdfx_conversion_", new FileAttribute[0]);
        Path inputPath = workingDir.resolve("input.pdf");
        inputFile.transferTo(inputPath);
        try {
            if (!this.isGhostscriptAvailable()) {
                log.error("Ghostscript is required for PDF/X conversion");
                throw new IOException("Ghostscript is required for PDF/X conversion but is not available on the system");
            }
            log.info("Using Ghostscript for PDF/X conversion to {}", (Object)profile.getDisplayName());
            byte[] converted = this.convertWithGhostscriptX(inputPath, workingDir, profile);
            String outputFilename = baseFileName + profile.outputSuffix();
            log.info("PDF/X conversion completed successfully to {}", (Object)profile.getDisplayName());
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])converted, (String)outputFilename, (MediaType)MediaType.APPLICATION_PDF);
            return responseEntity;
        }
        catch (IOException | InterruptedException e) {
            log.error("PDF/X conversion failed", (Throwable)e);
            throw ExceptionUtils.createPdfaConversionFailedException();
        }
        finally {
            ConvertPDFToPDFA.deleteQuietly((Path)workingDir);
        }
    }

    private boolean isGhostscriptAvailable() {
        try {
            ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT).runCommandWithOutputHandling(Arrays.asList("gs", "--version"));
            return result.getRc() == 0;
        }
        catch (Exception e) {
            log.debug("Ghostscript availability check failed", (Throwable)e);
            return false;
        }
    }

    public static void fixType1FontCharSet(PDDocument document) throws IOException {
        for (PDPage page : document.getPages()) {
            PDResources resources = page.getResources();
            if (resources == null) continue;
            for (COSName fontName : resources.getFontNames()) {
                try {
                    String glyphSet;
                    boolean hasFontFile;
                    boolean isType1;
                    PDFontDescriptor descriptor;
                    String fontNameStr;
                    PDFont font = resources.getFont(fontName);
                    if (font == null || (fontNameStr = font.getName()) == null || (descriptor = font.getFontDescriptor()) == null || !(isType1 = ConvertPDFToPDFA.isType1Font((PDFont)font) || descriptor.getFontFile() != null || descriptor.getFontFile2() == null && descriptor.getFontFile3() == null)) continue;
                    COSDictionary descDict = descriptor.getCOSObject();
                    String existingCharSet = descDict.getString(COSName.CHAR_SET);
                    boolean fontEmbedded = font.isEmbedded();
                    boolean bl = hasFontFile = descriptor.getFontFile() != null || descriptor.getFontFile2() != null || descriptor.getFontFile3() != null;
                    if (existingCharSet != null && !existingCharSet.trim().isEmpty()) {
                        if (fontNameStr.contains("+") || fontNameStr.contains("Subset")) {
                            descDict.removeItem(COSName.CHAR_SET);
                            log.debug("Removed potentially invalid CharSet from subsetted Type1 font: {}", (Object)fontNameStr);
                            continue;
                        }
                        if (hasFontFile || !fontEmbedded) continue;
                        descDict.removeItem(COSName.CHAR_SET);
                        log.debug("Removed unverifiable CharSet from embedded Type1 font: {}", (Object)fontNameStr);
                        continue;
                    }
                    if (existingCharSet != null && !existingCharSet.trim().isEmpty() || fontNameStr.contains("+") || fontNameStr.contains("Subset") || !hasFontFile || (glyphSet = ConvertPDFToPDFA.buildStandardType1GlyphSet()).isEmpty()) continue;
                    descDict.setString(COSName.CHAR_SET, glyphSet);
                    log.debug("Added missing CharSet for Type1 font {} with {} glyphs", (Object)fontNameStr, (Object)ConvertPDFToPDFA.countGlyphs((String)glyphSet));
                }
                catch (Exception e) {
                    log.warn("Error processing font descriptor for page resource: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private static void importFlattenedImages(PDDocument loDoc, PDDocument baseDoc) throws IOException {
        ArrayList loPages = new ArrayList(loDoc.getNumberOfPages());
        loDoc.getPages().forEach(loPages::add);
        ArrayList basePages = new ArrayList(baseDoc.getNumberOfPages());
        baseDoc.getPages().forEach(basePages::add);
        for (int i = 0; i < loPages.size(); ++i) {
            PDPage loPage = (PDPage)loPages.get(i);
            PDPage basePage = (PDPage)basePages.get(i);
            PDResources loRes = loPage.getResources();
            PDResources baseRes = basePage.getResources();
            if (loRes == null || baseRes == null) continue;
            Set toReplace = ConvertPDFToPDFA.detectTransparentXObjects((PDPage)basePage);
            for (COSName name : toReplace) {
                PDXObject loXo = loRes.getXObject(name);
                if (!(loXo instanceof PDImageXObject)) continue;
                PDImageXObject img = (PDImageXObject)loXo;
                PDImageXObject newImg = LosslessFactory.createFromImage((PDDocument)baseDoc, (BufferedImage)img.getImage());
                baseRes.put(name, (PDXObject)newImg);
            }
        }
    }

    private ColorProfiles prepareColorProfiles(Path workingDir) throws IOException {
        Path rgbProfile = workingDir.resolve("sRGB.icc");
        this.copyResourceIcc(rgbProfile);
        Path grayProfile = workingDir.resolve("Gray.icc");
        try {
            ConvertPDFToPDFA.writeJavaIccProfile((ICC_Profile)ICC_Profile.getInstance(1003), (Path)grayProfile);
        }
        catch (IllegalArgumentException e) {
            log.warn("Falling back to sRGB ICC profile for grayscale defaults", (Throwable)e);
            Files.copy(rgbProfile, grayProfile, StandardCopyOption.REPLACE_EXISTING);
        }
        return new ColorProfiles(rgbProfile, grayProfile);
    }

    private static Set<COSName> detectTransparentXObjects(PDPage page) {
        HashSet<COSName> transparentObjects = new HashSet<COSName>();
        PDResources res = page.getResources();
        if (res == null) {
            return transparentObjects;
        }
        for (COSName name : res.getXObjectNames()) {
            try {
                PDImageXObject img;
                COSStream d;
                PDXObject xo = res.getXObject(name);
                if (!(xo instanceof PDImageXObject) || !(d = (img = (PDImageXObject)xo).getCOSObject()).containsKey(COSName.SMASK) && !ConvertPDFToPDFA.isTransparencyGroup((COSDictionary)d) && !d.getBoolean(COSName.INTERPOLATE, false)) continue;
                transparentObjects.add(name);
            }
            catch (IOException ioe) {
                log.error("Error processing XObject {}: {}", (Object)name.getName(), (Object)ioe.getMessage());
            }
        }
        return transparentObjects;
    }

    private byte[] convertToPdfA(Path basePdfPath, Path loPdfPath, int pdfaPart, Set<String> missingFonts, boolean importImages) throws Exception {
        try (PDDocument baseDoc = Loader.loadPDF((File)basePdfPath.toFile());){
            if (loPdfPath != null) {
                try (PDDocument loDoc = Loader.loadPDF((File)loPdfPath.toFile());){
                    if (!missingFonts.isEmpty()) {
                        ConvertPDFToPDFA.embedMissingFonts((PDDocument)loDoc, (PDDocument)baseDoc, missingFonts);
                    }
                    if (importImages) {
                        ConvertPDFToPDFA.importFlattenedImages((PDDocument)loDoc, (PDDocument)baseDoc);
                    }
                }
            }
            byte[] byArray = this.processWithPDFBox(baseDoc, pdfaPart);
            return byArray;
        }
    }

    private static int countGlyphs(String charSet) {
        if (charSet == null || charSet.isEmpty()) {
            return 0;
        }
        return (int)charSet.chars().filter(c -> c == 47).count();
    }

    private static void sanitizePdfA(COSBase base, int pdfaPart) {
        block9: {
            block8: {
                COSName type;
                if (!(base instanceof COSDictionary)) break block8;
                COSDictionary dict = (COSDictionary)base;
                if (pdfaPart == 3 && (COSName.FILESPEC.equals((Object)(type = dict.getCOSName(COSName.TYPE))) || dict.containsKey(COSName.EF))) {
                    return;
                }
                if (pdfaPart == 1) {
                    COSDictionary gDict;
                    COSBase group = dict.getDictionaryObject(COSName.GROUP);
                    if (group instanceof COSDictionary && COSName.TRANSPARENCY.equals((Object)(gDict = (COSDictionary)group).getCOSName(COSName.S))) {
                        dict.removeItem(COSName.GROUP);
                    }
                    dict.removeItem(COSName.SMASK);
                    dict.removeItem(COSName.CA);
                    dict.removeItem(COSName.getPDFName((String)"ca"));
                }
                if (dict.containsKey(COSName.INTERPOLATE) && dict.getBoolean(COSName.INTERPOLATE, true)) {
                    dict.setBoolean(COSName.INTERPOLATE, false);
                }
                dict.removeItem(COSName.JAVA_SCRIPT);
                dict.removeItem(COSName.getPDFName((String)"JS"));
                dict.removeItem(COSName.getPDFName((String)"RichMedia"));
                dict.removeItem(COSName.getPDFName((String)"Movie"));
                dict.removeItem(COSName.getPDFName((String)"Sound"));
                dict.removeItem(COSName.getPDFName((String)"Launch"));
                if (pdfaPart != 3) {
                    dict.removeItem(COSName.URI);
                }
                dict.removeItem(COSName.getPDFName((String)"GoToR"));
                if (pdfaPart != 3) {
                    dict.removeItem(COSName.EMBEDDED_FILES);
                    dict.removeItem(COSName.FILESPEC);
                }
                for (Map.Entry entry : dict.entrySet()) {
                    COSName key;
                    if (pdfaPart == 3 && (COSName.EF.equals((Object)(key = (COSName)entry.getKey())) || COSName.EMBEDDED_FILES.equals((Object)key) || COSName.FILESPEC.equals((Object)key) || COSName.F.equals((Object)key) || COSName.UF.equals((Object)key))) continue;
                    ConvertPDFToPDFA.sanitizePdfA((COSBase)((COSBase)entry.getValue()), (int)pdfaPart);
                }
                break block9;
            }
            if (!(base instanceof COSArray)) break block9;
            COSArray arr = (COSArray)base;
            for (COSBase item : arr) {
                ConvertPDFToPDFA.sanitizePdfA((COSBase)item, (int)pdfaPart);
            }
        }
    }

    private static void removeElementsForPdfA(PDDocument doc, int pdfaPart) {
        if (pdfaPart == 1) {
            doc.getDocumentCatalog().getCOSObject().removeItem(COSName.getPDFName((String)"OCProperties"));
        }
        if (pdfaPart == 3) {
            ConvertPDFToPDFA.ensureEmbeddedFilesAFRelationship((PDDocument)doc);
        }
        for (PDPage page : doc.getPages()) {
            if (pdfaPart == 1) {
                page.setAnnotations(Collections.emptyList());
            }
            PDResources res = page.getResources();
            ConvertPDFToPDFA.sanitizePdfA((COSBase)page.getCOSObject(), (int)pdfaPart);
            if (res == null) continue;
            for (COSName name : res.getXObjectNames()) {
                try {
                    PDXObject xo = res.getXObject(name);
                    if (xo instanceof PDFormXObject) {
                        PDFormXObject form = (PDFormXObject)xo;
                        ConvertPDFToPDFA.sanitizePdfA((COSBase)form.getCOSObject(), (int)pdfaPart);
                        continue;
                    }
                    if (!(xo instanceof PDImageXObject)) continue;
                    PDImageXObject img = (PDImageXObject)xo;
                    ConvertPDFToPDFA.sanitizePdfA((COSBase)img.getCOSObject(), (int)pdfaPart);
                }
                catch (IOException ioe) {
                    log.error("Cannot load XObject {}: {}", (Object)name.getName(), (Object)ioe.getMessage());
                }
            }
        }
    }

    private static String buildStandardType1GlyphSet() {
        LinkedHashSet glyphNames = new LinkedHashSet();
        String[] standardGlyphs = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "currency", "yen", "brokenbar", "section", "dieresis", "copyright", "ordfeminine", "guillemotleft", "logicalnot", "uni00AD", "registered", "macron", "degree", "plusminus", "twosuperior", "threesuperior", "acute", "mu", "paragraph", "periodcentered", "cedilla", "onesuperior", "ordmasculine", "guillemotright", "onequarter", "onehalf", "threequarters", "questiondown", "Agrave", "Aacute", "Acircumflex", "Atilde", "Adieresis", "Aring", "AE", "Ccedilla", "Egrave", "Eacute", "Ecircumflex", "Edieresis", "Igrave", "Iacute", "Icircumflex", "Idieresis", "Eth", "Ntilde", "Ograve", "Oacute", "Ocircumflex", "Otilde", "Odieresis", "multiply", "Oslash", "Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn", "germandbls", "agrave", "aacute", "acircumflex", "atilde", "adieresis", "aring", "ae", "ccedilla", "egrave", "eacute", "ecircumflex", "edieresis", "igrave", "iacute", "icircumflex", "idieresis", "eth", "ntilde", "ograve", "oacute", "ocircumflex", "otilde", "odieresis", "divide", "oslash", "ugrave", "uacute", "ucircumflex", "udieresis", "yacute", "thorn", "ydieresis"};
        Collections.addAll(glyphNames, standardGlyphs);
        return String.join((CharSequence)" ", glyphNames);
    }

    private byte[] processWithPDFBox(PDDocument document, int pdfaPart) throws Exception {
        ConvertPDFToPDFA.removeElementsForPdfA((PDDocument)document, (int)pdfaPart);
        document.getDocument().setVersion(pdfaPart == 1 ? 1.4f : 1.7f);
        ConvertPDFToPDFA.mergeAndAddXmpMetadata((PDDocument)document, (int)pdfaPart);
        this.addICCProfileIfNotPresent(document);
        if (pdfaPart == 1) {
            ConvertPDFToPDFA.fixCidSetIssues((PDDocument)document);
        }
        ConvertPDFToPDFA.fixType1FontCharSet((PDDocument)document);
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        catalog.setMetadata(document.getDocumentCatalog().getMetadata());
        PDViewerPreferences viewerPrefs = new PDViewerPreferences(catalog.getCOSObject());
        viewerPrefs.setDisplayDocTitle(true);
        catalog.setViewerPreferences(viewerPrefs);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressParameters compressParams = pdfaPart == 1 ? CompressParameters.NO_COMPRESSION : new CompressParameters();
        document.save((OutputStream)baos, compressParams);
        log.debug("PDF/A-{} document processed with PDFBox", (Object)pdfaPart);
        return baos.toByteArray();
    }

    private static void ensureEmbeddedFilesAFRelationship(PDDocument doc) {
        PDDocumentCatalog catalog = doc.getDocumentCatalog();
        PDDocumentNameDictionary names = catalog.getNames();
        if (names == null) {
            return;
        }
        PDEmbeddedFilesNameTreeNode embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            return;
        }
        try {
            ConvertPDFToPDFA.processEmbeddedFilesForAFRelationship((PDEmbeddedFilesNameTreeNode)embeddedFiles);
        }
        catch (IOException e) {
            log.warn("Could not process embedded files AFRelationship: {}", (Object)e.getMessage());
        }
    }

    private static void processEmbeddedFilesForAFRelationship(PDEmbeddedFilesNameTreeNode embeddedFiles) throws IOException {
        Map fileSpecs = embeddedFiles.getNames();
        if (fileSpecs == null) {
            return;
        }
        for (PDComplexFileSpecification fileSpec : fileSpecs.values()) {
            COSDictionary fileSpecDict = fileSpec.getCOSObject();
            if (fileSpecDict.containsKey(COS_AF_RELATIONSHIP)) continue;
            fileSpecDict.setName(COS_AF_RELATIONSHIP, "Unspecified");
        }
    }

    private static boolean isTransparencyGroup(COSDictionary dict) {
        COSDictionary gd;
        COSBase g = dict.getDictionaryObject(COSName.GROUP);
        return g instanceof COSDictionary && COSName.TRANSPARENCY.equals((Object)(gd = (COSDictionary)g).getCOSName(COSName.S));
    }

    private static boolean hasTransparentImages(PDDocument doc) {
        for (PDPage page : doc.getPages()) {
            PDResources res = page.getResources();
            if (res == null) continue;
            for (COSName name : res.getXObjectNames()) {
                try {
                    COSDictionary gd;
                    PDXObject xo = res.getXObject(name);
                    if (!(xo instanceof PDImageXObject)) continue;
                    PDImageXObject img = (PDImageXObject)xo;
                    COSStream dict = img.getCOSObject();
                    if (dict.containsKey(COSName.SMASK)) {
                        return true;
                    }
                    COSBase g = dict.getDictionaryObject(COSName.GROUP);
                    if (g instanceof COSDictionary && COSName.TRANSPARENCY.equals((Object)(gd = (COSDictionary)g).getCOSName(COSName.S))) {
                        return true;
                    }
                    if (!dict.getBoolean(COSName.INTERPOLATE, false)) continue;
                    return true;
                }
                catch (IOException ioe) {
                    log.error("Error processing XObject {}: {}", (Object)name.getName(), (Object)ioe.getMessage());
                }
            }
        }
        return false;
    }

    private static File preProcessHighlights(File inputPdf) throws Exception {
        try (PDDocument document = Loader.loadPDF((File)inputPdf);){
            for (PDPage page : document.getPages()) {
                List annotations = page.getAnnotations();
                for (PDAnnotation annot : annotations) {
                    COSDictionary groupDict;
                    float[] fArray;
                    if (!"Highlight".equals(annot.getSubtype()) || !(annot instanceof PDAnnotationHighlight)) continue;
                    PDAnnotationHighlight highlight = (PDAnnotationHighlight)annot;
                    if (highlight.getColor() != null) {
                        fArray = highlight.getColor().getComponents();
                    } else {
                        float[] fArray2 = new float[3];
                        fArray2[0] = 1.0f;
                        fArray2[1] = 1.0f;
                        fArray = fArray2;
                        fArray2[2] = 0.0f;
                    }
                    float[] colorComponents = fArray;
                    Color highlightColor = new Color(colorComponents[0], colorComponents[1], colorComponents[2]);
                    float[] quadPoints = highlight.getQuadPoints();
                    if (quadPoints != null) {
                        try (PDPageContentStream cs = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.PREPEND, true, true);){
                            cs.setStrokingColor(highlightColor);
                            cs.setLineWidth(0.05f);
                            float spacing = 2.0f;
                            for (int i = 0; i < quadPoints.length; i += 8) {
                                float len;
                                float minX = Math.min(Math.min(quadPoints[i], quadPoints[i + 2]), Math.min(quadPoints[i + 4], quadPoints[i + 6]));
                                float maxX = Math.max(Math.max(quadPoints[i], quadPoints[i + 2]), Math.max(quadPoints[i + 4], quadPoints[i + 6]));
                                float minY = Math.min(Math.min(quadPoints[i + 1], quadPoints[i + 3]), Math.min(quadPoints[i + 5], quadPoints[i + 7]));
                                float maxY = Math.max(Math.max(quadPoints[i + 1], quadPoints[i + 3]), Math.max(quadPoints[i + 5], quadPoints[i + 7]));
                                float width = maxX - minX;
                                float height = maxY - minY;
                                for (float y = minY; y <= maxY; y += spacing) {
                                    len = Math.min(width, maxY - y);
                                    cs.moveTo(minX, y);
                                    cs.lineTo(minX + len, y + len);
                                }
                                for (float x = minX + spacing; x <= maxX; x += spacing) {
                                    len = Math.min(maxX - x, height);
                                    cs.moveTo(x, minY);
                                    cs.lineTo(x + len, minY + len);
                                }
                            }
                            cs.stroke();
                        }
                    }
                    page.getAnnotations().remove(highlight);
                    COSDictionary pageDict = page.getCOSObject();
                    if (!pageDict.containsKey(COSName.GROUP) || (groupDict = (COSDictionary)pageDict.getDictionaryObject(COSName.GROUP)) == null || !COSName.TRANSPARENCY.getName().equalsIgnoreCase(groupDict.getNameAsString(COSName.S))) continue;
                    pageDict.removeItem(COSName.GROUP);
                }
            }
            File preProcessedFile = Files.createTempFile("preprocessed_", ".pdf", new FileAttribute[0]).toFile();
            document.save(preProcessedFile);
            File file = preProcessedFile;
            return file;
        }
    }

    private static void sanitizeFontResources(PDDocument doc) throws IOException {
        for (PDPage page : doc.getPages()) {
            PDResources res = page.getResources();
            if (res == null) continue;
            for (COSName fontName : res.getFontNames()) {
                String existingCharSet;
                PDFontDescriptor desc;
                PDFont font = res.getFont(fontName);
                if (font == null || (desc = font.getFontDescriptor()) == null) continue;
                COSDictionary descDict = desc.getCOSObject();
                if (descDict.containsKey(COSName.getPDFName((String)"CIDSet"))) {
                    descDict.removeItem(COSName.getPDFName((String)"CIDSet"));
                }
                if (!ConvertPDFToPDFA.isType1Font((PDFont)font) || !descDict.containsKey(COSName.CHAR_SET) || (existingCharSet = descDict.getString(COSName.CHAR_SET)) != null && !existingCharSet.trim().isEmpty() && !"/.notdef".equals(existingCharSet)) continue;
                descDict.removeItem(COSName.CHAR_SET);
                log.debug("Removed invalid CharSet from Type 1 font: {}", (Object)font.getName());
            }
        }
    }

    private static boolean isType1Font(PDFont font) {
        return font instanceof PDType1Font || font instanceof PDType1CFont;
    }

    private static void fixOptionalContentGroups(PDDocument doc) {
        COSDictionary ocgDict;
        String nameValue;
        PDDocumentCatalog catalog = doc.getDocumentCatalog();
        PDOptionalContentProperties ocProps = catalog.getOCProperties();
        if (ocProps == null) {
            return;
        }
        COSBase ocPropsBase = catalog.getCOSObject().getDictionaryObject(COSName.getPDFName((String)"OCProperties"));
        if (!(ocPropsBase instanceof COSDictionary)) {
            return;
        }
        COSDictionary ocPropsDict = (COSDictionary)ocPropsBase;
        COSBase ocgs = ocPropsDict.getDictionaryObject(COSName.OCGS);
        if (ocgs instanceof COSArray) {
            COSArray ocgArray = (COSArray)ocgs;
            int unnamedCount = 1;
            for (COSBase base : ocgArray) {
                COSDictionary ocgDict2;
                String nameValue2;
                if (!(base instanceof COSDictionary) || (nameValue2 = (ocgDict2 = (COSDictionary)base).getString(COSName.NAME)) != null && !nameValue2.trim().isEmpty()) continue;
                String newName = "Layer " + unnamedCount++;
                ocgDict2.setString(COSName.NAME, newName);
                log.debug("Fixed OCG missing or empty name, set to: {}", (Object)newName);
            }
        } else if (ocgs instanceof COSDictionary && ((nameValue = (ocgDict = (COSDictionary)ocgs).getString(COSName.NAME)) == null || nameValue.trim().isEmpty())) {
            ocgDict.setString(COSName.NAME, "Layer 1");
            log.debug("Fixed single OCG missing or empty name");
        }
    }

    private static void mergeAndAddXmpMetadata(PDDocument document, int pdfaPart) throws Exception {
        String keywords;
        String subject;
        String title;
        AdobePDFSchema adobePdfSchema;
        PDDocumentInformation docInfo;
        XMPMetadata xmp;
        PDMetadata existingMetadata = document.getDocumentCatalog().getMetadata();
        if (existingMetadata != null) {
            try (COSInputStream xmpStream = existingMetadata.createInputStream();){
                DomXmpParser parser = new DomXmpParser();
                parser.setStrictParsing(false);
                xmp = parser.parse((InputStream)xmpStream);
            }
            catch (Exception e) {
                xmp = XMPMetadata.createXMPMetadata();
            }
        } else {
            xmp = XMPMetadata.createXMPMetadata();
        }
        if ((docInfo = document.getDocumentInformation()) == null) {
            docInfo = new PDDocumentInformation();
        }
        String originalCreator = Optional.ofNullable(docInfo.getCreator()).orElse("Unknown");
        String originalProducer = Optional.ofNullable(docInfo.getProducer()).orElse("Unknown");
        DublinCoreSchema dcSchema = xmp.getDublinCoreSchema();
        if (dcSchema != null) {
            List existingCreators = dcSchema.getCreators();
            if (existingCreators != null) {
                for (String creator : new ArrayList(existingCreators)) {
                    dcSchema.removeCreator(creator);
                }
            }
        } else {
            dcSchema = xmp.createAndAddDublinCoreSchema();
        }
        dcSchema.addCreator(originalCreator);
        PDFAIdentificationSchema pdfaSchema = (PDFAIdentificationSchema)xmp.getSchema(PDFAIdentificationSchema.class);
        if (pdfaSchema == null) {
            pdfaSchema = xmp.createAndAddPDFAIdentificationSchema();
        }
        pdfaSchema.setPart(Integer.valueOf(pdfaPart));
        pdfaSchema.setConformance("B");
        XMPBasicSchema xmpBasicSchema = xmp.getXMPBasicSchema();
        if (xmpBasicSchema == null) {
            xmpBasicSchema = xmp.createAndAddXMPBasicSchema();
        }
        if ((adobePdfSchema = xmp.getAdobePDFSchema()) == null) {
            adobePdfSchema = xmp.createAndAddAdobePDFSchema();
        }
        docInfo.setCreator(originalCreator);
        xmpBasicSchema.setCreatorTool(originalCreator);
        docInfo.setProducer(originalProducer);
        adobePdfSchema.setProducer(originalProducer);
        String originalAuthor = docInfo.getAuthor();
        if (originalAuthor != null && !originalAuthor.isBlank()) {
            docInfo.setAuthor(null);
            if (!originalCreator.equals(originalAuthor)) {
                dcSchema.addCreator(originalAuthor);
            }
        }
        if ((title = docInfo.getTitle()) != null && !title.isBlank()) {
            dcSchema.setTitle(title);
        }
        if ((subject = docInfo.getSubject()) != null && !subject.isBlank()) {
            dcSchema.addSubject(subject);
        }
        if ((keywords = docInfo.getKeywords()) != null && !keywords.isBlank()) {
            adobePdfSchema.setKeywords(keywords);
        }
        Instant nowInstant = Instant.now();
        ZonedDateTime nowZdt = ZonedDateTime.ofInstant(nowInstant, ZoneId.of("UTC"));
        Calendar originalCreationDate = docInfo.getCreationDate();
        Instant creationInstant = originalCreationDate != null ? originalCreationDate.toInstant() : nowInstant;
        ZonedDateTime creationZdt = ZonedDateTime.ofInstant(creationInstant, ZoneId.of("UTC"));
        GregorianCalendar creationCal = GregorianCalendar.from(creationZdt);
        GregorianCalendar modificationCal = GregorianCalendar.from(nowZdt);
        docInfo.setCreationDate((Calendar)creationCal);
        xmpBasicSchema.setCreateDate((Calendar)creationCal);
        docInfo.setModificationDate((Calendar)modificationCal);
        xmpBasicSchema.setModifyDate((Calendar)modificationCal);
        xmpBasicSchema.setMetadataDate((Calendar)modificationCal);
        ByteArrayOutputStream xmpOut = new ByteArrayOutputStream();
        new XmpSerializer().serialize(xmp, (OutputStream)xmpOut, true);
        PDMetadata newMetadata = new PDMetadata(document);
        newMetadata.importXMPMetadata(xmpOut.toByteArray());
        document.getDocumentCatalog().setMetadata(newMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertWithGhostscript(Path inputPdf, Path workingDir, PdfaProfile profile) throws IOException, InterruptedException {
        Path normalizedInputPdf;
        Path cidSetCleaned;
        Path preprocessedPdf;
        Path outputPdf = workingDir.resolve("gs_output.pdf");
        ColorProfiles colorProfiles = this.prepareColorProfiles(workingDir);
        Path pdfaDefFile = ConvertPDFToPDFA.createPdfaDefFile((Path)workingDir, (ColorProfiles)colorProfiles, (PdfaProfile)profile);
        Path sanitizedInputPdf = this.sanitizePdfWithPdfBox(inputPdf, true);
        Path path = preprocessedPdf = sanitizedInputPdf != null ? sanitizedInputPdf : inputPdf;
        if (profile.getPart() == 1 && (cidSetCleaned = this.cleanCidSetWithQpdf(preprocessedPdf)) != null) {
            preprocessedPdf = cidSetCleaned;
        }
        Path inputForGs = (normalizedInputPdf = this.normalizePdfWithQpdf(preprocessedPdf)) != null ? normalizedInputPdf : preprocessedPdf;
        try {
            List command = ConvertPDFToPDFA.buildGhostscriptCommand((Path)inputForGs, (Path)outputPdf, (ColorProfiles)colorProfiles, (Path)workingDir, (PdfaProfile)profile, (Path)pdfaDefFile);
            log.info("Running Ghostscript command: {}", (Object)String.join((CharSequence)" ", command));
            ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT).runCommandWithOutputHandling(command);
            if (result.getRc() != 0) {
                log.error("Ghostscript failed with output: {}", (Object)result.getMessages());
                throw new IOException("Ghostscript exited with code " + result.getRc());
            }
            if (!Files.exists(outputPdf, new LinkOption[0])) {
                throw new IOException("Ghostscript did not produce an output file");
            }
            byte[] byArray = Files.readAllBytes(outputPdf);
            return byArray;
        }
        finally {
            if (normalizedInputPdf != null && !normalizedInputPdf.equals(preprocessedPdf)) {
                try {
                    Files.deleteIfExists(normalizedInputPdf);
                }
                catch (IOException e) {
                    log.debug("Failed to delete temporary normalized file", (Throwable)e);
                }
            }
            if (preprocessedPdf != null && !preprocessedPdf.equals(inputPdf)) {
                try {
                    Files.deleteIfExists(preprocessedPdf);
                }
                catch (IOException e) {
                    log.debug("Failed to delete temporary sanitized or CIDSet cleaned file", (Throwable)e);
                }
            }
            if (sanitizedInputPdf != null && !sanitizedInputPdf.equals(inputPdf)) {
                try {
                    Files.deleteIfExists(sanitizedInputPdf);
                }
                catch (IOException e) {
                    log.debug("Failed to delete temporary sanitized file", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path runLibreOfficeConversion(Path tempInputFile, int pdfaPart) throws Exception {
        Path tempOutputDir = Files.createTempDirectory("output_", new FileAttribute[0]);
        String pdfFilter = pdfaPart == 2 ? "pdf:writer_pdf_Export:{\"SelectPdfVersion\":{\"type\":\"long\",\"value\":\"2\"}}" : "pdf:writer_pdf_Export:{\"SelectPdfVersion\":{\"type\":\"long\",\"value\":\"1\"}}";
        Path libreOfficeProfile = Files.createTempDirectory("libreoffice_profile_", new FileAttribute[0]);
        try {
            ArrayList<String> command = new ArrayList<String>(Arrays.asList(this.runtimePathConfig.getSOfficePath(), "-env:UserInstallation=" + String.valueOf(libreOfficeProfile.toUri()), "--headless", "--nologo", "--convert-to", pdfFilter, "--outdir", tempOutputDir.toString(), tempInputFile.toString()));
            ProcessExecutor.ProcessExecutorResult returnCode = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.LIBRE_OFFICE).runCommandWithOutputHandling(command);
            if (returnCode.getRc() != 0) {
                log.error("PDF/A conversion failed with return code: {}", (Object)returnCode.getRc());
                throw ExceptionUtils.createPdfaConversionFailedException();
            }
        }
        finally {
            FileUtils.deleteQuietly((File)libreOfficeProfile.toFile());
        }
        File[] outputFiles = tempOutputDir.toFile().listFiles();
        if (outputFiles == null || outputFiles.length != 1) {
            throw ExceptionUtils.createPdfaConversionFailedException();
        }
        return outputFiles[0].toPath();
    }

    private Path normalizePdfWithQpdf(Path inputPdf) {
        try {
            ProcessExecutor.ProcessExecutorResult checkResult = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.QPDF).runCommandWithOutputHandling(Arrays.asList("qpdf", "--version"));
            if (checkResult.getRc() != 0) {
                log.debug("QPDF not available");
                return null;
            }
            Path normalizedPdf = inputPdf.getParent().resolve("normalized_" + inputPdf.getFileName().toString());
            List<String> command = Arrays.asList("qpdf", "--normalize-content=y", "--object-streams=preserve", inputPdf.toAbsolutePath().toString(), normalizedPdf.toAbsolutePath().toString());
            ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.QPDF).runCommandWithOutputHandling(command);
            if (result.getRc() == 0 && Files.exists(normalizedPdf, new LinkOption[0])) {
                log.info("PDF normalized with QPDF to fix font programs and CIDSet issues");
                return normalizedPdf;
            }
            return null;
        }
        catch (Exception e) {
            log.debug("QPDF normalization error: {}", (Object)e.getMessage());
            return null;
        }
    }

    private Path cleanCidSetWithQpdf(Path inputPdf) {
        try {
            ProcessExecutor.ProcessExecutorResult checkResult = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.QPDF).runCommandWithOutputHandling(Arrays.asList("qpdf", "--version"));
            if (checkResult.getRc() != 0) {
                log.debug("QPDF not available for CIDSet cleaning");
                return null;
            }
            Path cleanedPdf = inputPdf.getParent().resolve("cidset_cleaned_" + inputPdf.getFileName().toString());
            List<String> command = Arrays.asList("qpdf", "--remove-unreferenced-resources=yes", "--normalize-content=y", "--object-streams=preserve", inputPdf.toAbsolutePath().toString(), cleanedPdf.toAbsolutePath().toString());
            ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.QPDF).runCommandWithOutputHandling(command);
            if (result.getRc() == 0 && Files.exists(cleanedPdf, new LinkOption[0])) {
                log.info("PDF CIDSet cleaned with QPDF");
                return cleanedPdf;
            }
            return null;
        }
        catch (Exception e) {
            log.debug("QPDF CIDSet cleaning error: {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertWithPdfBoxMethod(Path inputPath, PdfaProfile profile) throws Exception {
        log.info("Starting PDFBox/LibreOffice conversion for PDF/A-{}", (Object)profile.getPart());
        Path tempInputFile = null;
        Path loPdfPath = null;
        File preProcessedFile = null;
        int pdfaPart = profile.getPart();
        Path normalizedPath = null;
        try {
            byte[] fileBytes;
            boolean needImgs;
            Set missingFonts;
            tempInputFile = inputPath;
            normalizedPath = this.normalizePdfWithQpdf(tempInputFile);
            if (normalizedPath != null) {
                tempInputFile = normalizedPath;
            }
            preProcessedFile = pdfaPart == 2 || pdfaPart == 3 ? tempInputFile.toFile() : ConvertPDFToPDFA.preProcessHighlights((File)tempInputFile.toFile());
            try (PDDocument doc = Loader.loadPDF((File)preProcessedFile);){
                missingFonts = ConvertPDFToPDFA.findUnembeddedFontNames((PDDocument)doc);
                boolean bl = needImgs = pdfaPart == 1 && ConvertPDFToPDFA.hasTransparentImages((PDDocument)doc);
                if (!missingFonts.isEmpty() || needImgs) {
                    loPdfPath = this.runLibreOfficeConversion(preProcessedFile.toPath(), pdfaPart);
                }
            }
            byte[] byArray = fileBytes = this.convertToPdfA(preProcessedFile.toPath(), loPdfPath, pdfaPart, missingFonts, needImgs);
            return byArray;
        }
        finally {
            if (loPdfPath != null && loPdfPath.getParent() != null) {
                FileUtils.deleteDirectory((File)loPdfPath.getParent().toFile());
            }
            if (preProcessedFile != null && !preProcessedFile.equals(tempInputFile.toFile())) {
                Files.deleteIfExists(preProcessedFile.toPath());
            }
            if (normalizedPath != null && !normalizedPath.equals(inputPath)) {
                Files.deleteIfExists(normalizedPath);
            }
        }
    }

    private byte[] convertWithGhostscriptX(Path inputPdf, Path workingDir, PdfXProfile profile) throws IOException, InterruptedException {
        Path outputPdf = workingDir.resolve("gs_output_pdfx.pdf");
        ColorProfiles colorProfiles = this.prepareColorProfiles(workingDir);
        Path sanitizedInputPdf = this.sanitizePdfWithPdfBox(inputPdf, true);
        Path inputForGs = sanitizedInputPdf != null ? sanitizedInputPdf : inputPdf;
        List command = ConvertPDFToPDFA.buildGhostscriptCommandX((Path)inputForGs, (Path)outputPdf, (ColorProfiles)colorProfiles, (Path)workingDir, (PdfXProfile)profile);
        log.info("Running Ghostscript PDF/X command: {}", (Object)String.join((CharSequence)" ", command));
        ProcessExecutor.ProcessExecutorResult result = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT).runCommandWithOutputHandling(command);
        if (result.getRc() != 0) {
            log.error("Ghostscript PDF/X failed with output: {}", (Object)result.getMessages());
            throw new IOException("Ghostscript exited with code " + result.getRc());
        }
        if (!Files.exists(outputPdf, new LinkOption[0])) {
            throw new IOException("Ghostscript did not produce an output file");
        }
        return Files.readAllBytes(outputPdf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ResponseEntity<byte[]> handlePdfAConversion(MultipartFile inputFile, String outputFormat) throws Exception {
        profile = PdfaProfile.fromRequest((String)outputFormat);
        originalFileName = Filenames.toSimpleFileName((String)inputFile.getOriginalFilename());
        if (originalFileName == null || originalFileName.trim().isEmpty()) {
            originalFileName = "output.pdf";
        }
        baseFileName = originalFileName.contains(".") != false ? originalFileName.substring(0, originalFileName.lastIndexOf(46)) : originalFileName;
        workingDir = Files.createTempDirectory("pdfa_conversion_", new FileAttribute[0]);
        inputPath = workingDir.resolve("input.pdf");
        inputFile.transferTo(inputPath);
        try {
            block7: {
                if (!this.isGhostscriptAvailable()) break block7;
                ConvertPDFToPDFA.log.info("Using Ghostscript for PDF/A conversion to {}", (Object)profile.getDisplayName());
                try {
                    converted = this.convertWithGhostscript(inputPath, workingDir, profile);
                    outputFilename = baseFileName + profile.outputSuffix();
                    ConvertPDFToPDFA.validateAndWarnPdfA((byte[])converted, (PdfaProfile)profile, (String)"Ghostscript");
                    var10_13 = WebResponseUtils.bytesToWebResponse((byte[])converted, (String)outputFilename, (MediaType)MediaType.APPLICATION_PDF);
                    return var10_13;
                }
                catch (IOException | InterruptedException e) {
                    ConvertPDFToPDFA.log.warn("Ghostscript conversion failed, falling back to PDFBox/LibreOffice method", (Throwable)e);
                    ** break block8
                }
            }
            ConvertPDFToPDFA.log.info("Ghostscript not available, using PDFBox/LibreOffice fallback method");
lbl-1000:
            // 2 sources

            {
                converted = this.convertWithPdfBoxMethod(inputPath, profile);
                outputFilename = baseFileName + profile.outputSuffix();
                ConvertPDFToPDFA.validateAndWarnPdfA((byte[])converted, (PdfaProfile)profile, (String)"PDFBox/LibreOffice");
                var10_14 = WebResponseUtils.bytesToWebResponse((byte[])converted, (String)outputFilename, (MediaType)MediaType.APPLICATION_PDF);
            }
            return var10_14;
        }
        finally {
            ConvertPDFToPDFA.deleteQuietly((Path)workingDir);
        }
    }

    private Path sanitizePdfWithPdfBox(Path inputPdf, boolean addWhiteBackground) {
        try {
            Path sanitizedPath = inputPdf.getParent().resolve("sanitized_" + inputPdf.getFileName().toString());
            this.sanitizeDocument(inputPdf, sanitizedPath, addWhiteBackground);
            log.info("PDF sanitized with PDFBox for better Ghostscript compatibility");
            return sanitizedPath;
        }
        catch (IOException e) {
            log.warn("PDF sanitization I/O error, proceeding with original file: {}", (Object)e.getMessage());
            return null;
        }
    }

    private void sanitizeDocument(Path inputPath, Path outputPath, boolean addWhiteBackground) throws IOException {
        try (PDDocument doc = Loader.loadPDF((File)inputPath.toFile());){
            LinkedHashMap<String, DocumentSanitizer> sanitizers = new LinkedHashMap<String, DocumentSanitizer>();
            sanitizers.put("Flatten highlight annotations", arg_0 -> this.flattenHighlightsToContent(arg_0));
            sanitizers.put("Sanitize font resources", ConvertPDFToPDFA::sanitizeFontResources);
            sanitizers.put("Clean metadata", arg_0 -> this.sanitizeMetadata(arg_0));
            sanitizers.put("Remove forbidden actions", arg_0 -> this.removeForbiddenActions(arg_0));
            sanitizers.put("Ensure annotation appearances", arg_0 -> this.ensureAnnotationAppearances(arg_0));
            sanitizers.put("Ensure embedded file compliance", arg_0 -> this.ensureEmbeddedFileCompliance(arg_0));
            sanitizers.put("Fix optional content groups", ConvertPDFToPDFA::fixOptionalContentGroups);
            sanitizers.put("Fix separation color spaces", arg_0 -> this.fixSeparationColorSpaces(arg_0));
            if (addWhiteBackground) {
                sanitizers.put("Add white background", arg_0 -> this.addWhiteBackground(arg_0));
            }
            for (Map.Entry entry : sanitizers.entrySet()) {
                try {
                    ((DocumentSanitizer)entry.getValue()).sanitize(doc);
                    log.debug("Sanitization step completed: {}", entry.getKey());
                }
                catch (Exception e) {
                    log.warn("Sanitization step '{}' failed, continuing: {}", entry.getKey(), (Object)e.getMessage());
                }
            }
            doc.save(outputPath.toFile());
        }
    }

    private void fixSeparationColorSpaces(PDDocument doc) throws IOException {
        HashMap knownTintTransforms = new HashMap();
        HashSet visitedResources = new HashSet();
        for (PDPage page : doc.getPages()) {
            PDResources resources = page.getResources();
            this.processResourcesForSeparation(resources, knownTintTransforms, visitedResources);
        }
        PDDocumentCatalog catalog = doc.getDocumentCatalog();
        if (catalog != null) {
            PDResources docResources;
            PDResources pDResources = docResources = catalog.getAcroForm() != null ? catalog.getAcroForm().getDefaultResources() : null;
            if (docResources != null) {
                this.processResourcesForSeparation(docResources, knownTintTransforms, visitedResources);
            }
        }
        visitedResources.clear();
        for (PDPage page : doc.getPages()) {
            PDResources resources = page.getResources();
            this.enforceSeparationConsistency(resources, knownTintTransforms, visitedResources);
        }
    }

    private void processResourcesForSeparation(PDResources resources, Map<String, COSBase> knownTintTransforms, Set<COSBase> visitedResources) {
        COSDictionary xObjDict;
        if (resources == null) {
            return;
        }
        if (!visitedResources.add((COSBase)resources.getCOSObject())) {
            return;
        }
        COSDictionary csDict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.COLORSPACE);
        if (csDict != null) {
            for (COSName name : csDict.keySet()) {
                COSBase csVal = csDict.getDictionaryObject(name);
                this.checkAndFixSeparation(csVal, knownTintTransforms);
            }
        }
        if ((xObjDict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.XOBJECT)) != null) {
            for (COSName name : xObjDict.keySet()) {
                COSBase formRes;
                COSStream stream;
                COSName type;
                COSBase xObj = xObjDict.getDictionaryObject(name);
                if (!(xObj instanceof COSStream) || !COSName.FORM.equals((Object)(type = (COSName)(stream = (COSStream)xObj).getDictionaryObject(COSName.SUBTYPE))) || !((formRes = stream.getDictionaryObject(COSName.RESOURCES)) instanceof COSDictionary)) continue;
                COSDictionary formResDict = (COSDictionary)formRes;
                this.processResourcesForSeparation(new PDResources(formResDict), knownTintTransforms, visitedResources);
            }
        }
    }

    private void checkAndFixSeparation(COSBase cs, Map<String, COSBase> knownTintTransforms) {
        COSBase nameBase;
        COSBase type;
        COSArray arr;
        if (cs instanceof COSArray && (arr = (COSArray)cs).size() >= 4 && COSName.SEPARATION.equals((Object)(type = arr.getObject(0))) && (nameBase = arr.getObject(1)) instanceof COSName) {
            COSName colorName = (COSName)nameBase;
            String name = colorName.getName();
            COSBase tintTransform = arr.getObject(3);
            if (knownTintTransforms.containsKey(name)) {
                COSBase known = knownTintTransforms.get(name);
                if (known != tintTransform) {
                    arr.set(3, known);
                    log.debug("Unified TintTransform for Separation color: {}", (Object)name);
                }
            } else {
                knownTintTransforms.put(name, tintTransform);
            }
        }
    }

    private void enforceSeparationConsistency(PDResources resources, Map<String, COSBase> knownTintTransforms, Set<COSBase> visitedResources) {
        COSDictionary xObjDict;
        if (resources == null) {
            return;
        }
        if (!visitedResources.add((COSBase)resources.getCOSObject())) {
            return;
        }
        COSDictionary csDict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.COLORSPACE);
        if (csDict != null) {
            for (COSName name : csDict.keySet()) {
                COSBase csVal = csDict.getDictionaryObject(name);
                this.enforceSeparationTintTransform(csVal, knownTintTransforms);
            }
        }
        if ((xObjDict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.XOBJECT)) != null) {
            for (COSName name : xObjDict.keySet()) {
                COSBase formRes;
                COSStream stream;
                COSName type;
                COSBase xObj = xObjDict.getDictionaryObject(name);
                if (!(xObj instanceof COSStream) || !COSName.FORM.equals((Object)(type = (COSName)(stream = (COSStream)xObj).getDictionaryObject(COSName.SUBTYPE))) || !((formRes = stream.getDictionaryObject(COSName.RESOURCES)) instanceof COSDictionary)) continue;
                COSDictionary formResDict = (COSDictionary)formRes;
                this.enforceSeparationConsistency(new PDResources(formResDict), knownTintTransforms, visitedResources);
            }
        }
    }

    private void enforceSeparationTintTransform(COSBase cs, Map<String, COSBase> knownTintTransforms) {
        COSBase nameBase;
        COSBase type;
        COSArray arr;
        if (cs instanceof COSArray && (arr = (COSArray)cs).size() >= 4 && COSName.SEPARATION.equals((Object)(type = arr.getObject(0))) && (nameBase = arr.getObject(1)) instanceof COSName) {
            COSBase known;
            COSName colorName = (COSName)nameBase;
            String name = colorName.getName();
            COSBase tintTransform = arr.getObject(3);
            if (knownTintTransforms.containsKey(name) && (known = knownTintTransforms.get(name)) != tintTransform) {
                arr.set(3, known);
                log.debug("Enforced consistent TintTransform for Separation color: {}", (Object)name);
            }
        }
    }

    private void addWhiteBackground(PDDocument doc) throws IOException {
        for (PDPage page : doc.getPages()) {
            PDRectangle mediaBox = page.getMediaBox();
            try (PDPageContentStream cs = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.PREPEND, true, true);){
                cs.setNonStrokingColor(Color.WHITE);
                cs.addRect(mediaBox.getLowerLeftX(), mediaBox.getLowerLeftY(), mediaBox.getWidth(), mediaBox.getHeight());
                cs.fill();
            }
        }
    }

    private void flattenHighlightsToContent(PDDocument doc) throws IOException {
        for (PDPage page : doc.getPages()) {
            ArrayList annotations = new ArrayList(page.getAnnotations());
            ArrayList<PDAnnotation> toRemove = new ArrayList<PDAnnotation>();
            try (PDPageContentStream cs = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.PREPEND, true, true);){
                for (PDAnnotation annot : annotations) {
                    if (!(annot instanceof PDAnnotationHighlight)) continue;
                    PDAnnotationHighlight highlight = (PDAnnotationHighlight)annot;
                    if (!"Highlight".equals(annot.getSubtype())) continue;
                    PDColor color = highlight.getColor();
                    if (color != null) {
                        cs.setNonStrokingColor(color);
                    } else {
                        cs.setNonStrokingColor(Color.YELLOW);
                    }
                    float[] quads = highlight.getQuadPoints();
                    if (!this.isValidQuadPoints(quads)) {
                        log.warn("Invalid quad points array for highlight annotation: {}", quads != null ? "length=" + quads.length : "null");
                        continue;
                    }
                    for (int i = 0; i <= quads.length - 8; i += 8) {
                        float minX = Float.MAX_VALUE;
                        float minY = Float.MAX_VALUE;
                        float maxX = -3.4028235E38f;
                        float maxY = -3.4028235E38f;
                        for (int j = 0; j < 8; j += 2) {
                            float x = quads[i + j];
                            float y = quads[i + j + 1];
                            minX = Math.min(minX, x);
                            maxX = Math.max(maxX, x);
                            minY = Math.min(minY, y);
                            maxY = Math.max(maxY, y);
                        }
                        float width = maxX - minX;
                        float height = maxY - minY;
                        if (!(width > 0.0f) || !(height > 0.0f)) continue;
                        cs.addRect(minX, minY, width, height);
                        cs.fill();
                    }
                    toRemove.add(annot);
                }
            }
            page.getAnnotations().removeAll(toRemove);
        }
    }

    private boolean isValidQuadPoints(float[] quads) {
        return quads != null && quads.length >= 8 && quads.length % 8 == 0;
    }

    private void sanitizeMetadata(PDDocument doc) {
        Set keys;
        PDDocumentInformation info = doc.getDocumentInformation();
        if (info == null) {
            info = new PDDocumentInformation();
            doc.setDocumentInformation(info);
        }
        if ((keys = info.getMetadataKeys()) != null) {
            for (String key : new HashSet(keys)) {
                String value = info.getCustomMetadataValue(key);
                if (value == null) continue;
                String clean = NON_PRINTABLE_ASCII.matcher(value).replaceAll("");
                info.setCustomMetadataValue(key, clean);
            }
        }
        info.setProducer("Stirling-PDF Sanitizer");
    }

    private void removeForbiddenActions(PDDocument doc) {
        doc.getDocumentCatalog().setOpenAction(null);
        doc.getDocumentCatalog().getCOSObject().removeItem(COSName.JAVA_SCRIPT);
    }

    private void ensureAnnotationAppearances(PDDocument doc) throws IOException {
        for (PDPage page : doc.getPages()) {
            List annotations = page.getAnnotations();
            ArrayList<PDAnnotation> toRemove = new ArrayList<PDAnnotation>();
            for (PDAnnotation annot : annotations) {
                PDAppearanceDictionary appearanceDict;
                PDRectangle rect;
                String subtype = annot.getSubtype();
                if ("Popup".equals(subtype) || "Link".equals(subtype) || (rect = annot.getRectangle()) != null && this.isZeroSizeRect(rect) || (appearanceDict = annot.getAppearance()) != null && appearanceDict.getNormalAppearance() != null || this.tryGenerateAppearance(doc, page, annot)) continue;
                log.warn("Removing annotation without appearance: {} on page", (Object)subtype);
                toRemove.add(annot);
            }
            if (toRemove.isEmpty()) continue;
            annotations.removeAll(toRemove);
        }
    }

    private boolean isZeroSizeRect(PDRectangle rect) {
        return Float.compare(rect.getLowerLeftX(), rect.getUpperRightX()) == 0 && Float.compare(rect.getLowerLeftY(), rect.getUpperRightY()) == 0;
    }

    private boolean tryGenerateAppearance(PDDocument doc, PDPage page, PDAnnotation annot) {
        try {
            if (annot instanceof PDAnnotationWidget) {
                annot.constructAppearances();
                return annot.getAppearance() != null;
            }
            if (annot instanceof PDAnnotationHighlight) {
                return false;
            }
            annot.constructAppearances();
            return annot.getAppearance() != null;
        }
        catch (Exception e) {
            log.debug("Could not generate appearance for annotation: {}", (Object)e.getMessage());
            return false;
        }
    }

    public void ensureEmbeddedFileCompliance(PDDocument doc) {
        PDDocumentCatalog catalog = doc.getDocumentCatalog();
        PDDocumentNameDictionary names = catalog.getNames();
        if (names == null) {
            return;
        }
        PDEmbeddedFilesNameTreeNode embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            return;
        }
        try {
            Map fileSpecs = embeddedFiles.getNames();
            if (fileSpecs == null || fileSpecs.isEmpty()) {
                return;
            }
            COSArray afArray = new COSArray();
            if (catalog.getCOSObject().containsKey(COS_AF)) {
                try {
                    afArray = (COSArray)catalog.getCOSObject().getDictionaryObject(COS_AF);
                }
                catch (Exception e) {
                    afArray = new COSArray();
                }
            }
            boolean afArrayModified = false;
            for (Map.Entry entry : fileSpecs.entrySet()) {
                String fileName = (String)entry.getKey();
                PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)entry.getValue();
                COSDictionary fileSpecDict = fileSpec.getCOSObject();
                if (!fileSpecDict.containsKey(COS_AF_RELATIONSHIP)) {
                    fileSpecDict.setName(COS_AF_RELATIONSHIP, "Unspecified");
                    log.debug("Added AFRelationship 'Unspecified' to embedded file: {}", (Object)fileName);
                }
                if (fileSpec.getFile() == null || fileSpec.getFile().isEmpty()) {
                    fileSpec.setFile(fileName);
                }
                if (!fileSpecDict.containsKey(COS_UF)) {
                    fileSpecDict.setString(COS_UF, fileName);
                }
                this.ensureEmbeddedFileMimeType(fileSpec, fileName);
                boolean alreadyInAf = false;
                for (int i = 0; i < afArray.size(); ++i) {
                    if (afArray.getObject(i) != fileSpecDict) continue;
                    alreadyInAf = true;
                    break;
                }
                if (alreadyInAf) continue;
                afArray.add((COSBase)fileSpecDict);
                afArrayModified = true;
            }
            if (afArrayModified) {
                catalog.getCOSObject().setItem(COS_AF, (COSBase)afArray);
                log.debug("Updated Document Catalog 'AF' array with {} associated files", (Object)afArray.size());
            }
        }
        catch (IOException e) {
            log.warn("Could not process embedded files for PDF/A-3 compliance: {}", (Object)e.getMessage());
        }
    }

    private void ensureEmbeddedFileMimeType(PDComplexFileSpecification fileSpec, String fileName) {
        String currentSubtype;
        PDEmbeddedFile embeddedFile = fileSpec.getEmbeddedFileUnicode();
        if (embeddedFile == null) {
            embeddedFile = fileSpec.getEmbeddedFile();
        }
        if (embeddedFile != null && ((currentSubtype = embeddedFile.getSubtype()) == null || currentSubtype.isEmpty())) {
            String mimeType = this.detectMimeTypeFromFilename(fileName);
            embeddedFile.setSubtype(mimeType);
            log.debug("Set MIME type '{}' for embedded file: {}", (Object)mimeType, (Object)fileName);
        }
    }

    private String detectMimeTypeFromFilename(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return "application/octet-stream";
        }
        String lowerName = fileName.toLowerCase(Locale.ROOT);
        return MIME_TYPE_MAP.entrySet().stream().filter(entry -> lowerName.endsWith((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse("application/octet-stream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public byte[] convertPDDocumentToPDFA(PDDocument document, String outputFormat) throws IOException {
        profile = PdfaProfile.fromRequest((String)outputFormat);
        workingDir = Files.createTempDirectory("pdfa_conversion_", new FileAttribute[0]);
        inputPath = workingDir.resolve("input.pdf");
        try {
            block8: {
                document.save(inputPath.toFile());
                if (!this.isGhostscriptAvailable()) break block8;
                ConvertPDFToPDFA.log.info("Using Ghostscript for PDF/A conversion to {}", (Object)profile.getDisplayName());
                try {
                    converted = this.convertWithGhostscript(inputPath, workingDir, profile);
                    ConvertPDFToPDFA.validateAndWarnPdfA((byte[])converted, (PdfaProfile)profile, (String)"Ghostscript");
                    var7_9 = converted;
                    return var7_9;
                }
                catch (IOException | InterruptedException e) {
                    ConvertPDFToPDFA.log.warn("Ghostscript conversion failed, falling back to PDFBox/LibreOffice method", (Throwable)e);
                    ** break block9
                }
            }
            ConvertPDFToPDFA.log.info("Ghostscript not available, using PDFBox/LibreOffice fallback method");
lbl-1000:
            // 2 sources

            {
                try {
                    converted = this.convertWithPdfBoxMethod(inputPath, profile);
                }
                catch (Exception e) {
                    throw new IOException("PDF/A conversion failed", e);
                }
                ConvertPDFToPDFA.validateAndWarnPdfA((byte[])converted, (PdfaProfile)profile, (String)"PDFBox/LibreOffice");
                var7_11 = converted;
            }
            return var7_11;
        }
        finally {
            ConvertPDFToPDFA.deleteQuietly((Path)workingDir);
        }
    }

    private void copyResourceIcc(Path target) throws IOException {
        try (InputStream in = this.getClass().getResourceAsStream("/icc/sRGB2014.icc");){
            if (in == null) {
                throw ExceptionUtils.createIllegalArgumentException((String)"error.resourceNotFound", (String)"Resource not found: {0}", (Object[])new Object[]{"/icc/sRGB2014.icc"});
            }
            Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void addICCProfileIfNotPresent(PDDocument document) {
        if (document.getDocumentCatalog().getOutputIntents().isEmpty()) {
            try (InputStream colorProfile = this.getClass().getResourceAsStream("/icc/sRGB2014.icc");){
                if (colorProfile == null) {
                    throw ExceptionUtils.createIllegalArgumentException((String)"error.resourceNotFound", (String)"Resource not found: {0}", (Object[])new Object[]{"/icc/sRGB2014.icc"});
                }
                PDOutputIntent outputIntent = new PDOutputIntent(document, colorProfile);
                outputIntent.setInfo("sRGB IEC61966-2.1");
                outputIntent.setOutputCondition("sRGB IEC61966-2.1");
                outputIntent.setOutputConditionIdentifier("sRGB IEC61966-2.1");
                outputIntent.setRegistryName("http://www.color.org");
                document.getDocumentCatalog().addOutputIntent(outputIntent);
                log.debug("Added ICC color profile for PDF/A compliance");
            }
            catch (Exception e) {
                log.error("Failed to load ICC profile: {}", (Object)e.getMessage());
                throw new RuntimeException("ICC profile loading failed for PDF/A compliance", e);
            }
        }
    }

    @Generated
    public ConvertPDFToPDFA(RuntimePathConfig runtimePathConfig) {
        this.runtimePathConfig = runtimePathConfig;
    }
}

