/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.model.api.converters.EmlToPdfRequest;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.CustomHtmlSanitizer;
import stirling.software.common.util.EmlToPdf;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@ConvertApi
public class ConvertEmlToPDF {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertEmlToPDF.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final RuntimePathConfig runtimePathConfig;
    private final TempFileManager tempFileManager;
    private final CustomHtmlSanitizer customHtmlSanitizer;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/eml/pdf"})
    @StandardPdfResponse
    @Operation(summary="Convert EML to PDF", description="This endpoint converts EML (email) files to PDF format with extensive customization options. Features include font settings, image constraints, display modes, attachment handling, and HTML debug output. Input: EML file, Output: PDF or HTML file. Type: SISO")
    public ResponseEntity<byte[]> convertEmlToPdf(@ModelAttribute EmlToPdfRequest request) {
        MultipartFile inputFile = request.getFileInput();
        String originalFilename = inputFile.getOriginalFilename();
        if (inputFile.isEmpty()) {
            log.error("No file provided for EML to PDF conversion.");
            return ResponseEntity.badRequest().body((Object)"No file provided".getBytes(StandardCharsets.UTF_8));
        }
        if (originalFilename == null || originalFilename.trim().isEmpty()) {
            log.error("Filename is null or empty.");
            return ResponseEntity.badRequest().body((Object)"Please provide a valid filename".getBytes(StandardCharsets.UTF_8));
        }
        String lowerFilename = originalFilename.toLowerCase(Locale.ROOT);
        if (!lowerFilename.endsWith(".eml")) {
            log.error("Invalid file type for EML to PDF: {}", (Object)originalFilename);
            return ResponseEntity.badRequest().body((Object)"Please upload a valid EML file".getBytes(StandardCharsets.UTF_8));
        }
        String baseFilename = Filenames.toSimpleFileName((String)originalFilename);
        try {
            byte[] fileBytes = inputFile.getBytes();
            if (request.isDownloadHtml()) {
                try {
                    String htmlContent = EmlToPdf.convertEmlToHtml((byte[])fileBytes, (EmlToPdfRequest)request);
                    log.info("Successfully converted EML to HTML: {}", (Object)originalFilename);
                    return WebResponseUtils.bytesToWebResponse((byte[])htmlContent.getBytes(StandardCharsets.UTF_8), (String)(baseFilename + ".html"), (MediaType)MediaType.TEXT_HTML);
                }
                catch (IOException | IllegalArgumentException e) {
                    log.error("HTML conversion failed for {}", (Object)originalFilename, (Object)e);
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("HTML conversion failed: " + e.getMessage()).getBytes(StandardCharsets.UTF_8));
                }
            }
            try {
                byte[] pdfBytes = EmlToPdf.convertEmlToPdf((String)this.runtimePathConfig.getWeasyPrintPath(), (EmlToPdfRequest)request, (byte[])fileBytes, (String)originalFilename, (CustomPDFDocumentFactory)this.pdfDocumentFactory, (TempFileManager)this.tempFileManager, (CustomHtmlSanitizer)this.customHtmlSanitizer);
                if (pdfBytes == null || pdfBytes.length == 0) {
                    log.error("PDF conversion failed - empty output for {}", (Object)originalFilename);
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"PDF conversion failed - empty output".getBytes(StandardCharsets.UTF_8));
                }
                log.info("Successfully converted EML to PDF: {}", (Object)originalFilename);
                return WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)(baseFilename + ".pdf"), (MediaType)MediaType.APPLICATION_PDF);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("EML to PDF conversion was interrupted for {}", (Object)originalFilename, (Object)e);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Conversion was interrupted".getBytes(StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException e) {
                String errorMessage = ConvertEmlToPDF.buildErrorMessage((Exception)e, (String)originalFilename);
                log.error("EML to PDF conversion failed for {}: {}", new Object[]{originalFilename, errorMessage, e});
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorMessage.getBytes(StandardCharsets.UTF_8));
            }
            catch (RuntimeException e) {
                String errorMessage = ConvertEmlToPDF.buildErrorMessage((Exception)e, (String)originalFilename);
                log.error("EML to PDF conversion failed for {}: {}", new Object[]{originalFilename, errorMessage, e});
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorMessage.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            log.error("File processing error for EML to PDF: {}", (Object)originalFilename, (Object)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"File processing error".getBytes(StandardCharsets.UTF_8));
        }
    }

    @NotNull
    private static String buildErrorMessage(Exception e, String originalFilename) {
        String errorMessage = e.getMessage() != null && e.getMessage().contains("Invalid EML") ? "Invalid EML file format. Please ensure you've uploaded a valid email file (" + originalFilename + ")." : (e.getMessage() != null && e.getMessage().contains("WeasyPrint") ? "PDF generation failed for " + originalFilename + ". This may be due to complex email formatting." : "Conversion failed for " + originalFilename + ": " + e.getMessage());
        return errorMessage;
    }

    @Generated
    public ConvertEmlToPDF(CustomPDFDocumentFactory pdfDocumentFactory, RuntimePathConfig runtimePathConfig, TempFileManager tempFileManager, CustomHtmlSanitizer customHtmlSanitizer) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.runtimePathConfig = runtimePathConfig;
        this.tempFileManager = tempFileManager;
        this.customHtmlSanitizer = customHtmlSanitizer;
    }
}

