"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Destructible = void 0;
class Destructible {
    constructor() {
        this.destructed = false;
    }
    destruct() {
        if (this.destructed) {
            return;
        }
        this.destructed = true;
    }
    assertNotDestructed() {
        if (this.destructed) {
            throw new Error('Object has been destructed');
        }
    }
}
exports.Destructible = Destructible;
