/**************************************************
 *
 * ARM-specific configuration for stdlib.h in DLib.
 *
 * Copyright 2017 IAR Systems AB.
 *
 **************************************************/

#ifndef _DLIB_PRODUCTS_STDLIB_H_
#define _DLIB_PRODUCTS_STDLIB_H_

#ifndef _SYSTEM_BUILD
  #pragma system_include
#endif

#ifndef _NO_DEFINITIONS_IN_HEADER_FILES

#ifdef __cplusplus
extern "C" {
#endif  

#if !__ARM_FEATURE_IDIV  
  #pragma type_attribute=__value_in_regs
  div_t __aeabi_idivmod(int n, int d);
#endif

#pragma inline=forced_no_body
__ATTRIBUTES
div_t div(int a, int b)
{
#if __ARM_FEATURE_IDIV  
  int q = a / b;
  int r = a - (q*b);
  div_t d;
  d.quot = q;
  d.rem = r;
  return d;
#else
  return __aeabi_idivmod(a, b);
#endif    
}

#pragma inline=forced_no_body
__ATTRIBUTES
ldiv_t ldiv(long a, long b)
{
#if __LONG_SIZE__ == 8
  long q = a / b;
  long r = a - (q*b);
  ldiv_t ld;
  ld.quot = q;
  ld.rem = r;
#elif __ARM_FEATURE_IDIV  
  int q = a / b;
  int r = a - (q*b);
  ldiv_t ld;
  ld.quot = q;
  ld.rem = r;
#else
  div_t d = __aeabi_idivmod(a, b);
  ldiv_t ld;
  ld.quot = d.quot;
  ld.rem  = d.rem;
#endif  
  return ld;
}

#if !_DLIB_ONLY_C89
  #if __aarch64__
    #pragma inline=forced_no_body
    __ATTRIBUTES
    lldiv_t lldiv(long long a, long long b)
    {
      long long q = a / b;
      long long r = a - (q*b);
      lldiv_t lld;
      lld.quot = q;
      lld.rem = r;
      return lld;
    }
  #else
    #pragma type_attribute=__value_in_regs
    lldiv_t __aeabi_ldivmod(long long n, long long d);

    #pragma inline=forced_no_body
    __ATTRIBUTES
    lldiv_t lldiv(long long a, long long b)
    {
      return __aeabi_ldivmod(a, b);
    }
  #endif
#endif  

#ifdef __cplusplus
};
#endif  

#endif /* _NO_DEFINITIONS_IN_HEADER_FILES */

#endif /* _DLIB_PRODUCTS_STDLIB_H_ */
