/* Functions used from libcpp, taking a locale argument. */
/* Copyright 2009-2017 IAR Systems AB. */
#ifndef _LLOCALE_H
#define _LLOCALE_H

#include <stdlib.h>
#if _DLIB_WIDE_CHARACTERS
#include <wchar.h>
#endif

#ifndef _SYSTEM_BUILD
  #pragma system_include
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

  typedef struct _Locale_Profile_t const * locale_t;

  typedef struct lconv lconv;

  extern int isdigit_l(int, locale_t);
  extern int islower_l(int, locale_t);
  extern int isupper_l(int, locale_t);
  extern int isxdigit_l(int, locale_t);

  extern int toupper_l(int, locale_t);
  extern int tolower_l(int, locale_t);

  extern int strcoll_l(const char *__s1, const char *__s2, locale_t __loc);

  extern size_t strxfrm_l(char *__s1, const char *__s2, size_t __n,
                          locale_t __loc);

  extern size_t strftime_l(char *__s, size_t __size, const char *__fmt,
                           const struct tm *__tm, locale_t __loc);

  extern long long strtoll_l(const char *__nptr, char **__endptr, int __base,
                             locale_t __loc);
  extern long strtol_l(const char *__nptr, char **__endptr, int __base,
                       locale_t __loc);
  extern unsigned long long strtoull_l(const char *__nptr, char **__endptr,
                                       int __base, locale_t __loc);
  extern unsigned long strtoul_l(const char *__nptr, char **__endptr,
                                 int __base, locale_t __loc);
  extern float strtof_l(const char *, char **, locale_t);
  extern double strtod_l(const char *, char **, locale_t);
  extern long double strtold_l(const char *__nptr, char **__endptr,
                               locale_t __loc);

  int __iar_mb_cur_max_l(locale_t __l);
  lconv const * __iar_localeconv_for_numeric (locale_t __l);
  lconv const * __iar_localeconv_for_monetary(locale_t __l);

  _Pragma("__printf_args")
  _Pragma("library_default_requirements _Printf = unknown")
  int snprintf_l(char *__s, size_t __n, locale_t __l, const char *__format, ...);
  _Pragma("__printf_args")
  _Pragma("library_default_requirements _Printf = unknown")
  int asprintf_l(char **__s, locale_t __l, const char *__format, ...);
  _Pragma("__scanf_args")
  _Pragma("library_default_requirements _Scanf = unknown")
  int sscanf_l(const char *__s, locale_t __l, const char *__format, ...);

#if _DLIB_WIDE_CHARACTERS
  extern int iswalpha_l(wchar_t, locale_t);
  extern int iswblank_l(wchar_t, locale_t);
  extern int iswcntrl_l(wchar_t, locale_t);
  extern int iswdigit_l(wchar_t, locale_t);
  extern int iswlower_l(wchar_t, locale_t);
  extern int iswprint_l(wchar_t, locale_t);
  extern int iswpunct_l(wchar_t, locale_t);
  extern int iswspace_l(wchar_t, locale_t);
  extern int iswupper_l(wchar_t, locale_t);
  extern int iswxdigit_l(wchar_t, locale_t);

  extern wint_t towupper_l(wint_t, locale_t);
  extern wint_t towlower_l(wint_t, locale_t);

  extern int wcscoll_l(const wchar_t *__s1, const wchar_t *__s2,
                       locale_t __loc);

  extern size_t wcsxfrm_l(wchar_t *__ws1, const wchar_t *__ws2, size_t __n,
                          locale_t __loc);

  wint_t btowc_l(int __c, locale_t __l);
  int wctob_l(wint_t __c, locale_t __l);
  size_t wcsnrtombs_l(char *__dest, const wchar_t **__src, size_t __nwc,
                      size_t __len, mbstate_t *__ps, locale_t __l);
  size_t wcrtomb_l(char *__s, wchar_t __wc, mbstate_t *__ps, locale_t __l);
  size_t mbsnrtowcs_l(wchar_t * __dest, const char **__src, size_t __nms,
                      size_t __len, mbstate_t *__ps, locale_t __l);
  size_t mbrtowc_l(wchar_t *__pwc, const char *__s, size_t __n,
                   mbstate_t *__ps, locale_t __l);
  int mbtowc_l(wchar_t *__pwc, const char *__pmb, size_t __max, locale_t __l);
  size_t mbrlen_l(const char *__s, size_t __n, mbstate_t *__ps, locale_t __l);

  size_t mbsrtowcs_l(wchar_t *__dest, const char **__src, size_t __len,
                     mbstate_t *__ps, locale_t __l);
#endif // _DLIB_WIDE_CHARACTERS

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* _LLOCALE_H */
