# Complete Plugin Reference

Browse all **67 focused, single-purpose plugins** organized by category.

## Quick Start - Essential Plugins

> 💡 **Getting Started?** Install these popular plugins for immediate productivity gains.

### Development Essentials

**code-documentation** - Documentation and technical writing

```bash
/plugin install code-documentation
```

Automated doc generation, code explanation, and tutorial creation for comprehensive technical documentation.

**debugging-toolkit** - Smart debugging and developer experience

```bash
/plugin install debugging-toolkit
```

Interactive debugging, error analysis, and DX optimization for faster problem resolution.

**git-pr-workflows** - Git automation and PR enhancement

```bash
/plugin install git-pr-workflows
```

Git workflow automation, pull request enhancement, and team onboarding processes.

### Full-Stack Development

**backend-development** - Backend API design and architecture

```bash
/plugin install backend-development
```

RESTful and GraphQL API design with test-driven development and modern backend architecture patterns.

**frontend-mobile-development** - UI and mobile development

```bash
/plugin install frontend-mobile-development
```

React/React Native component development with automated scaffolding and cross-platform implementation.

**full-stack-orchestration** - End-to-end feature development

```bash
/plugin install full-stack-orchestration
```

Multi-agent coordination from backend → frontend → testing → security → deployment.

### Testing & Quality

**unit-testing** - Automated test generation

```bash
/plugin install unit-testing
```

Generate pytest (Python) and Jest (JavaScript) unit tests automatically with comprehensive edge case coverage.

**code-review-ai** - AI-powered code review

```bash
/plugin install code-review-ai
```

Architectural analysis, security assessment, and code quality review with actionable feedback.

### Infrastructure & Operations

**cloud-infrastructure** - Cloud architecture design

```bash
/plugin install cloud-infrastructure
```

AWS/Azure/GCP architecture, Kubernetes setup, Terraform IaC, and multi-cloud cost optimization.

**incident-response** - Production incident management

```bash
/plugin install incident-response
```

Rapid incident triage, root cause analysis, and automated resolution workflows for production systems.

### Language Support

**python-development** - Python project scaffolding

```bash
/plugin install python-development
```

FastAPI/Django project initialization with modern tooling (uv, ruff) and production-ready architecture.

**javascript-typescript** - JavaScript/TypeScript scaffolding

```bash
/plugin install javascript-typescript
```

Next.js, React + Vite, and Node.js project setup with pnpm and TypeScript best practices.

---

## Complete Plugin Catalog

### 🎨 Development (4 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **debugging-toolkit** | Interactive debugging and DX optimization | `/plugin install debugging-toolkit` |
| **backend-development** | Backend API design with GraphQL and TDD | `/plugin install backend-development` |
| **frontend-mobile-development** | Frontend UI and mobile development | `/plugin install frontend-mobile-development` |
| **multi-platform-apps** | Cross-platform app coordination (web/iOS/Android) | `/plugin install multi-platform-apps` |

### 📚 Documentation (3 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **code-documentation** | Documentation generation and code explanation | `/plugin install code-documentation` |
| **documentation-generation** | OpenAPI specs, Mermaid diagrams, tutorials | `/plugin install documentation-generation` |
| **c4-architecture** | Comprehensive C4 architecture documentation workflow with bottom-up code analysis, component synthesis, container mapping, and context diagrams | `/plugin install c4-architecture` |

### 🔄 Workflows (3 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **git-pr-workflows** | Git automation and PR enhancement | `/plugin install git-pr-workflows` |
| **full-stack-orchestration** | End-to-end feature orchestration | `/plugin install full-stack-orchestration` |
| **tdd-workflows** | Test-driven development methodology | `/plugin install tdd-workflows` |

### ✅ Testing (2 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **unit-testing** | Automated unit test generation (Python/JavaScript) | `/plugin install unit-testing` |
| **tdd-workflows** | Test-driven development methodology | `/plugin install tdd-workflows` |

### 🔍 Quality (3 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **code-review-ai** | AI-powered architectural review | `/plugin install code-review-ai` |
| **comprehensive-review** | Multi-perspective code analysis | `/plugin install comprehensive-review` |
| **performance-testing-review** | Performance analysis and test coverage review | `/plugin install performance-testing-review` |

### 🛠️ Utilities (4 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **code-refactoring** | Code cleanup and technical debt management | `/plugin install code-refactoring` |
| **dependency-management** | Dependency auditing and version management | `/plugin install dependency-management` |
| **error-debugging** | Error analysis and trace debugging | `/plugin install error-debugging` |
| **team-collaboration** | Team workflows and standup automation | `/plugin install team-collaboration` |

### 🤖 AI & ML (4 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **llm-application-dev** | LLM apps and prompt engineering | `/plugin install llm-application-dev` |
| **agent-orchestration** | Multi-agent system optimization | `/plugin install agent-orchestration` |
| **context-management** | Context persistence and restoration | `/plugin install context-management` |
| **machine-learning-ops** | ML training pipelines and MLOps | `/plugin install machine-learning-ops` |

### 📊 Data (2 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **data-engineering** | ETL pipelines and data warehouses | `/plugin install data-engineering` |
| **data-validation-suite** | Schema validation and data quality | `/plugin install data-validation-suite` |

### 🗄️ Database (2 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **database-design** | Database architecture and schema design | `/plugin install database-design` |
| **database-migrations** | Database migration automation | `/plugin install database-migrations` |

### 🚨 Operations (4 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **incident-response** | Production incident management | `/plugin install incident-response` |
| **error-diagnostics** | Error tracing and root cause analysis | `/plugin install error-diagnostics` |
| **distributed-debugging** | Distributed system tracing | `/plugin install distributed-debugging` |
| **observability-monitoring** | Metrics, logging, tracing, and SLO | `/plugin install observability-monitoring` |

### ⚡ Performance (2 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **application-performance** | Application profiling and optimization | `/plugin install application-performance` |
| **database-cloud-optimization** | Database query and cloud cost optimization | `/plugin install database-cloud-optimization` |

### ☁️ Infrastructure (5 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **deployment-strategies** | Deployment patterns and rollback automation | `/plugin install deployment-strategies` |
| **deployment-validation** | Pre-deployment checks and validation | `/plugin install deployment-validation` |
| **kubernetes-operations** | K8s manifests and GitOps workflows | `/plugin install kubernetes-operations` |
| **cloud-infrastructure** | AWS/Azure/GCP cloud architecture | `/plugin install cloud-infrastructure` |
| **cicd-automation** | CI/CD pipeline configuration | `/plugin install cicd-automation` |

### 🔒 Security (4 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **security-scanning** | SAST analysis and vulnerability scanning | `/plugin install security-scanning` |
| **security-compliance** | SOC2/HIPAA/GDPR compliance | `/plugin install security-compliance` |
| **backend-api-security** | API security and authentication | `/plugin install backend-api-security` |
| **frontend-mobile-security** | XSS/CSRF prevention and mobile security | `/plugin install frontend-mobile-security` |

### 🔄 Modernization (2 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **framework-migration** | Framework upgrades and migration planning | `/plugin install framework-migration` |
| **codebase-cleanup** | Technical debt reduction and cleanup | `/plugin install codebase-cleanup` |

### 🌐 API (2 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **api-scaffolding** | REST/GraphQL API generation | `/plugin install api-scaffolding` |
| **api-testing-observability** | API testing and monitoring | `/plugin install api-testing-observability` |

### 📢 Marketing (4 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **seo-content-creation** | SEO content writing and planning | `/plugin install seo-content-creation` |
| **seo-technical-optimization** | Meta tags, keywords, and schema markup | `/plugin install seo-technical-optimization` |
| **seo-analysis-monitoring** | Content analysis and authority building | `/plugin install seo-analysis-monitoring` |
| **content-marketing** | Content strategy and web research | `/plugin install content-marketing` |

### 💼 Business (3 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **business-analytics** | KPI tracking and financial reporting | `/plugin install business-analytics` |
| **hr-legal-compliance** | HR policies and legal templates | `/plugin install hr-legal-compliance` |
| **customer-sales-automation** | Support and sales automation | `/plugin install customer-sales-automation` |

### 💻 Languages (7 plugins)

| Plugin | Description | Install |
|--------|-------------|---------|
| **python-development** | Python 3.12+ with Django/FastAPI | `/plugin install python-development` |
| **javascript-typescript** | JavaScript/TypeScript with Node.js | `/plugin install javascript-typescript` |
| **systems-programming** | Rust, Go, C, C++ for systems development | `/plugin install systems-programming` |
| **jvm-languages** | Java, Scala, C# with enterprise patterns | `/plugin install jvm-languages` |
| **web-scripting** | PHP and Ruby for web applications | `/plugin install web-scripting` |
| **functional-programming** | Elixir with OTP and Phoenix | `/plugin install functional-programming` |
| **arm-cortex-microcontrollers** | ARM Cortex-M firmware and drivers | `/plugin install arm-cortex-microcontrollers` |

### 🔗 Blockchain (1 plugin)

| Plugin | Description | Install |
|--------|-------------|---------|
| **blockchain-web3** | Smart contracts and DeFi protocols | `/plugin install blockchain-web3` |

### 💰 Finance (1 plugin)

| Plugin | Description | Install |
|--------|-------------|---------|
| **quantitative-trading** | Algorithmic trading and risk management | `/plugin install quantitative-trading` |

### 💳 Payments (1 plugin)

| Plugin | Description | Install |
|--------|-------------|---------|
| **payment-processing** | Stripe/PayPal integration and billing | `/plugin install payment-processing` |

### 🎮 Gaming (1 plugin)

| Plugin | Description | Install |
|--------|-------------|---------|
| **game-development** | Unity and Minecraft plugin development | `/plugin install game-development` |

### ♿ Accessibility (1 plugin)

| Plugin | Description | Install |
|--------|-------------|---------|
| **accessibility-compliance** | WCAG auditing and inclusive design | `/plugin install accessibility-compliance` |

## Plugin Structure

Each plugin contains:

- **agents/** - Specialized agents for that domain
- **commands/** - Tools and workflows specific to that plugin
- **skills/** - Optional modular knowledge packages (progressive disclosure)

Example:
```
plugins/python-development/
├── agents/
│   ├── python-pro.md
│   ├── django-pro.md
│   └── fastapi-pro.md
├── commands/
│   └── python-scaffold.md
└── skills/
    ├── async-python-patterns/
    ├── python-testing-patterns/
    ├── python-packaging/
    ├── python-performance-optimization/
    └── uv-package-manager/
```

## Installation

### Step 1: Add the Marketplace

```bash
/plugin marketplace add wshobson/agents
```

This makes all 67 plugins available for installation, but **does not load any agents or tools** into your context.

### Step 2: Install Specific Plugins

Browse available plugins:

```bash
/plugin
```

Install only the plugins you need:

```bash
/plugin install python-development
/plugin install backend-development
```

Each installed plugin loads **only its specific agents and commands** into Claude's context.

## Plugin Design Principles

### Single Responsibility
- Each plugin does **one thing well** (Unix philosophy)
- Clear, focused purposes (describable in 5-10 words)
- Average plugin size: **3.4 components** (follows Anthropic's 2-8 pattern)

### Minimal Token Usage
- Install only what you need
- Each plugin loads only its specific agents and tools
- No unnecessary resources loaded into context
- Better context efficiency with granular plugins

### Composability
- Mix and match plugins for complex workflows
- Workflow orchestrators compose focused plugins
- Clear boundaries between plugins
- No forced feature bundling

## See Also

- [Agent Skills](./agent-skills.md) - 107 specialized skills across plugins
- [Agent Reference](./agents.md) - Complete agent catalog
- [Usage Guide](./usage.md) - Commands and workflows
- [Architecture](./architecture.md) - Design principles
