# Code of Conduct

## Our Pledge

We as members, contributors, and leaders pledge to make participation in our community a harassment-free experience for everyone, regardless of age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, caste, color, religion, or sexual identity and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming, diverse, inclusive, and healthy community.

## Our Standards

### Acceptable Behavior

- Using welcoming and inclusive language
- Being respectful of differing viewpoints and experiences
- Gracefully accepting constructive criticism
- Focusing on what is best for the community
- Showing empathy towards other community members
- Contributing constructively to discussions about AI agents and development

### Unacceptable Behavior

The following behaviors are considered harassment and are unacceptable:

- **Hate speech**: The use of abusive or threatening speech that expresses prejudice against a particular group, especially on the basis of race, religion, gender, sexual orientation, or other characteristics
- **Discriminatory language**: Slurs, offensive comments, or language targeting protected characteristics
- **Personal attacks**: Insulting, demeaning, or hostile comments directed at individuals
- **Harassment**: Deliberate intimidation, stalking, following, or threatening
- **Doxxing**: Publishing private information without consent
- **Spam**: Excessive off-topic content, promotional material, or repetitive posts
- **Automated abuse**: Using scripts, bots, or AI tools to bulk-create issues, PRs, or comments
- **LLM-generated spam**: Submitting AI-generated content en masse without meaningful human curation or relevance
- **Trolling**: Deliberately inflammatory or disruptive behavior
- **Sexual harassment**: Unwelcome sexual attention or advances

## Enforcement

### Reporting

If you experience or witness unacceptable behavior, please report it by:
- Creating an issue with the `moderation` label
- Contacting the repository maintainers directly
- Using GitHub's built-in reporting mechanisms

### Consequences

Community leaders will follow these guidelines in determining consequences:

1. **Warning**: First offense or minor violation
2. **Temporary restriction**: Temporary loss of interaction privileges
3. **Permanent ban**: Severe or repeated violations

### Enforcement Actions

- **Immediate removal**: Hate speech, threats, or doxxing will result in immediate content removal and user blocking
- **Automated spam**: Bulk automated submissions will result in immediate content removal and permanent account blocking without warning
- **Issue/PR closure**: Inappropriate content will be closed and locked
- **Account blocking**: Repeat offenders will be blocked from the repository

## Scope

This Code of Conduct applies within all community spaces, including:
- Issues and pull requests
- Discussions and comments
- Wiki and documentation
- External representations of the project

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org/), version 2.1.

## Contact

Questions about the Code of Conduct can be directed to the repository maintainers through GitHub issues or discussions.