/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class ZLib {
    private static final ThreadLocal<Inflater> INFLATER = ThreadLocal.withInitial(Inflater::new);
    private static final ThreadLocal<Inflater> INFLATER_RAW = ThreadLocal.withInitial(() -> new Inflater(true));
    private static final ThreadLocal<Deflater> DEFLATER = ThreadLocal.withInitial(Deflater::new);
    private static final ThreadLocal<Deflater> DEFLATER_RAW = ThreadLocal.withInitial(() -> new Deflater(-1, true));

    private ZLib() {
    }

    public static ByteBuffer uncompress(ByteBuffer compressed, boolean raw) throws IOException {
        Inflater inflater = (raw ? INFLATER_RAW : INFLATER).get();
        try {
            ByteBuffer buffer = ByteBuffer.allocate(Math.max(1024, compressed.remaining() * 2));
            inflater.setInput(compressed);
            while (!inflater.finished()) {
                if (inflater.inflate(buffer) != 0) continue;
                ByteBuffer newBuffer = ByteBuffer.allocate(buffer.capacity() + Math.max(1024, compressed.remaining() * 2));
                int position = buffer.position();
                buffer.flip();
                newBuffer.put(buffer);
                newBuffer.position(position);
                buffer = newBuffer;
            }
            buffer.flip();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        finally {
            inflater.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset, boolean raw) throws IOException {
        Deflater deflater = (raw ? DEFLATER_RAW : DEFLATER).get();
        try {
            deflater.setInput(input, inputOffset, length);
            deflater.finish();
            int n = deflater.deflate(output, outputOffset, output.length - outputOffset);
            return n;
        }
        finally {
            deflater.reset();
        }
    }
}

