/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.iq80.leveldb.util.SliceOutput;

public class IntVector {
    private int size;
    private int[] values;

    public IntVector(int initialCapacity) {
        this.values = new int[initialCapacity];
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void add(int value) {
        Preconditions.checkArgument(this.size + 1 >= 0, "Invalid minLength: %s", this.size + 1);
        this.ensureCapacity(this.size + 1);
        this.values[this.size++] = value;
    }

    private void ensureCapacity(int minCapacity) {
        if (this.values.length >= minCapacity) {
            return;
        }
        int newLength = this.values.length;
        newLength = newLength == 0 ? 1 : (newLength <<= 1);
        this.values = Arrays.copyOf(this.values, newLength);
    }

    public void write(SliceOutput sliceOutput) {
        for (int index = 0; index < this.size; ++index) {
            sliceOutput.writeInt(this.values[index]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IntVector");
        sb.append("{size=").append(this.size);
        sb.append(", values=").append(Arrays.toString(this.values));
        sb.append('}');
        return sb.toString();
    }
}

