/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.iterator;

import java.io.Closeable;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.iterator.InternalIterator;
import org.iq80.leveldb.iterator.SeekingIterator;
import org.iq80.leveldb.iterator.SliceIterator;
import org.iq80.leveldb.iterator.SortedCollectionIterator;
import org.iq80.leveldb.iterator.TwoLevelIterator;
import org.iq80.leveldb.util.Slice;

public final class SeekingIterators {
    private SeekingIterators() {
    }

    public static <T, K, V> SeekingIterator<K, V> fromSortedList(List<T> list, Function<T, K> keyExtractor, Function<T, V> valueExtractor, Comparator<K> comparator) {
        return new SortedCollectionIterator<T, K, V>(list, keyExtractor, valueExtractor, comparator);
    }

    public static SliceIterator twoLevelSliceIterator(SliceIterator indexIterator, Function<Slice, SeekingIterator<Slice, Slice>> blockFunction, Closeable closeableResources) {
        return new SliceTwoLevelIterator(indexIterator, blockFunction, closeableResources);
    }

    public static <T> InternalIterator twoLevelInternalIterator(SeekingIterator<InternalKey, T> indexIterator, Function<T, SeekingIterator<InternalKey, Slice>> blockFunction, Closeable closeableResources) {
        return new InternalTwoLevelIterator<T>(indexIterator, blockFunction, closeableResources);
    }

    private static class SliceTwoLevelIterator
    extends TwoLevelIterator<Slice, Slice, Slice>
    implements SliceIterator {
        SliceTwoLevelIterator(SliceIterator indexIterator, Function<Slice, SeekingIterator<Slice, Slice>> blockFunction, Closeable closeableResources) {
            super(indexIterator, blockFunction, closeableResources);
        }
    }

    private static class InternalTwoLevelIterator<T>
    extends TwoLevelIterator<T, InternalKey, Slice>
    implements InternalIterator {
        InternalTwoLevelIterator(SeekingIterator<InternalKey, T> indexIterator, Function<T, SeekingIterator<InternalKey, Slice>> blockFunction, Closeable closeableResources) {
            super(indexIterator, blockFunction, closeableResources);
        }
    }
}

