/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.iterator;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.iterator.Direction;
import org.iq80.leveldb.iterator.SnapshotSeekingIterator;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.Slices;

public class DBIteratorAdapter
implements DBIterator {
    private static final String ILLEGAL_STATE = "Illegal use of iterator after release";
    private final SnapshotSeekingIterator seekingIterator;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private Direction direction = Direction.FORWARD;
    private DbEntry elem;

    public DBIteratorAdapter(SnapshotSeekingIterator seekingIterator) {
        this.seekingIterator = seekingIterator;
    }

    @Override
    public void seekToFirst() {
        if (this.direction == Direction.RELEASED) {
            throw new DBException(ILLEGAL_STATE);
        }
        this.direction = Direction.FORWARD;
        this.elem = this.seekingIterator.seekToFirst() ? new DbEntry((Slice)this.seekingIterator.key(), (Slice)this.seekingIterator.value()) : null;
    }

    @Override
    public void seek(byte[] targetKey) {
        if (this.direction == Direction.RELEASED) {
            throw new DBException(ILLEGAL_STATE);
        }
        this.direction = Direction.FORWARD;
        this.elem = this.seekingIterator.seek(Slices.wrappedBuffer(targetKey)) ? new DbEntry((Slice)this.seekingIterator.key(), (Slice)this.seekingIterator.value()) : null;
    }

    @Override
    public boolean hasNext() {
        if (this.direction == Direction.RELEASED) {
            throw new DBException(ILLEGAL_STATE);
        }
        if (this.direction != Direction.FORWARD) {
            this.elem = null;
            this.direction = Direction.FORWARD;
        }
        if (this.elem == null) {
            this.elem = this.seekingIterator.next() ? new DbEntry((Slice)this.seekingIterator.key(), (Slice)this.seekingIterator.value()) : null;
        }
        return this.elem != null;
    }

    @Override
    public DbEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DbEntry elem = this.elem;
        this.elem = null;
        return elem;
    }

    public DbEntry peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.elem;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.direction = Direction.RELEASED;
            this.seekingIterator.close();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekToLast() {
        if (this.direction == Direction.RELEASED) {
            throw new DBException(ILLEGAL_STATE);
        }
        this.direction = Direction.REVERSE;
        this.elem = this.seekingIterator.seekToLast() ? new DbEntry((Slice)this.seekingIterator.key(), (Slice)this.seekingIterator.value()) : null;
    }

    @Override
    public boolean hasPrev() {
        if (this.direction == Direction.RELEASED) {
            throw new DBException(ILLEGAL_STATE);
        }
        if (this.direction != Direction.REVERSE) {
            this.elem = null;
            this.direction = Direction.REVERSE;
        }
        if (this.elem == null) {
            this.elem = this.seekingIterator.prev() ? new DbEntry((Slice)this.seekingIterator.key(), (Slice)this.seekingIterator.value()) : null;
        }
        return this.elem != null;
    }

    public DbEntry prev() {
        if (!this.hasPrev()) {
            throw new NoSuchElementException();
        }
        DbEntry elem = this.elem;
        this.elem = null;
        return elem;
    }

    public DbEntry peekPrev() {
        if (!this.hasPrev()) {
            throw new NoSuchElementException();
        }
        return this.elem;
    }

    public static class DbEntry
    implements Map.Entry<byte[], byte[]> {
        private final Slice key;
        private final Slice value;

        public DbEntry(Slice key, Slice value) {
            Objects.requireNonNull(key, "key is null");
            Objects.requireNonNull(value, "value is null");
            this.key = key;
            this.value = value;
        }

        @Override
        public byte[] getKey() {
            return this.key.getBytes();
        }

        public Slice getKeySlice() {
            return this.key;
        }

        @Override
        public byte[] getValue() {
            return this.value.getBytes();
        }

        public Slice getValueSlice() {
            return this.value;
        }

        @Override
        public byte[] setValue(byte[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + String.valueOf(this.value);
        }
    }
}

