/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.iterator;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.iterator.Direction;
import org.iq80.leveldb.iterator.SeekingIterator;

public abstract class ASeekingIterator<K, V>
implements SeekingIterator<K, V> {
    private static final String RELEASED_EXCEPTION = "Illegal use of iterator after release";
    private Direction direction = Direction.START_OF_ITERATOR;

    @Override
    public final boolean valid() {
        return this.direction.isValid();
    }

    @Override
    public final boolean seekToFirst() {
        if (this.direction == Direction.RELEASED) {
            throw new DBException(RELEASED_EXCEPTION);
        }
        if (this.internalSeekToFirst()) {
            this.direction = Direction.FORWARD;
            return true;
        }
        this.direction = Direction.END_OF_ITERATOR;
        return false;
    }

    @Override
    public final boolean seekToLast() {
        if (this.direction == Direction.RELEASED) {
            throw new DBException(RELEASED_EXCEPTION);
        }
        if (this.internalSeekToLast()) {
            this.direction = Direction.REVERSE;
            return true;
        }
        this.direction = Direction.START_OF_ITERATOR;
        return false;
    }

    @Override
    public final boolean seek(K key) {
        if (this.direction == Direction.RELEASED) {
            throw new DBException(RELEASED_EXCEPTION);
        }
        if (this.internalSeek(key)) {
            this.direction = Direction.FORWARD;
            return true;
        }
        this.direction = Direction.END_OF_ITERATOR;
        return false;
    }

    @Override
    public final boolean next() {
        boolean switchDirection;
        switch (this.direction) {
            case START_OF_ITERATOR: {
                return this.seekToFirst();
            }
            case RELEASED: {
                throw new DBException(RELEASED_EXCEPTION);
            }
            case END_OF_ITERATOR: {
                return false;
            }
        }
        boolean bl = switchDirection = this.direction == Direction.REVERSE;
        if (this.internalNext(switchDirection)) {
            if (switchDirection) {
                this.direction = Direction.FORWARD;
            }
            return true;
        }
        this.direction = Direction.END_OF_ITERATOR;
        return false;
    }

    @Override
    public final boolean prev() {
        boolean switchDirection;
        switch (this.direction) {
            case RELEASED: {
                throw new DBException(RELEASED_EXCEPTION);
            }
            case START_OF_ITERATOR: {
                return false;
            }
            case END_OF_ITERATOR: {
                return this.seekToLast();
            }
        }
        boolean bl = switchDirection = this.direction == Direction.FORWARD;
        if (this.internalPrev(switchDirection)) {
            if (switchDirection) {
                this.direction = Direction.REVERSE;
            }
            return true;
        }
        this.direction = Direction.START_OF_ITERATOR;
        return false;
    }

    @Override
    public final K key() {
        if (!this.direction.isValid()) {
            throw new NoSuchElementException();
        }
        return this.internalKey();
    }

    @Override
    public final V value() {
        if (!this.direction.isValid()) {
            throw new NoSuchElementException();
        }
        return this.internalValue();
    }

    @Override
    public final void close() {
        if (this.direction != Direction.RELEASED) {
            this.direction = Direction.RELEASED;
            try {
                this.internalClose();
            }
            catch (IOException e) {
                throw new DBException(e);
            }
        } else {
            throw new DBException("Releasing iterator more than once");
        }
    }

    protected abstract void internalClose() throws IOException;

    protected abstract boolean internalSeek(K var1);

    protected abstract boolean internalNext(boolean var1);

    protected abstract boolean internalPrev(boolean var1);

    protected abstract boolean internalSeekToFirst();

    protected abstract boolean internalSeekToLast();

    protected abstract V internalValue();

    protected abstract K internalKey();
}

