/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.fileenv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.iq80.leveldb.env.WritableFile;
import org.iq80.leveldb.util.Slice;

class UnbufferedWritableFile
implements WritableFile {
    private final File file;
    private final FileChannel channel;

    private UnbufferedWritableFile(File file, FileChannel channel) {
        this.file = file;
        this.channel = channel;
    }

    public static WritableFile open(File file, boolean append) throws FileNotFoundException {
        return new UnbufferedWritableFile(file, new FileOutputStream(file, append).getChannel());
    }

    @Override
    public void append(Slice data) throws IOException {
        this.channel.write(data.toByteBuffer());
    }

    @Override
    public void force() throws IOException {
        this.channel.force(false);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public String toString() {
        return "UnbufferedWritableFile{file=" + String.valueOf(this.file) + "}";
    }
}

