/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.fileenv;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.iq80.leveldb.Logger;
import org.iq80.leveldb.env.DbLock;
import org.iq80.leveldb.env.Env;
import org.iq80.leveldb.env.NoOpLogger;
import org.iq80.leveldb.env.RandomInputFile;
import org.iq80.leveldb.env.SequentialFile;
import org.iq80.leveldb.env.WritableFile;
import org.iq80.leveldb.fileenv.FileLock;
import org.iq80.leveldb.fileenv.FileUtils;
import org.iq80.leveldb.fileenv.JavaFile;
import org.iq80.leveldb.fileenv.MMRandomInputFile;
import org.iq80.leveldb.fileenv.MMWritableFile;
import org.iq80.leveldb.fileenv.MmapLimiter;
import org.iq80.leveldb.fileenv.SequentialFileImpl;
import org.iq80.leveldb.fileenv.UnbufferedRandomInputFile;
import org.iq80.leveldb.fileenv.UnbufferedWritableFile;
import org.iq80.leveldb.util.Slice;

public class EnvImpl
implements Env {
    private static final int PAGE_SIZE = 0x100000;
    private final MmapLimiter mmapLimiter;

    private EnvImpl(MmapLimiter mmapLimiter) {
        this.mmapLimiter = mmapLimiter;
    }

    public static Env createEnv() {
        return new EnvImpl(MmapLimiter.defaultLimiter());
    }

    public static Env createEnv(MmapLimiter mmapLimiter) {
        return new EnvImpl(mmapLimiter);
    }

    @Override
    public long nowMicros() {
        return TimeUnit.NANOSECONDS.toMicros(System.nanoTime());
    }

    @Override
    public org.iq80.leveldb.env.File toFile(String filename) {
        return JavaFile.fromFile(new File(filename));
    }

    @Override
    public org.iq80.leveldb.env.File createTempDir(String prefix) {
        return JavaFile.fromFile(FileUtils.createTempDir(prefix));
    }

    @Override
    public SequentialFile newSequentialFile(org.iq80.leveldb.env.File file) throws IOException {
        return SequentialFileImpl.open(JavaFile.toFile(file));
    }

    @Override
    public RandomInputFile newRandomAccessFile(org.iq80.leveldb.env.File file) throws IOException {
        if (this.mmapLimiter.acquire()) {
            try {
                return new DelegateRandomInputFile(this.mmapLimiter, MMRandomInputFile.open(JavaFile.toFile(file)));
            }
            catch (IOException e) {
                this.mmapLimiter.release();
                throw e;
            }
        }
        return UnbufferedRandomInputFile.open(JavaFile.toFile(file));
    }

    @Override
    public WritableFile newWritableFile(org.iq80.leveldb.env.File file) throws IOException {
        if (this.mmapLimiter.acquire()) {
            try {
                return new DelegateWritableFile(this.mmapLimiter, MMWritableFile.open(JavaFile.toFile(file), 0x100000));
            }
            catch (IOException e) {
                this.mmapLimiter.release();
                throw e;
            }
        }
        return UnbufferedWritableFile.open(JavaFile.toFile(file), false);
    }

    @Override
    public WritableFile newAppendableFile(org.iq80.leveldb.env.File file) throws IOException {
        return UnbufferedWritableFile.open(JavaFile.toFile(file), true);
    }

    @Override
    public void writeStringToFileSync(org.iq80.leveldb.env.File file, String content) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(JavaFile.toFile(file));){
            stream.write(content.getBytes(StandardCharsets.UTF_8));
            stream.flush();
            stream.getFD().sync();
        }
    }

    @Override
    public String readFileToString(org.iq80.leveldb.env.File file) throws IOException {
        return Files.asCharSource(JavaFile.toFile(file), StandardCharsets.UTF_8).read();
    }

    @Override
    public Logger newLogger(org.iq80.leveldb.env.File loggerFile) throws IOException {
        return new NoOpLogger();
    }

    @Override
    public DbLock tryLock(org.iq80.leveldb.env.File file) throws IOException {
        return FileLock.tryLock(JavaFile.toFile(file));
    }

    private static class DelegateRandomInputFile
    implements RandomInputFile {
        private final MmapLimiter mmapLimiter;
        private final RandomInputFile open;

        DelegateRandomInputFile(MmapLimiter mmapLimiter, RandomInputFile open) {
            this.mmapLimiter = mmapLimiter;
            this.open = open;
        }

        @Override
        public long size() {
            return this.open.size();
        }

        @Override
        public ByteBuffer read(long offset, int length) throws IOException {
            return this.open.read(offset, length);
        }

        @Override
        public void close() throws IOException {
            try {
                this.open.close();
            }
            finally {
                this.mmapLimiter.release();
            }
        }
    }

    private static class DelegateWritableFile
    implements WritableFile {
        private final MmapLimiter mmapLimiter;
        private final WritableFile open;

        DelegateWritableFile(MmapLimiter mmapLimiter, WritableFile open) {
            this.mmapLimiter = mmapLimiter;
            this.open = open;
        }

        @Override
        public void append(Slice data) throws IOException {
            this.open.append(data);
        }

        @Override
        public void force() throws IOException {
            this.open.force();
        }

        @Override
        public void close() throws IOException {
            try {
                this.open.close();
            }
            finally {
                this.mmapLimiter.release();
            }
        }
    }
}

