/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.hivemc.chunker.conversion.encoding.java.JavaDataVersion;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.array.IntArrayTag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.FloatTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class JsonTextUtil {
    public static final char CHAT_COLOR = '\u00a7';
    public static final Pattern LEGACY_FORMAT_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    public static final BiMap<String, Integer> COLOR_TO_BEDROCK_HEX = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put("black", (Object)-16777216)).put("red", (Object)-5231066)).put("green", (Object)-10585066)).put("brown", (Object)-8170446)).put("blue", (Object)-12827478)).put("purple", (Object)-7785800)).put("cyan", (Object)-15295332)).put("light_gray", (Object)-6447721)).put("gray", (Object)-12103854)).put("pink", (Object)-816214)).put("lime", (Object)-8337633)).put("yellow", (Object)-75715)).put("light_blue", (Object)-12930086)).put("magenta", (Object)-3715395)).put("orange", (Object)-425955)).put("white", (Object)-986896)).build();
    public static final BiMap<String, Character> COLOR_TO_CHARACTER = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put("black", Character.valueOf('0'))).put("dark_blue", Character.valueOf('1'))).put("dark_green", Character.valueOf('2'))).put("dark_aqua", Character.valueOf('3'))).put("dark_red", Character.valueOf('4'))).put("dark_purple", Character.valueOf('5'))).put("gold", Character.valueOf('6'))).put("gray", Character.valueOf('7'))).put("dark_gray", Character.valueOf('8'))).put("blue", Character.valueOf('9'))).put("green", Character.valueOf('a'))).put("aqua", Character.valueOf('b'))).put("red", Character.valueOf('c'))).put("light_purple", Character.valueOf('d'))).put("yellow", Character.valueOf('e'))).put("white", Character.valueOf('f'))).put("obfuscated", Character.valueOf('k'))).put("bold", Character.valueOf('l'))).put("strikethrough", Character.valueOf('m'))).put("underline", Character.valueOf('n'))).put("italic", Character.valueOf('o'))).put("reset", Character.valueOf('r'))).build();
    public static final JsonObject EMPTY_TEXT_TAG = JsonTextUtil.fromText("");
    private static final Gson GSON = new Gson();

    public static JsonObject fromText(String text) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", text);
        return jsonObject;
    }

    public static String toLegacy(JsonElement input, boolean bedrock) {
        if (input == null || input.isJsonNull()) {
            return "";
        }
        if (input.isJsonPrimitive()) {
            JsonPrimitive primitive = input.getAsJsonPrimitive();
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? "true" : "false";
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber().toString();
            }
            throw new IllegalArgumentException("Unable to turn JSON into legacy " + String.valueOf(input));
        }
        if (input.isJsonArray()) {
            StringBuilder output = new StringBuilder();
            for (JsonElement element : input.getAsJsonArray()) {
                output.append(JsonTextUtil.toLegacy(element, bedrock));
            }
            return output.toString();
        }
        if (input.isJsonObject()) {
            JsonObject jsonObject = input.getAsJsonObject();
            StringBuilder output = new StringBuilder();
            if (jsonObject.has("color") && COLOR_TO_CHARACTER.containsKey(jsonObject.get("color").getAsString())) {
                output.append('\u00a7').append(COLOR_TO_CHARACTER.get(jsonObject.get("color").getAsString()));
            }
            if (jsonObject.has("bold") && jsonObject.get("bold").getAsBoolean()) {
                output.append('\u00a7').append(COLOR_TO_CHARACTER.get("bold"));
            }
            if (jsonObject.has("italic") && jsonObject.get("italic").getAsBoolean()) {
                output.append('\u00a7').append(COLOR_TO_CHARACTER.get("italic"));
            }
            if (jsonObject.has("underline") && jsonObject.get("underline").getAsBoolean() && !bedrock) {
                output.append('\u00a7').append(COLOR_TO_CHARACTER.get("underline"));
            }
            if (jsonObject.has("strikethrough") && jsonObject.get("strikethrough").getAsBoolean() && !bedrock) {
                output.append('\u00a7').append(COLOR_TO_CHARACTER.get("strikethrough"));
            }
            if (jsonObject.has("obfuscated") && jsonObject.get("obfuscated").getAsBoolean()) {
                output.append('\u00a7').append(COLOR_TO_CHARACTER.get("obfuscated"));
            }
            if (jsonObject.has("text")) {
                output.append(JsonTextUtil.toLegacy(jsonObject.get("text"), bedrock));
            }
            if (jsonObject.has("translate")) {
                output.append(JsonTextUtil.toLegacy(jsonObject.get("translate"), bedrock));
            }
            if (jsonObject.has("extra")) {
                output.append(JsonTextUtil.toLegacy(jsonObject.get("extra"), bedrock));
            }
            return output.toString();
        }
        throw new IllegalArgumentException("Unable to turn JSON into legacy " + String.valueOf(input));
    }

    public static String toStripped(JsonElement input) {
        if (input == null || input.isJsonNull()) {
            return "";
        }
        if (input.isJsonPrimitive()) {
            JsonPrimitive primitive = input.getAsJsonPrimitive();
            if (primitive.isString()) {
                return LEGACY_FORMAT_PATTERN.matcher(primitive.getAsString()).replaceAll("");
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? "true" : "false";
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber().toString();
            }
            throw new IllegalArgumentException("Unable to turn JSON into legacy " + String.valueOf(input));
        }
        if (input.isJsonArray()) {
            StringBuilder output = new StringBuilder();
            for (JsonElement element : input.getAsJsonArray()) {
                output.append(JsonTextUtil.toStripped(element));
            }
            return output.toString();
        }
        if (input.isJsonObject()) {
            JsonObject jsonObject = input.getAsJsonObject();
            StringBuilder output = new StringBuilder();
            if (jsonObject.has("text")) {
                output.append(JsonTextUtil.toStripped(jsonObject.get("text")));
            }
            if (jsonObject.has("translate")) {
                throw new IllegalArgumentException("Unable to turn JSON into legacy " + String.valueOf(jsonObject));
            }
            if (jsonObject.has("extra")) {
                output.append(JsonTextUtil.toStripped(jsonObject.get("extra")));
            }
            return output.toString();
        }
        throw new IllegalArgumentException("Unable to turn JSON into legacy " + String.valueOf(input));
    }

    public static JsonElement fromJSON(@Nullable String jsonString) {
        if (jsonString == null) {
            return EMPTY_TEXT_TAG;
        }
        try {
            JsonElement jsonElement = GSON.fromJson(jsonString, JsonElement.class);
            if (jsonElement.isJsonNull()) {
                return EMPTY_TEXT_TAG;
            }
            if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
                return JsonTextUtil.fromText(jsonElement.getAsJsonPrimitive().getAsString());
            }
            return jsonElement;
        }
        catch (Exception e) {
            return JsonTextUtil.fromText(jsonString);
        }
    }

    public static JsonElement fromNBT(@Nullable Tag<?> tag) {
        try {
            if (tag == null) {
                return EMPTY_TEXT_TAG;
            }
            if (tag instanceof StringTag) {
                StringTag stringTag = (StringTag)tag;
                return JsonTextUtil.fromJSON(stringTag.getValue());
            }
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                if (compoundTag.contains("")) {
                    return JsonTextUtil.fromNBT(compoundTag.get(""));
                }
                JsonObject converted = compoundTag.contains("text") ? JsonTextUtil.fromText(compoundTag.getString("text", "")) : new JsonObject();
                compoundTag.getOptionalValue("color", String.class).ifPresent(value -> converted.addProperty("color", (String)value));
                compoundTag.getOptional("shadow_color", Tag.class).ifPresent(shadowColorTag -> {
                    if (shadowColorTag instanceof IntTag) {
                        IntTag intTag = (IntTag)shadowColorTag;
                        converted.addProperty("shadow_color", intTag.getValue());
                    } else if (shadowColorTag instanceof ListTag) {
                        List values = compoundTag.getListValues("shadow_color", FloatTag.class);
                        JsonArray array = new JsonArray(values.size());
                        for (Float value : values) {
                            array.add(value);
                        }
                        converted.add("shadow_color", array);
                    }
                });
                compoundTag.getOptionalValue("bold", Byte.class).ifPresent(value -> converted.addProperty("bold", value == 1));
                compoundTag.getOptionalValue("italic", Byte.class).ifPresent(value -> converted.addProperty("italic", value == 1));
                compoundTag.getOptionalValue("underlined", Byte.class).ifPresent(value -> converted.addProperty("underlined", value == 1));
                compoundTag.getOptionalValue("strikethrough", Byte.class).ifPresent(value -> converted.addProperty("strikethrough", value == 1));
                compoundTag.getOptionalValue("obfuscated", Byte.class).ifPresent(value -> converted.addProperty("obfuscated", value == 1));
                compoundTag.getOptionalValue("selector", String.class).ifPresent(value -> converted.addProperty("selector", (String)value));
                compoundTag.getOptional("separator", Tag.class).ifPresent(value -> converted.add("separator", JsonTextUtil.fromNBT(value)));
                compoundTag.getOptionalValue("nbt", String.class).ifPresent(value -> converted.addProperty("nbt", (String)value));
                compoundTag.getOptionalValue("source", String.class).ifPresent(value -> converted.addProperty("source", (String)value));
                compoundTag.getOptionalValue("interpret", Byte.class).ifPresent(value -> converted.addProperty("interpret", value == 1));
                compoundTag.getOptionalValue("translate", String.class).ifPresent(value -> converted.addProperty("translate", (String)value));
                compoundTag.getOptional("fallback", Tag.class).ifPresent(value -> converted.add("fallback", JsonTextUtil.fromNBT(value)));
                compoundTag.getOptionalValue("keybind", String.class).ifPresent(value -> converted.addProperty("keybind", (String)value));
                compoundTag.getOptionalValue("insertion", String.class).ifPresent(value -> converted.addProperty("insertion", (String)value));
                compoundTag.getOptionalValue("font", String.class).ifPresent(value -> converted.addProperty("font", (String)value));
                compoundTag.getOptional("score", CompoundTag.class).ifPresent(value -> {
                    JsonObject score = new JsonObject();
                    value.getOptionalValue("objective", String.class).ifPresent(value2 -> score.addProperty("objective", (String)value2));
                    value.getOptionalValue("name", String.class).ifPresent(value2 -> score.addProperty("name", (String)value2));
                    converted.add("score", score);
                });
                compoundTag.getOptional("hover_event", CompoundTag.class).ifPresent(value -> {
                    JsonObject hoverEvent = new JsonObject();
                    String action = value.getString("action", "");
                    if (action.isEmpty()) {
                        return;
                    }
                    hoverEvent.addProperty("action", action);
                    switch (action) {
                        case "show_text": {
                            value.getOptional("value", Tag.class).ifPresent(value2 -> hoverEvent.add("contents", JsonTextUtil.fromNBT(value2)));
                            break;
                        }
                        case "show_item": {
                            JsonObject itemContents = new JsonObject();
                            value.getOptionalValue("id", String.class).ifPresent(value2 -> itemContents.addProperty("id", (String)value2));
                            value.getOptionalValue("count", Integer.class).ifPresent(value2 -> itemContents.addProperty("count", (Number)value2));
                            if (itemContents.isEmpty()) break;
                            hoverEvent.add("contents", itemContents);
                            break;
                        }
                        case "show_entity": {
                            JsonObject entityContents = new JsonObject();
                            value.getOptional("name", Tag.class).ifPresent(value2 -> entityContents.add("name", JsonTextUtil.fromNBT(value2)));
                            value.getOptionalValue("id", String.class).ifPresent(value2 -> entityContents.addProperty("type", (String)value2));
                            value.getOptional("uuid", Tag.class).ifPresent(value2 -> {
                                if (value2 instanceof StringTag) {
                                    StringTag stringTag = (StringTag)value2;
                                    entityContents.addProperty("id", stringTag.getValue());
                                } else if (value2 instanceof IntArrayTag) {
                                    IntArrayTag intArrayTag = (IntArrayTag)value2;
                                    JsonArray ids = new JsonArray(intArrayTag.length());
                                    for (int i : Objects.requireNonNull(intArrayTag.getValue())) {
                                        ids.add(i);
                                    }
                                    entityContents.add("id", ids);
                                } else {
                                    throw new IllegalArgumentException("Unknown UUID type " + String.valueOf(value2));
                                }
                            });
                            if (entityContents.isEmpty()) break;
                            hoverEvent.add("contents", entityContents);
                        }
                    }
                    converted.add("hoverEvent", hoverEvent);
                });
                compoundTag.getOptional("click_event", CompoundTag.class).ifPresent(value -> {
                    JsonObject clickEvent = new JsonObject();
                    String action = value.getString("action", "");
                    if (action.isEmpty()) {
                        return;
                    }
                    clickEvent.addProperty("action", action);
                    switch (action) {
                        case "open_url": {
                            value.getOptionalValue("url", String.class).ifPresent(value2 -> clickEvent.addProperty("value", (String)value2));
                            break;
                        }
                        case "open_file": {
                            value.getOptionalValue("path", String.class).ifPresent(value2 -> clickEvent.addProperty("value", (String)value2));
                            break;
                        }
                        case "run_command": 
                        case "suggest_command": {
                            value.getOptionalValue("command", String.class).ifPresent(value2 -> clickEvent.addProperty("value", (String)value2));
                            break;
                        }
                        case "change_page": {
                            value.getOptionalValue("page", Integer.class).ifPresent(value2 -> clickEvent.addProperty("value", String.valueOf(value2)));
                            break;
                        }
                        default: {
                            value.getOptionalValue("value", String.class).ifPresent(value2 -> clickEvent.addProperty("value", (String)value2));
                        }
                    }
                    converted.add("clickEvent", clickEvent);
                });
                if (compoundTag.contains("extra")) {
                    converted.add("extra", JsonTextUtil.fromNBT(compoundTag.get("extra")));
                }
                return converted;
            }
            if (tag instanceof ListTag) {
                ListTag listTag = (ListTag)tag;
                JsonArray jsonArray = new JsonArray(listTag.size());
                for (Tag child : listTag) {
                    jsonArray.add(JsonTextUtil.fromNBT(child));
                }
                return jsonArray;
            }
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Unable to parse Text component " + String.valueOf(tag), throwable);
        }
        throw new IllegalArgumentException("Unknown type for Text component " + String.valueOf(tag));
    }

    public static Tag<?> toNBT(@Nullable JsonElement element) {
        try {
            if (element == null) {
                return new StringTag("");
            }
            if (element.isJsonPrimitive()) {
                JsonPrimitive primitive = element.getAsJsonPrimitive();
                return new StringTag(primitive.getAsString());
            }
            if (element.isJsonObject()) {
                String action;
                JsonObject object = element.getAsJsonObject();
                CompoundTag converted = new CompoundTag(1);
                if (object.has("text")) {
                    converted.put("text", object.get("text").getAsString());
                }
                if (object.has("color")) {
                    converted.put("color", object.get("color").getAsString());
                }
                if (object.has("shadow_color")) {
                    JsonElement shadowColor = object.get("shadow_color");
                    if (shadowColor.isJsonPrimitive()) {
                        converted.put("shadow_color", shadowColor.getAsInt());
                    } else {
                        ArrayList<Float> values = new ArrayList<Float>(4);
                        for (Object v : shadowColor.getAsJsonArray()) {
                            values.add(Float.valueOf(((JsonElement)v).getAsFloat()));
                        }
                        converted.put("shadow_color", ListTag.fromValues(TagType.FLOAT, values));
                    }
                }
                if (object.has("bold")) {
                    converted.put("bold", object.get("bold").getAsBoolean() ? (byte)1 : 0);
                }
                if (object.has("italic")) {
                    converted.put("italic", object.get("italic").getAsBoolean() ? (byte)1 : 0);
                }
                if (object.has("underlined")) {
                    converted.put("underlined", object.get("underlined").getAsBoolean() ? (byte)1 : 0);
                }
                if (object.has("strikethrough")) {
                    converted.put("strikethrough", object.get("strikethrough").getAsBoolean() ? (byte)1 : 0);
                }
                if (object.has("obfuscated")) {
                    converted.put("obfuscated", object.get("obfuscated").getAsBoolean() ? (byte)1 : 0);
                }
                if (object.has("selector")) {
                    converted.put("selector", object.get("selector").getAsString());
                }
                if (object.has("separator")) {
                    converted.put("separator", JsonTextUtil.toNBT(object.get("separator")));
                }
                if (object.has("nbt")) {
                    converted.put("nbt", object.get("nbt").getAsString());
                }
                if (object.has("source")) {
                    converted.put("source", object.get("source").getAsString());
                }
                if (object.has("interpret")) {
                    converted.put("interpret", object.get("interpret").getAsBoolean() ? (byte)1 : 0);
                }
                if (object.has("translate")) {
                    converted.put("translate", object.get("translate").getAsString());
                }
                if (object.has("fallback")) {
                    converted.put("fallback", JsonTextUtil.toNBT(object.get("fallback")));
                }
                if (object.has("keybind")) {
                    converted.put("keybind", object.get("keybind").getAsString());
                }
                if (object.has("insertion")) {
                    converted.put("insertion", object.get("insertion").getAsString());
                }
                if (object.has("font")) {
                    converted.put("font", object.get("font").getAsString());
                }
                if (object.has("score")) {
                    JsonObject scoreElement = object.getAsJsonObject("score");
                    CompoundTag scoreTag = new CompoundTag(2);
                    if (scoreElement.has("objective")) {
                        scoreTag.put("objective", scoreElement.get("objective").getAsString());
                    }
                    if (scoreElement.has("name")) {
                        scoreTag.put("name", scoreElement.get("name").getAsString());
                    }
                    converted.put("score", scoreTag);
                }
                if (object.has("hoverEvent")) {
                    JsonObject hoverEvent = object.getAsJsonObject("hoverEvent");
                    CompoundTag hoverEventTag = new CompoundTag(2);
                    String string = action = hoverEvent.has("action") ? hoverEvent.get("action").getAsString() : "";
                    if (!action.isEmpty()) {
                        hoverEventTag.put("action", action);
                        switch (action) {
                            case "show_text": {
                                if (hoverEvent.has("contents")) {
                                    hoverEventTag.put("value", JsonTextUtil.toNBT(hoverEvent.get("contents")));
                                }
                                if (!hoverEvent.has("value")) break;
                                hoverEventTag.put("value", JsonTextUtil.toNBT(hoverEvent.get("value")));
                                break;
                            }
                            case "show_item": {
                                if (!hoverEvent.has("contents")) break;
                                JsonObject contents = hoverEvent.getAsJsonObject("contents");
                                if (contents.has("id")) {
                                    hoverEventTag.put("id", contents.get("id").getAsString());
                                }
                                if (!contents.has("count")) break;
                                hoverEventTag.put("count", contents.get("count").getAsInt());
                                break;
                            }
                            case "show_entity": {
                                if (!hoverEvent.has("contents")) break;
                                JsonObject contents = hoverEvent.getAsJsonObject("contents");
                                if (contents.has("type")) {
                                    hoverEventTag.put("id", contents.get("type").getAsString());
                                }
                                if (contents.has("name")) {
                                    hoverEventTag.put("name", JsonTextUtil.toNBT(contents.get("type")));
                                }
                                if (!contents.has("id")) break;
                                JsonElement uuid = contents.get("id");
                                if (uuid.isJsonPrimitive()) {
                                    hoverEventTag.put("uuid", contents.get("id").getAsString());
                                    break;
                                }
                                if (uuid.isJsonArray()) {
                                    int[] ids = new int[4];
                                    int i = 0;
                                    for (JsonElement id : uuid.getAsJsonArray()) {
                                        ids[i] = id.getAsInt();
                                    }
                                    hoverEventTag.put("uuid", ids);
                                    break;
                                }
                                throw new IllegalArgumentException("Unknown UUID type " + String.valueOf(uuid));
                            }
                        }
                        converted.put("hover_event", hoverEventTag);
                    }
                }
                if (object.has("clickEvent")) {
                    JsonObject clickEvent = object.getAsJsonObject("clickEvent");
                    CompoundTag clickEventTag = new CompoundTag(2);
                    String string = action = clickEvent.has("action") ? clickEvent.get("action").getAsString() : "";
                    if (!action.isEmpty()) {
                        clickEventTag.put("action", action);
                        switch (action) {
                            case "open_url": {
                                if (!clickEvent.has("value")) break;
                                clickEventTag.put("url", clickEvent.get("value").getAsString());
                                break;
                            }
                            case "open_file": {
                                if (!clickEvent.has("value")) break;
                                clickEventTag.put("path", clickEvent.get("value").getAsString());
                                break;
                            }
                            case "run_command": 
                            case "suggest_command": {
                                if (!clickEvent.has("value")) break;
                                clickEventTag.put("command", clickEvent.get("value").getAsString());
                                break;
                            }
                            case "change_page": {
                                if (!clickEvent.has("value")) break;
                                clickEventTag.put("page", Integer.parseInt(clickEvent.get("value").getAsString()));
                                break;
                            }
                            default: {
                                if (!clickEvent.has("value")) break;
                                clickEventTag.put("value", clickEvent.get("value").getAsString());
                            }
                        }
                        converted.put("click_event", clickEventTag);
                    }
                }
                if (object.has("extra")) {
                    converted.put("extra", JsonTextUtil.toNBT(object.get("extra")));
                }
                return converted;
            }
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                ListTag listTag = new ListTag(TagType.COMPOUND, array.size());
                for (JsonElement child : array) {
                    Tag<?> converted = JsonTextUtil.toNBT(child);
                    if (converted instanceof CompoundTag) {
                        CompoundTag compoundTag = (CompoundTag)converted;
                        listTag.add(compoundTag);
                        continue;
                    }
                    CompoundTag holder = new CompoundTag(1);
                    holder.put("", converted);
                    listTag.add(holder);
                }
                return listTag;
            }
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Unable to parse Text JSON " + String.valueOf(element), throwable);
        }
        throw new IllegalArgumentException("Unknown type for Text JSON " + String.valueOf(element));
    }

    public static String toJSON(JsonElement jsonElement) {
        return GSON.toJson(jsonElement);
    }

    public static Tag<?> toNBT(JsonElement jsonElement, JavaDataVersion javaDataVersion) {
        if (javaDataVersion.getVersion().isGreaterThanOrEqual(1, 21, 5)) {
            return JsonTextUtil.toNBT(jsonElement);
        }
        return new StringTag(JsonTextUtil.toJSON(jsonElement));
    }

    public static ListTag<?, ?> toNBT(List<JsonElement> jsonElements, int minimumSize, JavaDataVersion javaDataVersion) {
        if (javaDataVersion.getVersion().isGreaterThanOrEqual(1, 21, 5)) {
            boolean mixedListTagType = false;
            TagType<Tag<?>, ?> tagType = null;
            ArrayList tags = new ArrayList(Math.max(jsonElements.size(), minimumSize));
            for (JsonElement jsonElement : jsonElements) {
                Tag<?> tag = JsonTextUtil.toNBT(jsonElement, javaDataVersion);
                if (tagType == null) {
                    tagType = tag.getType();
                } else if (tagType != tag.getType()) {
                    mixedListTagType = true;
                }
                tags.add(tag);
            }
            while (tags.size() < minimumSize) {
                tags.add(new StringTag(JsonTextUtil.toJSON(EMPTY_TEXT_TAG)));
            }
            if (mixedListTagType) {
                return JsonTextUtil.castNBTList(TagType.COMPOUND, tags);
            }
            return JsonTextUtil.castNBTList(tagType, tags);
        }
        ListTag<StringTag, String> list = new ListTag<StringTag, String>(TagType.STRING, Math.max(jsonElements.size(), minimumSize));
        for (JsonElement jsonElement : jsonElements) {
            list.add(new StringTag(JsonTextUtil.toJSON(jsonElement)));
        }
        while (list.size() < minimumSize) {
            list.add(new StringTag(JsonTextUtil.toJSON(EMPTY_TEXT_TAG)));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Tag<U>, U> ListTag<T, U> castNBTList(TagType<T, U> target, List<Tag<?>> tags) {
        ListTag<void, U> listTag = new ListTag<void, U>(target, tags.size());
        for (Tag<?> tag : tags) {
            void var4_4;
            if (tag.getType() != target) {
                if (tag.getType() != TagType.COMPOUND) {
                    CompoundTag holder = new CompoundTag(1);
                    holder.put("", tag);
                    CompoundTag compoundTag = holder;
                } else {
                    throw new IllegalArgumentException("Unable to convert " + String.valueOf(tag) + " to " + String.valueOf(target));
                }
            }
            listTag.add(var4_4);
        }
        return listTag;
    }
}

