/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.util;

public class ByteUtil {
    public static byte getNibbleFromByte(byte input, boolean lowestBits) {
        return lowestBits ? (byte)(input & 0xF) : (byte)(input >> 4 & 0xF);
    }

    public static byte updateNibble(byte existingValue, byte input, boolean lowestBits) {
        byte otherValue = ByteUtil.getNibbleFromByte(existingValue, !lowestBits);
        if (lowestBits) {
            return (byte)(otherValue << 4 | input & 0xF);
        }
        return (byte)((input & 0xF) << 4 | otherValue);
    }

    public static byte[] convertToNibbleArray(byte[][][] input) {
        byte[] output = new byte[2048];
        for (int i = 0; i < 4096; ++i) {
            int x = i & 0xF;
            int z = i >> 4 & 0xF;
            int y = i >> 8 & 0xF;
            boolean lowestBits = (i & 1) == 0;
            int nibbleIndex = i >> 1;
            byte inputValue = input[x][y][z];
            output[nibbleIndex] = ByteUtil.updateNibble(output[nibbleIndex], inputValue, lowestBits);
        }
        return output;
    }
}

