/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buffer.remaining());
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int skippedBytes = (int)Math.min(n, (long)this.buffer.remaining());
        this.buffer.position(this.buffer.position() + skippedBytes);
        return skippedBytes;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }
}

