/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.scheduling.task;

import com.hivemc.chunker.scheduling.function.ThrowableConsumer;
import com.hivemc.chunker.scheduling.function.ThrowableFunction;
import com.hivemc.chunker.scheduling.function.ThrowableRunnable;
import com.hivemc.chunker.scheduling.function.ThrowableSupplier;
import com.hivemc.chunker.scheduling.task.Environment;
import com.hivemc.chunker.scheduling.task.FutureTask;
import com.hivemc.chunker.scheduling.task.ProgressiveTask;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import com.hivemc.chunker.scheduling.task.WrappedTask;
import com.hivemc.chunker.scheduling.task.executor.TaskExecutor;
import com.hivemc.chunker.util.SneakyThrows;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.jetbrains.annotations.Nullable;

public interface Task<O> {
    @SafeVarargs
    public static <T> FutureTask<List<T>> join(Task<T> ... tasks) {
        return Task.join(List.of(tasks));
    }

    public static <T> FutureTask<List<T>> join(Collection<? extends Task<? extends T>> tasks) {
        CompletableFuture[] futures = new CompletableFuture[tasks.size()];
        int i = 0;
        for (Task<T> task : tasks) {
            futures[i++] = task.future();
        }
        return new FutureTask<List<T>>(CompletableFuture.allOf(futures).thenApply(ignored -> {
            ArrayList results = new ArrayList(futures.length);
            for (CompletableFuture future : futures) {
                try {
                    results.add(future.get());
                }
                catch (Throwable t) {
                    SneakyThrows.throwException(t);
                }
            }
            return results;
        }));
    }

    public static <T> FutureTask<List<T>> flatJoin(Collection<? extends Task<? extends Collection<? extends T>>> tasks) {
        CompletableFuture[] futures = new CompletableFuture[tasks.size()];
        int i = 0;
        for (Task<Collection<T>> task : tasks) {
            futures[i++] = task.future();
        }
        return new FutureTask<List<T>>(CompletableFuture.allOf(futures).thenApply(ignored -> {
            ArrayList results = new ArrayList();
            for (CompletableFuture future : futures) {
                try {
                    results.addAll((Collection)future.get());
                }
                catch (Throwable t) {
                    SneakyThrows.throwException(t);
                }
            }
            return results;
        }));
    }

    public static <T> FutureTask<T> unwrap(Task<Task<T>> wrappedTask) {
        return new FutureTask(wrappedTask.future().thenCompose(Task::future));
    }

    public static ProgressiveTask<Void> async(String name, TaskWeight weight, ThrowableRunnable runnable) {
        WrappedTask<Object, Void> task = new WrappedTask<Object, Void>(name, weight, runnable);
        task.setupParent();
        TaskExecutor taskExecutor = TaskExecutor.currentExecutor();
        task.setupFuture(taskExecutor.execute(task, task.getPriority()));
        return task;
    }

    public static <T> ProgressiveTask<T> async(String name, TaskWeight weight, ThrowableSupplier<T> supplier) {
        WrappedTask task = new WrappedTask(name, weight, supplier);
        task.setupParent();
        TaskExecutor taskExecutor = TaskExecutor.currentExecutor();
        task.setupFuture(taskExecutor.execute(task, task.getPriority()));
        return task;
    }

    public static <T, U> ProgressiveTask<U> async(String name, TaskWeight weight, ThrowableFunction<T, U> function, T constant) {
        WrappedTask.WrappedTaskConstant<T, U> task = new WrappedTask.WrappedTaskConstant<T, U>(name, weight, constant, function);
        task.setupParent();
        TaskExecutor taskExecutor = TaskExecutor.currentExecutor();
        task.setupFuture(taskExecutor.execute(task, task.getPriority()));
        return task;
    }

    public static <T> ProgressiveTask<Void> asyncConsume(String name, TaskWeight weight, ThrowableConsumer<? super T> consumer, T constant) {
        WrappedTask.WrappedTaskConstant task = new WrappedTask.WrappedTaskConstant(name, weight, constant, consumer);
        task.setupParent();
        TaskExecutor taskExecutor = TaskExecutor.currentExecutor();
        task.setupFuture(taskExecutor.execute(task, task.getPriority()));
        return task;
    }

    public static <T> FutureTask<Void> asyncConsumeForEach(String name, TaskWeight taskWeight, ThrowableConsumer<? super T> consumer, Collection<T> inputs) {
        ArrayList<ProgressiveTask<Void>> tasks = new ArrayList<ProgressiveTask<Void>>(inputs.size());
        for (T input : inputs) {
            tasks.add(Task.asyncConsume(name, taskWeight, consumer, input));
        }
        return Task.join(tasks).then(null);
    }

    public static <T> FutureTask<Void> asyncConsumeForEach(String name, TaskWeight taskWeight, ThrowableConsumer<? super T> consumer, T[] inputs) {
        ArrayList<ProgressiveTask<Void>> tasks = new ArrayList<ProgressiveTask<Void>>(inputs.length);
        for (T input : inputs) {
            tasks.add(Task.asyncConsume(name, taskWeight, consumer, input));
        }
        return Task.join(tasks).then(null);
    }

    public static <T, U> FutureTask<List<U>> asyncForEach(String name, TaskWeight taskWeight, ThrowableFunction<T, U> function, Collection<T> inputs) {
        ArrayList<ProgressiveTask<U>> tasks = new ArrayList<ProgressiveTask<U>>(inputs.size());
        for (T input : inputs) {
            tasks.add(Task.async(name, taskWeight, function, input));
        }
        return Task.join(tasks);
    }

    public static <T, U> FutureTask<U[]> asyncForEach(String name, TaskWeight taskWeight, ThrowableFunction<T, U> function, IntFunction<U[]> arrayConstructor, T ... inputs) {
        WrappedTask.WrappedTaskConstant[] tasks = new WrappedTask.WrappedTaskConstant[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            tasks[i] = Task.async(name, taskWeight, function, inputs[i]);
        }
        return new FutureTask<U[]>((CompletableFuture<U[]>)Task.join(tasks).future().thenApply(results -> results.toArray(arrayConstructor)));
    }

    public static <T> FutureTask<T> asyncUnwrap(String name, TaskWeight weight, ThrowableSupplier<Task<T>> supplier) {
        WrappedTask task = new WrappedTask(name, weight, supplier);
        task.setupParent();
        TaskExecutor taskExecutor = TaskExecutor.currentExecutor();
        task.setupFuture(taskExecutor.execute(task, task.getPriority()));
        return Task.unwrap(task);
    }

    public static <T, U> FutureTask<U> asyncUnwrap(String name, TaskWeight weight, ThrowableFunction<T, Task<U>> function, T constant) {
        WrappedTask.WrappedTaskConstant<T, Task<U>> task = new WrappedTask.WrappedTaskConstant<T, Task<U>>(name, weight, constant, function);
        task.setupParent();
        TaskExecutor taskExecutor = TaskExecutor.currentExecutor();
        task.setupFuture(taskExecutor.execute(task, task.getPriority()));
        return Task.unwrap(task);
    }

    public static Environment environment(String name, int workerThreads, @Nullable Consumer<Throwable> exceptionHandler, @Nullable BiConsumer<String, Object> signalConsumer) {
        Environment environment = new Environment(name, workerThreads, exceptionHandler, signalConsumer);
        environment.start();
        return environment;
    }

    public CompletableFuture<O> future();

    public static void signal(String signalName, Object signalValue) {
        TaskExecutor.currentExecutor().signal(signalName, signalValue);
    }

    default public ProgressiveTask<Void> then(String name, TaskWeight weight, ThrowableRunnable runnable) {
        WrappedTask<Object, Void> task = new WrappedTask<Object, Void>(name, weight, runnable);
        task.setupParent();
        task.setupFuture((CompletableFuture<Void>)this.future().thenApply(task));
        return task;
    }

    default public <T> ProgressiveTask<T> then(String name, TaskWeight weight, ThrowableSupplier<T> supplier) {
        WrappedTask task = new WrappedTask(name, weight, supplier);
        task.setupParent();
        task.setupFuture(this.future().thenApply((Function)task));
        return task;
    }

    default public <T> FutureTask<T> then(T constant) {
        return new FutureTask(this.future().thenApply(ignored -> constant));
    }

    default public <T> ProgressiveTask<T> then(String name, TaskWeight weight, ThrowableFunction<? super O, T> function) {
        WrappedTask<O, T> task = new WrappedTask<O, T>(name, weight, function);
        task.setupParent();
        task.setupFuture((CompletableFuture<T>)this.future().thenApply(task));
        return task;
    }

    default public <T, U> ProgressiveTask<U> then(String name, TaskWeight weight, ThrowableFunction<T, U> function, T constant) {
        WrappedTask.WrappedTaskConstant<T, U> task = new WrappedTask.WrappedTaskConstant<T, U>(name, weight, constant, function);
        task.setupParent();
        task.setupFuture((CompletableFuture<U>)this.future().thenApply(task));
        return task;
    }

    default public ProgressiveTask<Void> thenConsume(String name, TaskWeight weight, ThrowableConsumer<? super O> consumer) {
        WrappedTask task = new WrappedTask(name, weight, consumer);
        task.setupParent();
        task.setupFuture(this.future().thenApply((Function)task));
        return task;
    }

    default public <T> ProgressiveTask<Void> thenConsume(String name, TaskWeight weight, ThrowableConsumer<T> consumer, T constant) {
        WrappedTask.WrappedTaskConstant task = new WrappedTask.WrappedTaskConstant(name, weight, constant, consumer);
        task.setupParent();
        task.setupFuture(this.future().thenApply((Function)task));
        return task;
    }

    default public <T> FutureTask<T> thenUnwrap(String name, TaskWeight weight, ThrowableSupplier<Task<T>> supplier) {
        WrappedTask task = new WrappedTask(name, weight, supplier);
        task.setupParent();
        task.setupFuture(this.future().thenApply((Function)task));
        return Task.unwrap(task);
    }

    default public <T> FutureTask<T> thenUnwrap(String name, TaskWeight weight, ThrowableFunction<? super O, Task<T>> function) {
        WrappedTask<O, Task<T>> task = new WrappedTask<O, Task<T>>(name, weight, function);
        task.setupParent();
        task.setupFuture((CompletableFuture<Task<T>>)this.future().thenApply(task));
        return Task.unwrap(task);
    }

    default public <T, U> FutureTask<U> thenUnwrap(String name, TaskWeight weight, ThrowableFunction<T, Task<U>> function, T constant) {
        WrappedTask.WrappedTaskConstant<T, Task<U>> task = new WrappedTask.WrappedTaskConstant<T, Task<U>>(name, weight, constant, function);
        task.setupParent();
        task.setupFuture((CompletableFuture<Task<U>>)this.future().thenApply(task));
        return Task.unwrap(task);
    }

    public static enum TaskStatus {
        PENDING,
        STARTED,
        DONE;

    }
}

