/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.scheduling;

import com.hivemc.chunker.scheduling.task.ProgressiveTask;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;

public class TaskMonitorThread
extends Thread {
    private final ProgressiveTask<?> task;
    private final DoubleConsumer progressChangeHandler;
    private final Consumer<Optional<Throwable>> completionHandler;
    private final CompletableFuture<?> taskFuture;

    public TaskMonitorThread(ProgressiveTask<?> task, DoubleConsumer progressChangeHandler, Consumer<Optional<Throwable>> completionHandler) {
        super("Task Monitor Thread");
        this.task = task;
        this.progressChangeHandler = progressChangeHandler;
        this.completionHandler = completionHandler;
        this.taskFuture = task.future();
    }

    @Override
    public void run() {
        double lastProgress = -1.0;
        while (!this.taskFuture.isDone() && lastProgress < 1.0) {
            double progress = this.task.getProgress();
            if (Math.abs(progress - lastProgress) >= 1.0E-4) {
                lastProgress = progress;
                this.progressChangeHandler.accept(lastProgress);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.taskFuture.whenComplete((result, throwable) -> this.completionHandler.accept(Optional.ofNullable(throwable)));
    }
}

