/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.primitive;

import com.google.common.escape.CharEscaperBuilder;
import com.google.common.escape.Escaper;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.util.ControlCodeEscaper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringTag
extends Tag<String> {
    public static final Escaper CONTROL_CODE_ESCAPER = new ControlCodeEscaper();
    public static final int MAX_STRING_LENGTH = Short.MAX_VALUE;
    public static final Escaper SNBT_ESCAPER = new CharEscaperBuilder().addEscape('\"', "\\\"").toEscaper();
    protected byte[] value;
    @Nullable
    protected String stringCache;

    public StringTag(String value) {
        this.stringCache = value;
        this.value = value.getBytes(StandardCharsets.UTF_8);
    }

    public StringTag(byte[] value) {
        this.stringCache = null;
        this.value = value;
    }

    public StringTag() {
    }

    @Override
    @NotNull
    public TagType<StringTag, String> getType() {
        return TagType.STRING;
    }

    @Override
    public boolean valueEquals(Tag<String> tag) {
        return Arrays.equals(this.getByteArrayValue(), ((StringTag)tag).getByteArrayValue());
    }

    @Override
    protected int valueHashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public String getBoxedValue() {
        return this.getValue();
    }

    @Override
    public StringTag clone() {
        return new StringTag(this.value);
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        writer.writeShortPrefixedBytes(this.value);
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        this.stringCache = null;
        this.value = reader.readShortPrefixedBytes(Short.MAX_VALUE);
    }

    @Override
    public String toSNBT() {
        return String.format("\"%s\"", SNBT_ESCAPER.escape(CONTROL_CODE_ESCAPER.escape(this.getBoxedValue())));
    }

    @Nullable
    public String getValue() {
        if (this.stringCache == null && this.value != null) {
            this.stringCache = new String(this.value, StandardCharsets.UTF_8);
        }
        return this.stringCache;
    }

    public byte @Nullable [] getByteArrayValue() {
        return this.value;
    }

    public void setValue(@Nullable String value) {
        this.stringCache = value;
        this.value = value != null ? value.getBytes(StandardCharsets.UTF_8) : null;
    }

    public void setValue(byte @Nullable [] value) {
        this.stringCache = null;
        this.value = value;
    }
}

