/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.primitive;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DoubleTag
extends Tag<Double> {
    protected double value;

    public DoubleTag(double value) {
        this.value = value;
    }

    public DoubleTag() {
    }

    @Override
    @NotNull
    public TagType<DoubleTag, Double> getType() {
        return TagType.DOUBLE;
    }

    @Override
    public boolean valueEquals(Tag<Double> tag) {
        return Objects.equals(this.value, ((DoubleTag)tag).getValue());
    }

    @Override
    public Double getBoxedValue() {
        return this.value;
    }

    @Override
    public DoubleTag clone() {
        return new DoubleTag(this.value);
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        writer.writeDouble(this.value);
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        this.value = reader.readDouble();
    }

    @Override
    public String toSNBT() {
        return String.valueOf(this.value);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }
}

