/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.collection;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListTag<T extends Tag<V>, V>
extends Tag<List<T>>
implements Iterable<T> {
    public static final int MAX_LIST_LENGTH = 0x100000;
    @Nullable
    private TagType<T, V> listType;
    @Nullable
    private List<T> value;

    public ListTag(@Nullable TagType<T, V> type, @Nullable List<T> value) {
        this.listType = type;
        this.value = value;
    }

    public ListTag(@Nullable TagType<T, V> type) {
        this(type, null);
    }

    public ListTag(@Nullable TagType<T, V> type, int initialCapacity) {
        this(type, new ArrayList(initialCapacity));
    }

    public ListTag(List<T> value) {
        this(value.isEmpty() ? null : ((Tag)value.get(0)).getType(), value);
    }

    public ListTag() {
    }

    public static <T extends Tag<V>, V> ListTag<T, V> fromValues(TagType<T, V> type, List<V> values) {
        ArrayList<Tag> newList = new ArrayList<Tag>(values.size());
        Function<V, V> tagConstructor = type.getValueConstructor();
        for (V value : values) {
            newList.add((Tag)tagConstructor.apply(value));
        }
        return new ListTag<T, V>(type, newList);
    }

    @Override
    @NotNull
    public TagType<? extends Tag<List<T>>, ? super List<T>> getType() {
        return TagType.LIST;
    }

    @Override
    protected int valueHashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public boolean valueEquals(List<T> boxedValue) {
        return Objects.equals(this.value, boxedValue) || this.value == null && boxedValue.isEmpty() || boxedValue == null && this.value.isEmpty();
    }

    @Override
    public boolean valueEquals(Tag<List<T>> tag) {
        return this.valueEquals(((ListTag)tag).getValue());
    }

    @Override
    public List<T> getBoxedValue() {
        return this.getValue();
    }

    @Override
    public ListTag<T, V> clone() {
        if (this.value != null) {
            ObjectArrayList copy = new ObjectArrayList(this.value.size());
            for (Tag entry : this.value) {
                copy.add(entry.clone());
            }
            return new ListTag<T, V>(this.getListType(), copy);
        }
        return new ListTag<T, V>(this.getListType(), null);
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        writer.writeByte((this.listType == null ? TagType.END : this.listType).getId());
        writer.writeInt(this.value == null ? 0 : this.value.size());
        if (this.listType != null && this.value != null && this.listType != TagType.END) {
            for (Tag tag : this.value) {
                tag.encodeValue(writer);
            }
        }
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        int tagId = reader.readUnsignedByte();
        this.listType = TagType.getById(tagId);
        int length = reader.readInt();
        if (length < 0 || length > 0x100000) {
            throw new IllegalArgumentException("Could not read list with length " + length);
        }
        if (this.listType != TagType.END && length > 0) {
            this.value = new ObjectArrayList<T>(length);
            for (int i = 0; i < length; ++i) {
                Tag tag = (Tag)Objects.requireNonNull(Objects.requireNonNull(this.listType).getConstructor()).get();
                tag.decodeValue(reader);
                this.value.add(tag);
            }
        } else {
            this.listType = TagType.END;
        }
    }

    @Override
    public String toSNBT() {
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        if (this.value != null) {
            for (Tag tag : this.value) {
                joiner.add(tag.toSNBT());
            }
        }
        return joiner.toString();
    }

    @Nullable
    public TagType<T, V> getListType() {
        return this.listType;
    }

    public List<T> getValue() {
        return this.value == null ? Collections.emptyList() : this.value;
    }

    public void setValue(@Nullable TagType<T, V> listType, @Nullable List<T> value) {
        this.listType = listType;
        this.value = value;
    }

    public boolean contains(V value) {
        if (this.value == null || this.value.isEmpty()) {
            return false;
        }
        for (Tag tag : this.value) {
            if (!tag.valueEquals(value)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.value == null ? 0 : this.value.size();
    }

    public boolean add(T value) {
        if (this.value == null) {
            this.value = new ObjectArrayList<T>(1);
            this.listType = ((Tag)value).getType();
        }
        return this.value.add(value);
    }

    public T get(int index) {
        if (this.value == null) {
            throw new IndexOutOfBoundsException();
        }
        return (T)((Tag)this.value.get(index));
    }

    public T set(int index, T value) {
        if (this.value == null) {
            throw new IndexOutOfBoundsException();
        }
        return (T)((Tag)this.value.set(index, value));
    }

    public List<V> toList() {
        if (this.value == null || this.value.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList output = new ArrayList(this.value.size());
        for (Tag tag : this.value) {
            output.add(tag.getBoxedValue());
        }
        return output;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.value == null ? Collections.emptyIterator() : this.value.iterator();
    }
}

