/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.mapping.resolver;

import com.hivemc.chunker.mapping.MappingsFile;
import com.hivemc.chunker.mapping.resolver.MappingsFileIdentifierResolver;

public class MappingsFileResolvers {
    private final MappingsFile mappings;
    private final MappingsFile inverseMappings;
    private final MappingsFileIdentifierResolver blockResolver;
    private final MappingsFileIdentifierResolver itemResolver;

    public MappingsFileResolvers(MappingsFile mappings) {
        this.mappings = mappings;
        this.inverseMappings = mappings.inverse();
        this.blockResolver = new MappingsFileIdentifierResolver(mappings, this.inverseMappings, MappingsFile::convertBlock);
        this.itemResolver = new MappingsFileIdentifierResolver(mappings, this.inverseMappings, MappingsFile::convertItem);
    }

    public MappingsFileIdentifierResolver asBlockIdentifierResolver() {
        return this.blockResolver;
    }

    public MappingsFileIdentifierResolver asItemIdentifierResolver() {
        return this.itemResolver;
    }

    public MappingsFile getMappings() {
        return this.mappings;
    }

    public MappingsFile getInverseMappings() {
        return this.inverseMappings;
    }
}

