/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.mapping.mappings;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.hivemc.chunker.mapping.identifier.states.StateValue;
import com.hivemc.chunker.mapping.mappings.TypeMapping;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TypeMappings {
    private final String name;
    private final Map<List<StateValue<?>>, TypeMapping> inputsToOutputsLookup;
    private final List<TypeMapping> redundant;

    public TypeMappings(String name, Map<List<StateValue<?>>, TypeMapping> inputsToOutputsLookup, List<TypeMapping> redundant) {
        this.name = name;
        this.inputsToOutputsLookup = inputsToOutputsLookup;
        this.redundant = redundant;
    }

    public static TypeMappings deserialize(String name, JsonElement jsonElement, JsonDeserializationContext context) throws JsonParseException {
        Object2ObjectOpenHashMap inputsToOutputsLookup = new Object2ObjectOpenHashMap();
        ArrayList<TypeMapping> redundant = new ArrayList<TypeMapping>();
        int index = 0;
        for (JsonElement entry : jsonElement.getAsJsonArray()) {
            TypeMapping typeMapping;
            if (inputsToOutputsLookup.putIfAbsent((typeMapping = TypeMapping.deserialize(index++, entry, context)).getInput(), typeMapping) == null) continue;
            redundant.add(typeMapping);
        }
        return new TypeMappings(name, inputsToOutputsLookup, redundant);
    }

    public String getName() {
        return this.name;
    }

    public Map<List<StateValue<?>>, TypeMapping> getInputsToOutputsLookup() {
        return this.inputsToOutputsLookup;
    }

    public List<TypeMapping> getRedundant() {
        return this.redundant;
    }

    public TypeMappings inverse() {
        TypeMapping existing;
        TypeMapping inverseTypeMapping;
        Object2ObjectOpenHashMap inverseInputsToOutputsLookup = new Object2ObjectOpenHashMap(this.inputsToOutputsLookup.size());
        ArrayList<TypeMapping> inverseRedundant = new ArrayList<TypeMapping>(this.redundant.size());
        for (Map.Entry<List<StateValue<?>>, TypeMapping> oldEntry : this.inputsToOutputsLookup.entrySet()) {
            inverseTypeMapping = oldEntry.getValue().inverse();
            existing = inverseInputsToOutputsLookup.putIfAbsent(inverseTypeMapping.getInput(), inverseTypeMapping);
            if (existing == null) continue;
            if (existing.getIndex() <= inverseTypeMapping.getIndex()) {
                inverseRedundant.add(inverseTypeMapping);
                continue;
            }
            inverseInputsToOutputsLookup.replace(inverseTypeMapping.getInput(), existing, inverseTypeMapping);
            inverseRedundant.add(existing);
        }
        for (TypeMapping oldRedundantEntry : this.redundant) {
            inverseTypeMapping = oldRedundantEntry.inverse();
            existing = inverseInputsToOutputsLookup.putIfAbsent(inverseTypeMapping.getInput(), inverseTypeMapping);
            if (existing == null) continue;
            if (existing.getIndex() <= inverseTypeMapping.getIndex()) {
                inverseRedundant.add(inverseTypeMapping);
                continue;
            }
            inverseInputsToOutputsLookup.replace(inverseTypeMapping.getInput(), existing, inverseTypeMapping);
            inverseRedundant.add(existing);
        }
        return new TypeMappings(this.name, inverseInputsToOutputsLookup, inverseRedundant);
    }

    public String toString() {
        return "TypeMappings{name='" + this.name + "', inputsToOutputsLookup=" + String.valueOf(this.inputsToOutputsLookup) + ", redundant=" + String.valueOf(this.redundant) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeMappings that = (TypeMappings)o;
        return Objects.equals(this.inputsToOutputsLookup, that.inputsToOutputsLookup) && Objects.equals(this.redundant, that.redundant);
    }

    public int hashCode() {
        return Objects.hash(this.inputsToOutputsLookup, this.redundant);
    }

    public JsonElement serialize(JsonSerializationContext context) {
        ArrayList<TypeMapping> fullTypeMappings = new ArrayList<TypeMapping>(this.inputsToOutputsLookup.size() + this.redundant.size());
        fullTypeMappings.addAll(this.inputsToOutputsLookup.values());
        fullTypeMappings.addAll(this.redundant);
        fullTypeMappings.sort(Comparator.comparing(TypeMapping::getIndex));
        JsonArray jsonArray = new JsonArray(fullTypeMappings.size());
        for (TypeMapping typeMapping : fullTypeMappings) {
            jsonArray.add(typeMapping.serialize(context));
        }
        return jsonArray;
    }
}

