/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.level;

import com.google.common.primitives.Primitives;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hivemc.chunker.conversion.encoding.EncodingType;
import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.reader.LevelReader;
import com.hivemc.chunker.conversion.encoding.base.writer.LevelWriter;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerGeneratorType;
import com.hivemc.chunker.conversion.intermediate.level.annotations.Bedrock;
import com.hivemc.chunker.conversion.intermediate.level.annotations.Category;
import com.hivemc.chunker.conversion.intermediate.level.annotations.CustomType;
import com.hivemc.chunker.conversion.intermediate.level.annotations.Hidden;
import com.hivemc.chunker.conversion.intermediate.level.annotations.Java;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class ChunkerLevelSettings {
    private static final Gson GSON = new Gson();
    @Bedrock
    @Category(value=Category.Type.WORLD_SETTINGS)
    public boolean bonusChestEnabled = false;
    @Bedrock
    @Category(value=Category.Type.WORLD_SETTINGS)
    public boolean bonusChestSpawned = false;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public boolean CenterMapsToOrigin = false;
    @Bedrock
    @Java(value="GameRules.commandBlockOutput")
    @Category(value=Category.Type.GAME_RULES)
    public boolean commandblockoutput = true;
    @Bedrock
    @Category(value=Category.Type.GAME_RULES)
    public boolean commandblocksenabled = true;
    @Bedrock
    @Java(value="allowCommands")
    @Category(value=Category.Type.GAME_RULES)
    public boolean commandsEnabled = true;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public boolean ConfirmedPlatformLockedContent = false;
    @Bedrock
    @Java(value="Difficulty", type=byte.class)
    @Category(value=Category.Type.WORLD_SETTINGS)
    public int Difficulty = 1;
    @Bedrock
    @Java(value="GameRules.doDaylightCycle")
    @Category(value=Category.Type.GAME_RULES)
    public boolean dodaylightcycle = true;
    @Bedrock
    @Java(value="GameRules.doEntityDrops")
    @Category(value=Category.Type.GAME_RULES)
    public boolean doentitydrops = true;
    @Bedrock
    @Java(value="GameRules.doFireTick")
    @Category(value=Category.Type.GAME_RULES)
    public boolean dofiretick = true;
    @Bedrock
    @Category(value=Category.Type.GAME_RULES)
    public boolean doimmediaterespawn = false;
    @Bedrock
    @Category(value=Category.Type.GAME_RULES)
    public boolean doinsomnia = true;
    @Bedrock
    @Java(value="GameRules.doMobLoot")
    @Category(value=Category.Type.GAME_RULES)
    public boolean domobloot = true;
    @Bedrock
    @Java(value="GameRules.doMobSpawning")
    @Category(value=Category.Type.GAME_RULES)
    public boolean domobspawning = true;
    @Bedrock
    @Java(value="GameRules.doTileDrops")
    @Category(value=Category.Type.GAME_RULES)
    public boolean dotiledrops = true;
    @Bedrock
    @Java(value="GameRules.doWeatherCycle")
    @Category(value=Category.Type.GAME_RULES)
    public boolean doweathercycle = true;
    @Bedrock
    @Category(value=Category.Type.GAME_RULES)
    public boolean drowningdamage = true;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public boolean educationFeaturesEnabled = false;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public byte eduLevel = 0;
    @Bedrock
    @Category(value=Category.Type.WORLD_SETTINGS)
    public boolean experimentalgameplay = false;
    @CustomType
    @Category(value=Category.Type.WORLD_SETTINGS)
    @Bedrock
    @Java
    @Hidden
    public int FlatWorldVersion = 1;
    @CustomType
    @Category(value=Category.Type.WORLD_SETTINGS)
    @Bedrock
    @Java
    @Hidden
    public boolean CavesAndCliffs = false;
    @CustomType
    @Category(value=Category.Type.WORLD_SETTINGS)
    @Bedrock
    @Java
    @Hidden
    public boolean R20Support = false;
    @CustomType
    @Category(value=Category.Type.WORLD_SETTINGS)
    @Bedrock
    @Java
    @Hidden
    public boolean R21Support = false;
    @CustomType
    @Category(value=Category.Type.WORLD_SETTINGS)
    @Bedrock
    @Java
    @Hidden
    public boolean WinterDrop2024 = false;
    @CustomType
    @Category(value=Category.Type.WORLD_SETTINGS)
    @Bedrock
    @Java
    @Hidden
    public boolean SummerDrop2025 = false;
    @CustomType
    @Category(value=Category.Type.WORLD_SETTINGS)
    @Bedrock
    @Java
    @Hidden
    public boolean AutumnDrop2025 = false;
    @Bedrock
    @Category(value=Category.Type.GAME_RULES)
    public boolean falldamage = true;
    @Bedrock
    @Category(value=Category.Type.GAME_RULES)
    public boolean firedamage = true;
    @Bedrock
    @Category(value=Category.Type.GAME_RULES)
    public boolean ForceGameType = false;
    @Bedrock
    @Category(value=Category.Type.GAME_RULES)
    public int functioncommandlimit = 10000;
    @Bedrock
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public int GameType = 0;
    @Bedrock
    @Java
    @CustomType
    @Category(value=Category.Type.WORLD_SETTINGS)
    public ChunkerGeneratorType GeneratorType = ChunkerGeneratorType.VOID;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public boolean hasBeenLoadedInCreative = true;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public boolean hasLockedBehaviorPack = false;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public boolean hasLockedResourcePack = false;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public boolean immutableWorld = false;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public boolean isFromLockedTemplate = false;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public boolean isFromWorldTemplate = false;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public boolean isWorldTemplateOptionLocked = false;
    @Bedrock
    @Java(value="GameRules.keepInventory")
    @Category(value=Category.Type.GAME_RULES)
    public boolean keepinventory = false;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public boolean LANBroadcast = true;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public boolean LANBroadcastIntent = true;
    @Bedrock
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public String LevelName = "Converted World";
    @Bedrock
    @Category(value=Category.Type.WEATHER)
    public float lightningLevel = 0.0f;
    @Bedrock
    @Category(value=Category.Type.WEATHER)
    public int lightningTime = 96000;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public int LimitedWorldOriginX = 0;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public int LimitedWorldOriginY = Short.MAX_VALUE;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public int LimitedWorldOriginZ = 0;
    @Bedrock
    @Java(value="GameRules.mobGriefing")
    @Category(value=Category.Type.GAME_RULES)
    public boolean mobgriefing = true;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public boolean MultiplayerGame = true;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public boolean MultiplayerGameIntent = true;
    @Bedrock
    @Java(value="GameRules.naturalRegeneration")
    @Category(value=Category.Type.GAME_RULES)
    public boolean naturalregeneration = true;
    @Bedrock
    @Category(value=Category.Type.WORLD_SETTINGS)
    public int NetherScale = 8;
    @Bedrock
    @Category(value=Category.Type.WEATHER)
    public float rainLevel = 0.0f;
    @Bedrock
    @Java
    @Category(value=Category.Type.WEATHER)
    public int rainTime = 48000;
    @Bedrock
    @Java
    @CustomType
    @Category(value=Category.Type.WORLD_SETTINGS)
    public String RandomSeed = "1234";
    @Bedrock
    @Java(value="GameRules.randomTickSpeed")
    @Category(value=Category.Type.GAME_RULES)
    public int randomtickspeed = 1;
    @Bedrock
    @Java(value="GameRules.sendCommandFeedback")
    @Category(value=Category.Type.GAME_RULES)
    public boolean sendcommandfeedback = true;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public int serverChunkTickRange = 10;
    @Bedrock
    @Category(value=Category.Type.GAME_RULES)
    public boolean showcoordinates = false;
    @Bedrock
    @Java(value="GameRules.showDeathMessages")
    @Category(value=Category.Type.GAME_RULES)
    public boolean showdeathmessages = true;
    @Bedrock
    @Category(value=Category.Type.WORLD_SETTINGS)
    public boolean spawnMobs = true;
    @Bedrock
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public int SpawnX = 0;
    @Bedrock
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public int SpawnY = Short.MAX_VALUE;
    @Bedrock
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public int SpawnZ = 0;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public boolean startWithMapEnabled = false;
    @Bedrock
    @Category(value=Category.Type.RESTRICTIONS)
    public boolean texturePacksRequired = false;
    @Bedrock
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public long Time = 0L;
    @Bedrock
    @Category(value=Category.Type.GAME_RULES)
    public boolean tntexplodes = true;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public boolean useMsaGamertagsOnly = false;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public long worldStartCount = 0L;
    @Bedrock
    @Category(value=Category.Type.MISC)
    public int XBLBroadcastIntent = 3;
    @Java(value="GameRules.announceAdvancements")
    @Category(value=Category.Type.GAME_RULES)
    public boolean announceAdvancements = true;
    @Java(value="GameRules.disableElytraMovementCheck")
    @Category(value=Category.Type.GAME_RULES)
    public boolean disableElytraMovementCheck = false;
    @Java(value="GameRules.doLimitedCrafting")
    @Category(value=Category.Type.GAME_RULES)
    public boolean doLimitedCrafting = false;
    @Java(value="GameRules.logAdminCommands")
    @Category(value=Category.Type.GAME_RULES)
    public boolean logAdminCommands = true;
    @Java(value="GameRules.reducedDebugInfo")
    @Category(value=Category.Type.GAME_RULES)
    public boolean reducedDebugInfo = false;
    @Java(value="GameRules.spectatorsGenerateChunks")
    @Category(value=Category.Type.GAME_RULES)
    public boolean spectatorsGenerateChunks = true;
    @Bedrock
    @Java(value="GameRules.spawnRadius")
    @Category(value=Category.Type.GAME_RULES)
    public int spawnradius = 10;
    @Java(value="GameRules.maxEntityCramming")
    @Category(value=Category.Type.GAME_RULES)
    public int maxEntityCramming = 24;
    @Java(value="GameRules.maxCommandChainLength")
    @Bedrock(value="maxcommandchainlength")
    @Category(value=Category.Type.GAME_RULES)
    public int maxCommandChainLength = 65535;
    @Java(value="GameRules.gameLoopFunction")
    @Category(value=Category.Type.GAME_RULES)
    public String gameLoopFunction = "-";
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public double BorderCenterX = 0.0;
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public double BorderCenterZ = 0.0;
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public double BorderDamagePerBlock = 0.2;
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public double BorderSafeZone = 5.0;
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public double BorderSize = 6.0E7;
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public double BorderSizeLerpTarget = 6.0E7;
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public long BorderSizeLerpTime = 0L;
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public double BorderWarningBlocks = 5.0;
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public double BorderWarningTime = 15.0;
    @Java
    @Bedrock(value="IsHardcore")
    @Category(value=Category.Type.WORLD_SETTINGS)
    public boolean hardcore = false;
    @Java
    @Category(value=Category.Type.RESTRICTIONS)
    public boolean DifficultyLocked = false;
    @Java
    @Category(value=Category.Type.WEATHER)
    public boolean raining = false;
    @Java
    @Category(value=Category.Type.WEATHER)
    public boolean thundering = false;
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public boolean MapFeatures = true;
    @Java
    @Category(value=Category.Type.WORLD_SETTINGS)
    public boolean initialized = true;
    @Java
    @Category(value=Category.Type.WEATHER)
    public int thunderTime = 96256;
    @Java
    @Category(value=Category.Type.WEATHER)
    public int clearWeatherTime = 0;
    @Java
    @Category(value=Category.Type.WEATHER)
    public long DayTime = 315L;

    protected static String getType(Class<?> type) {
        if (type == String.class) {
            return "String";
        }
        if (type == Float.TYPE || type == Float.class) {
            return "Single";
        }
        if (type == Double.TYPE || type == Double.class) {
            return "Double";
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return "Byte";
        }
        if (type == Short.TYPE || type == Short.class) {
            return "Int16";
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return "Int32";
        }
        if (type == Long.TYPE || type == Long.class) {
            return "Int64";
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return "Boolean";
        }
        return type.getName();
    }

    public static ChunkerLevelSettings fromJSON(JsonObject jsonObject) {
        return GSON.fromJson((JsonElement)jsonObject, ChunkerLevelSettings.class);
    }

    @NotNull
    public static ChunkerLevelSettings fromNBT(@NotNull CompoundTag root, @NotNull LevelReader levelReader, @NotNull Converter converter) {
        ChunkerLevelSettings chunkerLevelSettings = new ChunkerLevelSettings();
        Class formatAnnotation = levelReader.getEncodingType() == EncodingType.BEDROCK ? Bedrock.class : Java.class;
        for (Field field : chunkerLevelSettings.getClass().getDeclaredFields()) {
            String tagName;
            int position;
            String targetName;
            if (!field.isAnnotationPresent(formatAnnotation)) continue;
            String annotationValue = levelReader.getEncodingType() == EncodingType.BEDROCK ? field.getAnnotation(Bedrock.class).value() : field.getAnnotation(Java.class).value();
            String string = targetName = annotationValue.isEmpty() ? field.getName() : annotationValue;
            if (field.isAnnotationPresent(CustomType.class)) {
                Object value = levelReader.readCustomLevelSetting(root, targetName, field.getType());
                if (value == null) continue;
                try {
                    field.set(chunkerLevelSettings, value);
                }
                catch (Exception e) {
                    converter.logNonFatalException(new Exception("Could not set property " + field.getName() + " Value: " + String.valueOf(value), e));
                }
                continue;
            }
            CompoundTag nbtCompound = root;
            while ((position = targetName.indexOf(".")) != -1 && (nbtCompound = nbtCompound.getCompound(tagName = targetName.substring(0, position), null)) != null) {
                targetName = targetName.substring(position + 1);
            }
            if (nbtCompound == null) continue;
            try {
                Object nbt = nbtCompound.get(targetName);
                if (nbt == null) continue;
                field.set(chunkerLevelSettings, ChunkerLevelSettings.convertType(((Tag)nbt).getBoxedValue(), field.getType()));
            }
            catch (Exception e) {
                converter.logNonFatalException(new Exception("Could not set property " + field.getName() + " Tag: " + String.valueOf(nbtCompound.get(targetName)), e));
            }
        }
        return chunkerLevelSettings;
    }

    protected static Object convertType(Object value, Class<?> target) {
        String string;
        Number number;
        if (Primitives.isWrapperType(target)) {
            target = Primitives.unwrap(target);
        }
        if (target.isInstance(value) || Primitives.unwrap(value.getClass()).equals(target)) {
            return value;
        }
        if (value instanceof Number) {
            number = (Number)value;
            if (target == Boolean.TYPE) {
                return number.byteValue() != 0;
            }
        }
        if (value instanceof Number) {
            number = (Number)value;
            if (target == Integer.TYPE) {
                return number.intValue();
            }
        }
        if (value instanceof Number) {
            number = (Number)value;
            if (target == Byte.TYPE) {
                return number.byteValue();
            }
        }
        if (value instanceof Number) {
            number = (Number)value;
            if (target == Long.TYPE) {
                return number.longValue();
            }
        }
        if (value instanceof Number) {
            number = (Number)value;
            if (target == Double.TYPE) {
                return number.doubleValue();
            }
        }
        if (value instanceof Number) {
            number = (Number)value;
            if (target == Float.TYPE) {
                return Float.valueOf(number.floatValue());
            }
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            if (target == Byte.TYPE) {
                return bool != false ? (byte)1 : 0;
            }
        }
        if (value instanceof String) {
            string = (String)value;
            if (target == Boolean.TYPE) {
                return Boolean.valueOf(string);
            }
        }
        if (value instanceof String) {
            string = (String)value;
            if (target == Integer.TYPE) {
                if (value.equals("true")) {
                    return 1;
                }
                if (value.equals("false")) {
                    return 0;
                }
                return Integer.valueOf(string);
            }
        }
        if (value instanceof String) {
            string = (String)value;
            if (target == Double.TYPE) {
                return Double.valueOf(string);
            }
        }
        if (value instanceof String) {
            string = (String)value;
            if (target == Byte.TYPE) {
                return Byte.valueOf(string);
            }
        }
        if (value instanceof String) {
            string = (String)value;
            if (target == Long.TYPE) {
                return Long.valueOf(string);
            }
        }
        if (value instanceof String) {
            string = (String)value;
            if (target == Float.TYPE) {
                return Float.valueOf(string);
            }
        }
        if (target == String.class) {
            return value.toString();
        }
        throw new IllegalArgumentException("No valid conversion method for " + String.valueOf(value.getClass()) + " to " + String.valueOf(target));
    }

    public JsonObject toJSON() {
        return GSON.toJsonTree(this).getAsJsonObject();
    }

    public JsonObject toDescriptiveJSON() throws IllegalAccessException {
        TreeMap<Category.Type, List> properties = new TreeMap<Category.Type, List>(Comparator.comparing(Enum::ordinal));
        for (Field field : this.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(Hidden.class)) continue;
            Bedrock bedrock = field.getAnnotation(Bedrock.class);
            Java java = field.getAnnotation(Java.class);
            if (bedrock == null && java == null) continue;
            Category category = field.getAnnotation(Category.class);
            Category.Type type = category == null ? Category.Type.UNKNOWN : category.value();
            List list = properties.computeIfAbsent(type, ignored -> new ArrayList());
            JsonObject setting = new JsonObject();
            setting.addProperty("name", field.getName());
            setting.addProperty("bedrock", bedrock != null);
            setting.addProperty("java", java != null);
            setting.addProperty("type", ChunkerLevelSettings.getType(field.getType()));
            setting.add("value", GSON.toJsonTree(field.get(this)));
            list.add(setting);
        }
        LinkedHashMap<String, List> namedProperties = new LinkedHashMap<String, List>(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            namedProperties.put(entry.getKey().getName(), (List)entry.getValue());
        }
        return GSON.toJsonTree(namedProperties).getAsJsonObject();
    }

    public void toNBT(@NotNull CompoundTag output, @NotNull LevelWriter levelWriter, @NotNull Converter converter) {
        Class formatAnnotation = levelWriter.getEncodingType() == EncodingType.BEDROCK ? Bedrock.class : Java.class;
        for (Field field : this.getClass().getDeclaredFields()) {
            int position;
            Object value;
            Class<Object> targetType;
            if (!field.isAnnotationPresent(formatAnnotation)) continue;
            String annotationValue = levelWriter.getEncodingType() == EncodingType.BEDROCK ? field.getAnnotation(Bedrock.class).value() : field.getAnnotation(Java.class).value();
            String targetName = annotationValue.isEmpty() ? field.getName() : annotationValue;
            Class<?> clazz = targetType = levelWriter.getEncodingType() == EncodingType.BEDROCK ? field.getAnnotation(Bedrock.class).type() : field.getAnnotation(Java.class).type();
            if (targetType == Object.class) {
                targetType = field.getType();
            }
            if (targetName.startsWith("GameRules.")) {
                targetType = String.class;
            }
            try {
                value = field.get(this);
            }
            catch (IllegalAccessException e) {
                converter.logNonFatalException(new Exception("Could not get property " + field.getName(), e));
                continue;
            }
            if (field.isAnnotationPresent(CustomType.class)) {
                levelWriter.writeCustomLevelSetting(this, output, targetName, value);
                continue;
            }
            CompoundTag nbtCompound = output;
            while ((position = targetName.indexOf(".")) != -1) {
                String tagName = targetName.substring(0, position);
                nbtCompound = nbtCompound.getOrCreateCompound(tagName);
                targetName = targetName.substring(position + 1);
            }
            if (targetType == Boolean.TYPE) {
                nbtCompound.put(targetName, (Byte)ChunkerLevelSettings.convertType(value, Byte.TYPE));
                continue;
            }
            if (targetType == Byte.TYPE) {
                nbtCompound.put(targetName, (Byte)ChunkerLevelSettings.convertType(value, Byte.TYPE));
                continue;
            }
            if (targetType == Long.TYPE) {
                nbtCompound.put(targetName, (Long)ChunkerLevelSettings.convertType(value, Long.TYPE));
                continue;
            }
            if (targetType == Float.TYPE) {
                nbtCompound.put(targetName, ((Float)ChunkerLevelSettings.convertType(value, Float.TYPE)).floatValue());
                continue;
            }
            if (targetType == Integer.TYPE) {
                nbtCompound.put(targetName, (Integer)ChunkerLevelSettings.convertType(value, Integer.TYPE));
                continue;
            }
            if (targetType == Double.TYPE) {
                nbtCompound.put(targetName, (Double)ChunkerLevelSettings.convertType(value, Double.TYPE));
                continue;
            }
            if (targetType == String.class) {
                nbtCompound.put(targetName, (String)ChunkerLevelSettings.convertType(value, String.class));
                continue;
            }
            converter.logNonFatalException(new Exception("Unable to write type " + targetName + " with type " + String.valueOf(targetType)));
        }
    }

    public String toString() {
        return "ChunkerLevelSettings{bonusChestEnabled=" + this.bonusChestEnabled + ", bonusChestSpawned=" + this.bonusChestSpawned + ", CenterMapsToOrigin=" + this.CenterMapsToOrigin + ", commandblockoutput=" + this.commandblockoutput + ", commandblocksenabled=" + this.commandblocksenabled + ", commandsEnabled=" + this.commandsEnabled + ", ConfirmedPlatformLockedContent=" + this.ConfirmedPlatformLockedContent + ", Difficulty=" + this.Difficulty + ", dodaylightcycle=" + this.dodaylightcycle + ", doentitydrops=" + this.doentitydrops + ", dofiretick=" + this.dofiretick + ", doimmediaterespawn=" + this.doimmediaterespawn + ", doinsomnia=" + this.doinsomnia + ", domobloot=" + this.domobloot + ", domobspawning=" + this.domobspawning + ", dotiledrops=" + this.dotiledrops + ", doweathercycle=" + this.doweathercycle + ", drowningdamage=" + this.drowningdamage + ", educationFeaturesEnabled=" + this.educationFeaturesEnabled + ", eduLevel=" + this.eduLevel + ", experimentalgameplay=" + this.experimentalgameplay + ", FlatWorldVersion=" + this.FlatWorldVersion + ", CavesAndCliffs=" + this.CavesAndCliffs + ", R20Support=" + this.R20Support + ", R21Support=" + this.R21Support + ", WinterDrop2024=" + this.WinterDrop2024 + ", falldamage=" + this.falldamage + ", firedamage=" + this.firedamage + ", ForceGameType=" + this.ForceGameType + ", functioncommandlimit=" + this.functioncommandlimit + ", GameType=" + this.GameType + ", GeneratorType=" + String.valueOf((Object)this.GeneratorType) + ", hasBeenLoadedInCreative=" + this.hasBeenLoadedInCreative + ", hasLockedBehaviorPack=" + this.hasLockedBehaviorPack + ", hasLockedResourcePack=" + this.hasLockedResourcePack + ", immutableWorld=" + this.immutableWorld + ", isFromLockedTemplate=" + this.isFromLockedTemplate + ", isFromWorldTemplate=" + this.isFromWorldTemplate + ", isWorldTemplateOptionLocked=" + this.isWorldTemplateOptionLocked + ", keepinventory=" + this.keepinventory + ", LANBroadcast=" + this.LANBroadcast + ", LANBroadcastIntent=" + this.LANBroadcastIntent + ", LevelName='" + this.LevelName + "', lightningLevel=" + this.lightningLevel + ", lightningTime=" + this.lightningTime + ", LimitedWorldOriginX=" + this.LimitedWorldOriginX + ", LimitedWorldOriginY=" + this.LimitedWorldOriginY + ", LimitedWorldOriginZ=" + this.LimitedWorldOriginZ + ", mobgriefing=" + this.mobgriefing + ", MultiplayerGame=" + this.MultiplayerGame + ", MultiplayerGameIntent=" + this.MultiplayerGameIntent + ", naturalregeneration=" + this.naturalregeneration + ", NetherScale=" + this.NetherScale + ", rainLevel=" + this.rainLevel + ", rainTime=" + this.rainTime + ", RandomSeed='" + this.RandomSeed + "', randomtickspeed=" + this.randomtickspeed + ", sendcommandfeedback=" + this.sendcommandfeedback + ", serverChunkTickRange=" + this.serverChunkTickRange + ", showcoordinates=" + this.showcoordinates + ", showdeathmessages=" + this.showdeathmessages + ", spawnMobs=" + this.spawnMobs + ", SpawnX=" + this.SpawnX + ", SpawnY=" + this.SpawnY + ", SpawnZ=" + this.SpawnZ + ", startWithMapEnabled=" + this.startWithMapEnabled + ", texturePacksRequired=" + this.texturePacksRequired + ", Time=" + this.Time + ", tntexplodes=" + this.tntexplodes + ", useMsaGamertagsOnly=" + this.useMsaGamertagsOnly + ", worldStartCount=" + this.worldStartCount + ", XBLBroadcastIntent=" + this.XBLBroadcastIntent + ", announceAdvancements=" + this.announceAdvancements + ", disableElytraMovementCheck=" + this.disableElytraMovementCheck + ", doLimitedCrafting=" + this.doLimitedCrafting + ", logAdminCommands=" + this.logAdminCommands + ", reducedDebugInfo=" + this.reducedDebugInfo + ", spectatorsGenerateChunks=" + this.spectatorsGenerateChunks + ", spawnradius=" + this.spawnradius + ", maxEntityCramming=" + this.maxEntityCramming + ", maxCommandChainLength=" + this.maxCommandChainLength + ", gameLoopFunction='" + this.gameLoopFunction + "', BorderCenterX=" + this.BorderCenterX + ", BorderCenterZ=" + this.BorderCenterZ + ", BorderDamagePerBlock=" + this.BorderDamagePerBlock + ", BorderSafeZone=" + this.BorderSafeZone + ", BorderSize=" + this.BorderSize + ", BorderSizeLerpTarget=" + this.BorderSizeLerpTarget + ", BorderSizeLerpTime=" + this.BorderSizeLerpTime + ", BorderWarningBlocks=" + this.BorderWarningBlocks + ", BorderWarningTime=" + this.BorderWarningTime + ", hardcore=" + this.hardcore + ", DifficultyLocked=" + (this.DifficultyLocked + ", raining=" + this.raining + ", thundering=" + this.thundering + ", MapFeatures=" + this.MapFeatures + ", initialized=" + this.initialized + ", thunderTime=" + this.thunderTime + ", clearWeatherTime=" + this.clearWeatherTime + ", DayTime=" + this.DayTime + "}");
    }
}

