/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types;

import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;

public enum FacingDirection implements BlockStateValue
{
    DOWN,
    UP,
    NORTH,
    SOUTH,
    WEST,
    EAST;


    public static FacingDirection from3DByte(byte direction) {
        return switch (direction % 6) {
            case 0 -> DOWN;
            case 1 -> UP;
            case 2 -> NORTH;
            case 3 -> SOUTH;
            case 4 -> WEST;
            case 5 -> EAST;
            default -> NORTH;
        };
    }

    public static FacingDirection from2DByte(byte direction) {
        return switch (direction % 4) {
            case 0 -> SOUTH;
            case 1 -> WEST;
            case 2 -> NORTH;
            case 3 -> EAST;
            default -> NORTH;
        };
    }

    public byte to3DByte() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SOUTH -> 3;
            case WEST -> 4;
            case NORTH -> 2;
            case EAST -> 5;
            case UP -> 1;
            case DOWN -> 0;
        };
    }

    public byte to2DByte() {
        return switch (this) {
            case SOUTH -> 0;
            case WEST -> 1;
            case NORTH -> 2;
            case EAST -> 3;
            default -> 0;
        };
    }
}

