/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.chunk.identifier;

import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.PreservedIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerCustomBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockState;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.Bool;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.SingleValuePalette;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkerBlockIdentifier
implements ChunkerItemStackIdentifier {
    public static final ChunkerBlockIdentifier AIR = new ChunkerBlockIdentifier(ChunkerVanillaBlockType.AIR);
    private final ChunkerBlockType type;
    private final Map<BlockState<?>, BlockStateValue> states;
    @Nullable
    private final PreservedIdentifier preservedIdentifier;

    public ChunkerBlockIdentifier(@NotNull ChunkerBlockType type, @NotNull Map<BlockState<?>, BlockStateValue> states, @Nullable PreservedIdentifier preservedIdentifier) {
        this.type = type;
        this.states = states;
        this.preservedIdentifier = preservedIdentifier;
    }

    public ChunkerBlockIdentifier(ChunkerBlockType type, Map<BlockState<?>, BlockStateValue> states) {
        this(type, states, null);
    }

    public ChunkerBlockIdentifier(ChunkerBlockType type) {
        this(type, Collections.emptyMap(), null);
    }

    public static ChunkerBlockIdentifier custom(String identifier, Map<String, Object> states) {
        Object2ObjectOpenHashMap customStates = new Object2ObjectOpenHashMap(states.size());
        for (Map.Entry<String, Object> entry : states.entrySet()) {
            BlockState state;
            BlockStateValue value;
            if (entry.getKey().equals("waterlogged")) {
                value = entry.getValue().equals("true") || entry.getValue().equals(true) || entry.getValue().equals(1) ? Bool.TRUE : Bool.FALSE;
                state = VanillaBlockStates.WATERLOGGED;
            } else {
                value = new ChunkerCustomBlockType.CustomBlockStateValue<Object>(entry.getValue());
                state = new BlockState(entry.getKey(), value, new BlockStateValue[]{value});
            }
            customStates.put(state, value);
        }
        return new ChunkerBlockIdentifier(new ChunkerCustomBlockType(identifier, customStates.keySet()), customStates, null);
    }

    public boolean containsState(BlockState<?> state) {
        return this.states.containsKey(state);
    }

    @Nullable
    public <U extends BlockStateValue> U getState(BlockState<U> blockState, boolean returnDefaultValue) {
        BlockStateValue value = this.states.get(blockState);
        if (value == null && returnDefaultValue && this.getType().getStates().contains(blockState)) {
            value = blockState.getDefault();
        }
        return (U)value;
    }

    @Nullable
    public <U extends BlockStateValue> U getState(BlockState<U> blockState) {
        return this.getState(blockState, true);
    }

    public ChunkerBlockType getType() {
        return this.type;
    }

    public Map<BlockState<?>, BlockStateValue> getPresentStates() {
        return Collections.unmodifiableMap(this.states);
    }

    @Override
    public boolean isAir() {
        return this.type == ChunkerVanillaBlockType.AIR;
    }

    public int getRGBColor() {
        return this.type.getRGBColor();
    }

    public boolean hasRGBColor() {
        return this.getRGBColor() != 0;
    }

    @Nullable
    public PreservedIdentifier getPreservedIdentifier() {
        return this.preservedIdentifier;
    }

    public Palette<ChunkerBlockIdentifier> asFilledChunkPalette() {
        return SingleValuePalette.chunk(this);
    }

    public <T extends BlockStateValue> ChunkerBlockIdentifier copyWith(BlockState<T> blockState, T value) {
        Object2ObjectOpenHashMap statesCopy = new Object2ObjectOpenHashMap(this.states);
        statesCopy.put(blockState, value);
        return new ChunkerBlockIdentifier(this.type, statesCopy, this.preservedIdentifier);
    }

    public <T extends BlockStateValue> ChunkerBlockIdentifier copyWithout(BlockState<T> blockState) {
        if (!this.states.containsKey(blockState)) {
            return this;
        }
        Object2ObjectOpenHashMap statesCopy = new Object2ObjectOpenHashMap(this.states);
        statesCopy.remove(blockState);
        return new ChunkerBlockIdentifier(this.type, statesCopy, this.preservedIdentifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChunkerBlockIdentifier)) {
            return false;
        }
        ChunkerBlockIdentifier that = (ChunkerBlockIdentifier)o;
        return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.states, that.states) && Objects.equals(this.getPreservedIdentifier(), that.getPreservedIdentifier());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.states, this.getPreservedIdentifier());
    }

    @Override
    public ChunkerBlockType getItemStackType() {
        return this.type;
    }

    public String toString() {
        return "ChunkerBlockIdentifier{type=" + String.valueOf(this.type) + ", states=" + this.toStateString() + (String)(this.preservedIdentifier == null ? "" : ", preservedIdentifier=" + String.valueOf(this.preservedIdentifier)) + "}";
    }

    public String toStateString() {
        if (this.states.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<BlockState<?>, BlockStateValue> entry : this.states.entrySet()) {
            if (!builder.isEmpty()) {
                builder.append(",");
            }
            builder.append(entry.getKey().getName()).append("=").append(entry.getValue());
        }
        return builder.toString();
    }
}

