/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.handlers.pretransform.manager;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.PendingPreTransform;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.BlockPreTransformHandler;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.entity.EntityPreTransformHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.entity.Entity;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PreTransformManager {
    protected final Map<ChunkerBlockType, BlockPreTransformHandler> blockTypeToHandler = new Object2ObjectOpenHashMap<ChunkerBlockType, BlockPreTransformHandler>();
    protected final Map<Class<? extends Entity>, EntityPreTransformHandler<?>> entityTypeToHandler = new Object2ObjectOpenHashMap();

    public PreTransformManager(Version version) {
        this.registerHandlers(version);
    }

    protected abstract void registerHandlers(Version var1);

    protected void registerHandler(BlockPreTransformHandler handler, Iterable<ChunkerBlockType> blockTypes) {
        for (ChunkerBlockType blockType : blockTypes) {
            this.blockTypeToHandler.put(blockType, handler);
        }
    }

    protected void registerHandler(BlockPreTransformHandler handler, ChunkerBlockType blockType, ChunkerBlockType ... blockTypes) {
        this.blockTypeToHandler.put(blockType, handler);
        for (ChunkerBlockType blockType2 : blockTypes) {
            this.blockTypeToHandler.put(blockType2, handler);
        }
    }

    protected <T extends Entity> void registerHandler(EntityPreTransformHandler<T> handler, Class<T> entityType) {
        this.entityTypeToHandler.put(entityType, handler);
    }

    protected boolean containsConnectableBlock(ChunkerColumn column, ChunkerChunk chunk) {
        return chunk.getPalette().containsKey(identifier -> this.blockTypeToHandler.containsKey(identifier.getType()));
    }

    public void solve(ChunkerColumn column, boolean preTransformAllowed) {
        ArrayList<PendingPreTransform.PendingBlockPreTransform> pending = new ArrayList<PendingPreTransform.PendingBlockPreTransform>();
        EnumSet<Edge> edges = EnumSet.noneOf(Edge.class);
        column.getEntities().removeIf(entity -> {
            for (Map.Entry<Class<Entity>, EntityPreTransformHandler<?>> handlerEntry : this.entityTypeToHandler.entrySet()) {
                if (!handlerEntry.getKey().isInstance(entity) || !this.solveEntity(column, preTransformAllowed, (List<PendingPreTransform>)pending, (Set<Edge>)edges, handlerEntry.getValue(), (Entity)entity)) continue;
                return true;
            }
            return false;
        });
        for (ChunkerChunk chunk : column.getChunks().values()) {
            if (!this.containsConnectableBlock(column, chunk)) continue;
            for (int localY = 0; localY < 16; ++localY) {
                for (int localX = 0; localX < 16; ++localX) {
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        boolean solveNow;
                        ChunkerBlockIdentifier blockIdentifier = chunk.getPalette().get(localX, localY, localZ, ChunkerBlockIdentifier.AIR);
                        BlockPreTransformHandler handler = this.blockTypeToHandler.get(blockIdentifier.getType());
                        if (handler == null) continue;
                        int x = column.getPosition().chunkX() << 4 | localX;
                        int y = chunk.getY() << 4 | localY;
                        int z = column.getPosition().chunkZ() << 4 | localZ;
                        boolean bl = solveNow = !preTransformAllowed;
                        if (preTransformAllowed) {
                            Set<Edge> requiredEdges = handler.getRequiredEdges(column, x, y, z, blockIdentifier);
                            solveNow = requiredEdges.isEmpty();
                            if (!requiredEdges.isEmpty()) {
                                edges.addAll(requiredEdges);
                            }
                        }
                        if (solveNow) {
                            ChunkerBlockIdentifier newBlockIdentifier = handler.handle(column, Collections.emptyMap(), x, y, z, blockIdentifier);
                            if (newBlockIdentifier.equals(blockIdentifier)) continue;
                            column.setBlock(x, y, z, newBlockIdentifier);
                            continue;
                        }
                        pending.add(new PendingPreTransform.PendingBlockPreTransform(x, y, z, handler));
                    }
                }
            }
        }
        if (!pending.isEmpty()) {
            column.addPreTransformHandler(edges, neighbours -> this.solveEdges(column, (Map<Edge, ChunkerColumn>)neighbours, (List<PendingPreTransform>)pending));
        }
    }

    protected <T extends Entity> boolean solveEntity(ChunkerColumn column, boolean preTransformAllowed, List<PendingPreTransform> pending, Set<Edge> edges, EntityPreTransformHandler<T> handler, Entity entity) {
        boolean solveNow;
        if (!handler.getHandledType().isInstance(entity)) {
            return false;
        }
        Entity typedEntity = (Entity)handler.getHandledType().cast(entity);
        boolean bl = solveNow = !preTransformAllowed;
        if (preTransformAllowed) {
            Set<Edge> requiredEdges = handler.getRequiredEdges(column, typedEntity);
            solveNow = requiredEdges.isEmpty();
            if (!requiredEdges.isEmpty()) {
                edges.addAll(requiredEdges);
            }
        }
        if (solveNow) {
            return handler.handle(column, Collections.emptyMap(), typedEntity);
        }
        pending.add(new PendingPreTransform.PendingEntityPreTransform<Entity>(typedEntity, handler));
        return false;
    }

    protected <T extends Entity> boolean solveEntity(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, PendingPreTransform.PendingEntityPreTransform<T> pendingPreTransform) {
        return pendingPreTransform.preTransformHandler().handle(column, neighbours, pendingPreTransform.entity());
    }

    protected void solveEdges(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, List<PendingPreTransform> pendingPreTransforms) {
        for (PendingPreTransform pendingPreTransform : pendingPreTransforms) {
            if (pendingPreTransform instanceof PendingPreTransform.PendingBlockPreTransform) {
                PendingPreTransform.PendingBlockPreTransform pendingBlockPreTransform = (PendingPreTransform.PendingBlockPreTransform)pendingPreTransform;
                ChunkerBlockIdentifier blockIdentifier = column.getBlock(pendingBlockPreTransform.x(), pendingBlockPreTransform.y(), pendingBlockPreTransform.z());
                ChunkerBlockIdentifier newBlockIdentifier = pendingBlockPreTransform.preTransformHandler().handle(column, neighbours, pendingBlockPreTransform.x(), pendingBlockPreTransform.y(), pendingBlockPreTransform.z(), blockIdentifier);
                if (newBlockIdentifier.equals(blockIdentifier)) continue;
                column.setBlock(pendingBlockPreTransform.x(), pendingBlockPreTransform.y(), pendingBlockPreTransform.z(), newBlockIdentifier);
                continue;
            }
            if (!(pendingPreTransform instanceof PendingPreTransform.PendingEntityPreTransform)) continue;
            PendingPreTransform.PendingEntityPreTransform pendingEntityPreTransform = (PendingPreTransform.PendingEntityPreTransform)pendingPreTransform;
            if (!column.getEntities().contains(pendingEntityPreTransform.entity()) || !this.solveEntity(column, neighbours, pendingEntityPreTransform)) continue;
            column.getEntities().remove(pendingEntityPreTransform.entity());
        }
        pendingPreTransforms.clear();
    }
}

