/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_21_11.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.java.base.writer.JavaWorldWriter;
import com.hivemc.chunker.conversion.encoding.java.v1_21_11.writer.WorldWriter;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import java.io.File;

public class LevelWriter
extends com.hivemc.chunker.conversion.encoding.java.v1_21_9.writer.LevelWriter {
    public LevelWriter(File outputFolder, Version version, Converter converter) {
        super(outputFolder, version, converter);
    }

    @Override
    protected void writeExtraLevelSettings(CompoundTag data) throws Exception {
        super.writeExtraLevelSettings(data);
        CompoundTag oldGameRules = (CompoundTag)data.remove("GameRules");
        CompoundTag newGameRules = data.getOrCreateCompound("game_rules");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "announceAdvancements", "minecraft:show_advancement_messages");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "commandBlockOutput", "minecraft:command_block_output");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "doDaylightCycle", "minecraft:advance_time");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "doEntityDrops", "minecraft:entity_drops");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "doLimitedCrafting", "minecraft:limited_crafting");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "doMobLoot", "minecraft:mob_drops");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "doMobSpawning", "minecraft:spawn_mobs");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "doTileDrops", "minecraft:block_drops");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "doWeatherCycle", "minecraft:advance_weather");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "keepInventory", "minecraft:keep_inventory");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "logAdminCommands", "minecraft:log_admin_commands");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "mobGriefing", "minecraft:mob_griefing");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "naturalRegeneration", "minecraft:natural_health_regeneration");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "reducedDebugInfo", "minecraft:reduced_debug_info");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "sendCommandFeedback", "minecraft:send_command_feedback");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "showDeathMessages", "minecraft:show_death_messages");
        this.convertBooleanGameRule(oldGameRules, newGameRules, "spectatorsGenerateChunks", "minecraft:spectators_generate_chunks");
        this.convertInvertedBooleanGameRule(oldGameRules, newGameRules, "disableElytraMovementCheck", "minecraft:elytra_movement_check");
        if (oldGameRules.contains("doFireTick")) {
            if (oldGameRules.getString("doFireTick").equals("false")) {
                newGameRules.put("minecraft:fire_spread_radius_around_player", 0);
            }
            oldGameRules.remove("doFireTick");
        }
        this.convertIntegerGameRule(oldGameRules, newGameRules, "maxEntityCramming", "minecraft:max_entity_cramming");
        this.convertIntegerGameRule(oldGameRules, newGameRules, "maxCommandChainLength", "minecraft:max_command_sequence_length");
        this.convertIntegerGameRule(oldGameRules, newGameRules, "randomTickSpeed", "minecraft:random_tick_speed");
        this.convertIntegerGameRule(oldGameRules, newGameRules, "spawnRadius", "minecraft:respawn_radius");
    }

    protected void convertBooleanGameRule(CompoundTag oldGameRules, CompoundTag newGameRules, String oldName, String newName) {
        Tag<?> oldTag = oldGameRules.remove(oldName);
        if (oldTag instanceof StringTag) {
            StringTag stringTag = (StringTag)oldTag;
            newGameRules.put(newName, Boolean.parseBoolean(stringTag.getValue()) ? (byte)1 : 0);
        }
    }

    protected void convertInvertedBooleanGameRule(CompoundTag oldGameRules, CompoundTag newGameRules, String oldName, String newName) {
        Tag<?> oldTag = oldGameRules.remove(oldName);
        if (oldTag instanceof StringTag) {
            StringTag stringTag = (StringTag)oldTag;
            newGameRules.put(newName, Boolean.parseBoolean(stringTag.getValue()) ? (byte)0 : 1);
        }
    }

    protected void convertIntegerGameRule(CompoundTag oldGameRules, CompoundTag newGameRules, String oldName, String newName) {
        Tag<?> oldTag = oldGameRules.remove(oldName);
        if (oldTag instanceof StringTag) {
            StringTag stringTag = (StringTag)oldTag;
            newGameRules.put(newName, Integer.parseInt(stringTag.getValue()));
        }
    }

    @Override
    public JavaWorldWriter createWorldWriter() {
        return new WorldWriter(this.outputFolder, this.converter, this.resolvers);
    }
}

