/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_17.reader;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaWorldReader;
import com.hivemc.chunker.conversion.encoding.java.v1_17.reader.WorldReader;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelReader
extends com.hivemc.chunker.conversion.encoding.java.v1_16.reader.LevelReader {
    private static final Gson GSON = new Gson();

    public LevelReader(File inputDirectory, Version inputVersion, Converter converter) {
        super(inputDirectory, inputVersion, converter);
    }

    @Override
    @Nullable
    public Object readCustomLevelSetting(@NotNull CompoundTag root, @NotNull String targetName, @NotNull Class<?> type) {
        if (targetName.equals("CavesAndCliffs")) {
            return this.isCavesAndCliffs();
        }
        if (targetName.equals("FlatWorldVersion")) {
            return this.isCavesAndCliffs() ? 1 : 0;
        }
        return super.readCustomLevelSetting(root, targetName, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCavesAndCliffs() {
        File datapacks = new File(this.inputDirectory, "datapacks");
        if (!datapacks.isDirectory()) {
            return false;
        }
        File[] fileArray = Objects.requireNonNull(datapacks.listFiles());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block25: {
                File file = fileArray[n2];
                if (file.getName().endsWith(".zip")) {
                    try (ZipFile zip = new ZipFile(file);){
                        ZipEntry entry = zip.getEntry("data/minecraft/dimension_type/overworld.json");
                        if (entry == null) break block25;
                        try (InputStream inputStream = zip.getInputStream(entry);
                             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                            JsonObject jsonObject = GSON.fromJson((Reader)inputStreamReader, JsonObject.class);
                            if (jsonObject.has("min_y") && jsonObject.get("min_y").getAsInt() == -64) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public JavaWorldReader createWorldReader(File dimensionFolder, Dimension dimension) {
        return new WorldReader(this.converter, this.resolvers, dimensionFolder, dimension);
    }
}

