/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_16.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaWorldReader;
import com.hivemc.chunker.conversion.encoding.java.v1_16.reader.WorldReader;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerGeneratorType;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelReader
extends com.hivemc.chunker.conversion.encoding.java.v1_15.reader.LevelReader {
    public LevelReader(File inputDirectory, Version inputVersion, Converter converter) {
        super(inputDirectory, inputVersion, converter);
    }

    @Override
    public JavaWorldReader createWorldReader(File dimensionFolder, Dimension dimension) {
        return new WorldReader(this.converter, this.resolvers, dimensionFolder, dimension);
    }

    @Override
    @Nullable
    public Object readCustomLevelSetting(@NotNull CompoundTag root, @NotNull String targetName, @NotNull Class<?> type) {
        if (targetName.equals("RandomSeed")) {
            if (root.contains("RandomSeed")) {
                return String.valueOf(root.getLong("RandomSeed"));
            }
            CompoundTag worldGenSettings = root.getCompound("WorldGenSettings");
            if (worldGenSettings == null) {
                return null;
            }
            return worldGenSettings.getOptionalValue("seed", Long.class).map(String::valueOf).orElse(null);
        }
        if (type == ChunkerGeneratorType.class) {
            if (root.contains("generatorOptions") && root.get("generatorOptions") instanceof StringTag) {
                return super.readCustomLevelSetting(root, targetName, type);
            }
            CompoundTag worldGenSettings = root.getCompound("WorldGenSettings");
            if (worldGenSettings == null) {
                return ChunkerGeneratorType.NORMAL;
            }
            CompoundTag dimensions = worldGenSettings.getCompound("dimensions");
            if (dimensions == null) {
                return ChunkerGeneratorType.NORMAL;
            }
            CompoundTag overWorld = dimensions.getCompound("minecraft:overworld");
            if (overWorld == null) {
                return ChunkerGeneratorType.CUSTOM;
            }
            CompoundTag generator = overWorld.getCompound("generator");
            if (generator == null) {
                return ChunkerGeneratorType.NORMAL;
            }
            String generatorName = generator.getString("type", null);
            if (generatorName == null || generatorName.equals("minecraft:noise")) {
                return ChunkerGeneratorType.NORMAL;
            }
            if (generatorName.equals("minecraft:flat")) {
                CompoundTag generatorOptions = generator.getCompound("settings");
                if (generatorOptions == null) {
                    return ChunkerGeneratorType.FLAT;
                }
                Object layers = generatorOptions.get("layers");
                return this.inferGeneratorTypeFromLayers((Tag<?>)layers);
            }
            return ChunkerGeneratorType.CUSTOM;
        }
        return super.readCustomLevelSetting(root, targetName, type);
    }
}

