/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.writer.LevelWriter;
import com.hivemc.chunker.conversion.encoding.base.writer.WorldWriter;
import com.hivemc.chunker.conversion.encoding.java.base.JavaReaderWriter;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaLevelReader;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.base.writer.JavaWorldWriter;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.PreTransformManager;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerGeneratorType;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelPlayer;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelSettings;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ShortMap;
import it.unimi.dsi.fastutil.longs.Long2ShortOpenHashMap;
import java.io.File;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class JavaLevelWriter
implements LevelWriter,
JavaReaderWriter {
    protected final Long2ShortMap oldToNewMapIDs = new Long2ShortOpenHashMap();
    protected final File outputFolder;
    protected final Version version;
    protected final Converter converter;
    protected final JavaResolvers resolvers;
    protected final File dataFolder;

    public JavaLevelWriter(File outputFolder, Version version, Converter converter) {
        this.outputFolder = outputFolder;
        this.version = version;
        this.converter = converter;
        this.resolvers = this.buildResolvers(converter).build();
        this.dataFolder = new File(outputFolder, "data");
    }

    @Override
    public WorldWriter writeLevel(ChunkerLevel chunkerLevel) {
        this.outputFolder.mkdirs();
        short id = 0;
        for (ChunkerMap map : chunkerLevel.getMaps()) {
            this.oldToNewMapIDs.put(map.getId(), id);
            map.setId(id);
            id = (short)(id + 1);
        }
        Task.asyncConsume("Writing Level Data", TaskWeight.NORMAL, this::writeLevelData, chunkerLevel);
        return this.createWorldWriter();
    }

    protected void writeLevelData(ChunkerLevel chunkerLevel) {
        Task.asyncConsume("Writing Level Settings", TaskWeight.NORMAL, this::writeLevelSettings, chunkerLevel);
        Task.asyncConsume("Writing Saved Maps", TaskWeight.NORMAL, this::writeMaps, chunkerLevel);
    }

    protected void writeMaps(ChunkerLevel chunkerLevel) throws Exception {
        if (chunkerLevel.getMaps().isEmpty()) {
            return;
        }
        if (!this.dataFolder.isDirectory()) {
            this.dataFolder.mkdirs();
        }
        CompoundTag root = new CompoundTag(1);
        root.put("map", (short)chunkerLevel.getMaps().stream().mapToLong(ChunkerMap::getId).max().orElse(0L));
        Tag.writeUncompressedJavaNBT(new File(this.dataFolder, "idcounts.dat"), root);
        Task.asyncConsumeForEach("Writing Saved Map", TaskWeight.NORMAL, this::writeMap, chunkerLevel.getMaps());
    }

    protected CompoundTag prepareMap(ChunkerMap chunkerMap) throws Exception {
        CompoundTag mapData = chunkerMap.getOriginalNBT() != null ? chunkerMap.getOriginalNBT() : new CompoundTag(11);
        mapData.put("dimension", chunkerMap.getDimension().getJavaID());
        mapData.put("width", (short)chunkerMap.getWidth());
        mapData.put("height", (short)chunkerMap.getHeight());
        mapData.put("xCenter", chunkerMap.getXCenter());
        mapData.put("zCenter", chunkerMap.getZCenter());
        mapData.put("trackingPosition", chunkerMap.isUnlimitedTracking() ? (byte)1 : 0);
        mapData.put("unlimitedTracking", chunkerMap.isUnlimitedTracking() ? (byte)1 : 0);
        mapData.put("locked", chunkerMap.isLocked() ? (byte)1 : 0);
        mapData.put("scale", chunkerMap.getScale());
        mapData.put("banners", new ListTag());
        if (chunkerMap.getBytes() != null) {
            mapData.put("colors", this.resolvers.writeMapColors(chunkerMap.getBytes()));
        }
        return mapData;
    }

    protected void writeMap(ChunkerMap chunkerMap) throws Exception {
        CompoundTag mapData = this.prepareMap(chunkerMap);
        CompoundTag root = new CompoundTag(2);
        root.put("data", mapData);
        root.put("DataVersion", this.resolvers.dataVersion().getDataVersion());
        Tag.writeGZipJavaNBT(new File(this.dataFolder, "map_" + chunkerMap.getId() + ".dat"), root);
    }

    @Override
    public void writeCustomLevelSetting(ChunkerLevelSettings chunkerLevelSettings, CompoundTag output, String targetName, Object value) {
        if (targetName.equals("AutumnDrop2025")) {
            return;
        }
        if (targetName.equals("SummerDrop2025")) {
            return;
        }
        if (targetName.equals("WinterDrop2024")) {
            return;
        }
        if (targetName.equals("R21Support")) {
            return;
        }
        if (targetName.equals("R20Support")) {
            return;
        }
        if (targetName.equals("CavesAndCliffs")) {
            return;
        }
        if (targetName.equals("FlatWorldVersion")) {
            return;
        }
        if (targetName.equals("RandomSeed")) {
            output.put("RandomSeed", Long.parseLong((String)value));
            return;
        }
        if (value instanceof ChunkerGeneratorType) {
            ChunkerGeneratorType generatorType = (ChunkerGeneratorType)((Object)value);
            if (!this.converter.shouldAllowNBTCopying() && generatorType == ChunkerGeneratorType.CUSTOM) {
                generatorType = ChunkerGeneratorType.VOID;
            }
            switch (generatorType) {
                case NORMAL: {
                    output.put("generatorName", "default");
                    output.put("generatorVersion", 0);
                    return;
                }
                case FLAT: {
                    output.put("generatorName", "flat");
                    output.put("generatorVersion", 0);
                    return;
                }
                case VOID: {
                    output.put("generatorName", "flat");
                    output.put("generatorVersion", 0);
                    output.put("generatorOptions", "3;minecraft:air;127;decoration");
                    return;
                }
                case CUSTOM: {
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Writing of " + targetName + " is not implemented.");
    }

    protected void enableExperiments(CompoundTag output, String ... experiments) {
        ListTag<StringTag, String> enabledFeatures;
        ListTag<StringTag, String> enabled;
        CompoundTag dataPacks = output.getOrCreateCompound("DataPacks");
        if (!dataPacks.contains("Enabled")) {
            dataPacks.put("Enabled", new ListTag<StringTag, String>(TagType.STRING, 1));
        }
        if (!(enabled = dataPacks.getList("Enabled", StringTag.class)).contains("vanilla")) {
            enabled.add(new StringTag("vanilla"));
        }
        for (String experiment : experiments) {
            if (enabled.contains(experiment)) continue;
            enabled.add(new StringTag(experiment));
        }
        if (!output.contains("enabled_features")) {
            output.put("enabled_features", new ListTag<StringTag, String>(TagType.STRING, 1));
        }
        if (!(enabledFeatures = output.getList("enabled_features", StringTag.class)).contains("vanilla")) {
            enabledFeatures.add(new StringTag("vanilla"));
        }
        for (String experiment : experiments) {
            if (enabledFeatures.contains(experiment)) continue;
            enabledFeatures.add(new StringTag(experiment));
        }
    }

    protected void writeLevelSettings(ChunkerLevel chunkerLevel) throws Exception {
        CompoundTag data = chunkerLevel.getOriginalLevelData() == null || !this.converter.shouldAllowNBTCopying() ? new CompoundTag(100) : chunkerLevel.getOriginalLevelData();
        chunkerLevel.getSettings().toNBT(data, this, this.converter);
        try {
            this.writePlayer(chunkerLevel, data, chunkerLevel.getPlayer());
        }
        catch (Exception e) {
            this.converter.logNonFatalException(e);
        }
        this.writeExtraLevelSettings(data);
        CompoundTag root = new CompoundTag(1);
        root.put("Data", data);
        Tag.writeGZipJavaNBT(new File(this.outputFolder, "level.dat"), root);
    }

    protected void writePlayer(ChunkerLevel chunkerLevel, CompoundTag level, @Nullable ChunkerLevelPlayer player) throws Exception {
        if (player == null) {
            return;
        }
        CompoundTag playerTag = level.getOrCreateCompound("Player");
        playerTag.put("DataVersion", this.resolvers.dataVersion().getDataVersion());
        playerTag.put("Pos", ListTag.fromValues(TagType.DOUBLE, List.of(Double.valueOf(player.getPositionX()), Double.valueOf(player.getPositionY()), Double.valueOf(player.getPositionZ()))));
        playerTag.put("Motion", ListTag.fromValues(TagType.DOUBLE, List.of(Double.valueOf(player.getMotionX()), Double.valueOf(player.getMotionY()), Double.valueOf(player.getMotionZ()))));
        playerTag.put("Rotation", ListTag.fromValues(TagType.FLOAT, List.of(Float.valueOf(player.getYaw()), Float.valueOf(player.getPitch()))));
        playerTag.put("Dimension", player.getDimension().getJavaID());
        int gameType = player.getGameType();
        if (gameType == 5) {
            gameType = chunkerLevel.getSettings().GameType;
        }
        if (gameType > 3) {
            gameType = 3;
        }
        playerTag.put("playerGameType", gameType);
        boolean splitEquipment = this.resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 21, 5);
        ListTag items = new ListTag(TagType.COMPOUND, player.getInventory().size());
        for (Byte2ObjectMap.Entry tag : player.getInventory().byte2ObjectEntrySet()) {
            Optional<CompoundTag> item;
            if (((ChunkerItemStack)tag.getValue()).getIdentifier().isAir() || splitEquipment && JavaLevelReader.SLOT_TO_EQUIPMENT.containsKey(tag.getByteKey()) || (item = this.resolvers.writeItem((ChunkerItemStack)tag.getValue())).isEmpty()) continue;
            item.get().put("Slot", tag.getByteKey());
            items.add(item.get());
        }
        playerTag.put("Inventory", items);
        if (splitEquipment) {
            CompoundTag equipment = new CompoundTag(JavaLevelReader.SLOT_TO_EQUIPMENT.size());
            for (Map.Entry<Byte, String> slot : JavaLevelReader.SLOT_TO_EQUIPMENT.entrySet()) {
                Optional<CompoundTag> item;
                ChunkerItemStack tag = player.getInventory().get(slot.getKey());
                if (tag == null || tag.getIdentifier().isAir() || (item = this.resolvers.writeItem(tag)).isEmpty()) continue;
                equipment.put(slot.getValue(), item.get());
            }
            playerTag.put("equipment", equipment);
        }
    }

    protected void writeExtraLevelSettings(CompoundTag data) throws Exception {
        int type;
        int y;
        if (!data.contains("Version")) {
            if (this.resolvers.dataVersion() == null) {
                throw new Exception("Unable to find a suitable data version.");
            }
            CompoundTag version = new CompoundTag(3);
            version.put("Id", this.resolvers.dataVersion().getDataVersion());
            version.put("Name", this.resolvers.dataVersion().getVersion().toString());
            version.put("Snapshot", (byte)0);
            data.put("Version", version);
        }
        if (!data.contains("version")) {
            data.put("version", 19133);
        }
        if (!data.contains("DataVersion")) {
            if (this.resolvers.dataVersion() == null) {
                throw new Exception("Unable to find a suitable data version.");
            }
            data.put("DataVersion", this.resolvers.dataVersion().getDataVersion());
        }
        if (!data.contains("generatorName")) {
            data.put("generatorName", "flat");
        }
        if (!data.contains("generatorVersion")) {
            data.put("generatorVersion", 0);
        }
        if (!data.contains("initialized")) {
            data.put("initialized", (byte)1);
        }
        data.put("LastPlayed", Instant.now().toEpochMilli());
        if (data.contains("SpawnY") && (y = data.getInt("SpawnY")) == Short.MAX_VALUE) {
            data.put("SpawnY", -1);
        }
        if (data.contains("GameType") && (type = data.getInt("GameType")) > 3) {
            data.put("GameType", 3);
        }
    }

    @Override
    public void flushLevel() {
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    public PreTransformManager getPreTransformManager() {
        return this.resolvers.preTransformManager();
    }

    public JavaWorldWriter createWorldWriter() {
        return new JavaWorldWriter(this.outputFolder, this.converter, this.resolvers);
    }
}

