/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.writer.ColumnWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.util.ColumnUtil;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.base.writer.JavaChunkWriter;
import com.hivemc.chunker.conversion.encoding.java.base.writer.JavaWorldWriter;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.PreTransformManager;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.entity.Entity;
import com.hivemc.chunker.conversion.intermediate.column.heightmap.HeightMap;
import com.hivemc.chunker.conversion.intermediate.column.heightmap.JavaLegacyHeightMap;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerPortal;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.TagWithName;
import com.hivemc.chunker.nbt.tags.array.ByteArrayTag;
import com.hivemc.chunker.nbt.tags.array.IntArrayTag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.scheduling.task.FutureTask;
import com.hivemc.chunker.scheduling.task.ProgressiveTask;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import com.hivemc.chunker.util.BlockPosition;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.jetbrains.annotations.Nullable;

public class JavaColumnWriter
implements ColumnWriter {
    protected final JavaWorldWriter parent;
    protected final Converter converter;
    protected final JavaResolvers resolvers;
    protected final Dimension dimension;

    public JavaColumnWriter(JavaWorldWriter parent, Converter converter, JavaResolvers resolvers, Dimension dimension) {
        this.parent = parent;
        this.converter = converter;
        this.resolvers = resolvers;
        this.dimension = dimension;
    }

    @Override
    public void writeColumn(ChunkerColumn chunkerColumn) throws Exception {
        CompoundTag root = new CompoundTag(10);
        root.put("xPos", chunkerColumn.getPosition().chunkX());
        root.put("zPos", chunkerColumn.getPosition().chunkZ());
        root.put("LightPopulated", chunkerColumn.isLightPopulated() ? (byte)1 : 0);
        root.put("TerrainPopulated", (byte)1);
        this.preProcessColumn(chunkerColumn, root);
        chunkerColumn.getChunks().values().forEach(chunk -> chunk.setPalette(chunk.getPalette().compact(ChunkerBlockIdentifier.AIR)));
        ArrayList<ProgressiveTask<TagWithName>> processing = new ArrayList<ProgressiveTask<TagWithName>>(5);
        processing.add(Task.async("Writing HeightMap", TaskWeight.NORMAL, this::writeHeightMap, chunkerColumn));
        processing.add(Task.async("Writing Biomes", TaskWeight.NORMAL, this::writeBiomes, chunkerColumn));
        processing.add(Task.async("Writing Entities", TaskWeight.HIGH, this::writeEntities, chunkerColumn));
        processing.add(Task.async("Writing Block Entities", TaskWeight.HIGH, this::writeBlockEntities, chunkerColumn));
        processing.add(Task.async("Writing Chunks", TaskWeight.HIGHER, this::writeChunks, chunkerColumn));
        Task.asyncConsume("Writing POI", TaskWeight.LOW, this::writePOI, chunkerColumn);
        Task.join(processing).thenConsume("Combining NBT", TaskWeight.LOW, result -> this.combineNBT(root, (List<TagWithName<?>>)result)).then("Post-processing column", TaskWeight.HIGH, () -> this.postProcessColumn(chunkerColumn, root)).then("Writing column NBT", TaskWeight.LOW, () -> this.writeNBT(chunkerColumn, root));
    }

    @Override
    @Nullable
    public PreTransformManager getPreTransformManager() {
        return this.resolvers.preTransformManager();
    }

    protected void combineNBT(CompoundTag output, List<TagWithName<?>> inputs) {
        for (TagWithName<?> input : inputs) {
            if (input == null) continue;
            output.put(input.name(), (Tag<?>)input.tag());
        }
    }

    @Nullable
    protected TagWithName<?> writeHeightMap(ChunkerColumn column) {
        JavaLegacyHeightMap heightMap;
        HeightMap heightMap2 = column.getHeightMap();
        if (!(heightMap2 instanceof JavaLegacyHeightMap)) {
            heightMap = this.generateHeightMap(column);
        } else {
            JavaLegacyHeightMap javaHeightMap = (JavaLegacyHeightMap)heightMap2;
            heightMap = javaHeightMap;
        }
        short[][] heightMapValues = heightMap.getHeightMap();
        int[] heightMapArray = new int[256];
        for (int i = 0; i < heightMapArray.length; ++i) {
            heightMapArray[i] = heightMapValues[i & 0xF][i >> 4 & 0xF];
        }
        return new TagWithName<IntArrayTag>("HeightMap", new IntArrayTag(heightMapArray));
    }

    protected JavaLegacyHeightMap generateHeightMap(ChunkerColumn column) {
        short[][] heightMap = new short[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                short value;
                OptionalInt highest = ColumnUtil.getHighestLitOrSlabBlock(column, x, z);
                heightMap[x][z] = value = (short)(highest.orElse(-1) + 1);
            }
        }
        return new JavaLegacyHeightMap(heightMap);
    }

    @Nullable
    protected TagWithName<?> writeBiomes(ChunkerColumn column) {
        if (column.getBiomes() == null) {
            return null;
        }
        ChunkerBiome[] columnBiomes = column.getBiomes().asColumn(this.resolvers.getFallbackBiome(this.dimension));
        byte[] biomes = new byte[columnBiomes.length];
        for (int i = 0; i < biomes.length; ++i) {
            biomes[i] = (byte)this.resolvers.writeBiomeID(columnBiomes[i], this.dimension);
        }
        return new TagWithName<ByteArrayTag>("Biomes", new ByteArrayTag(biomes));
    }

    @Nullable
    protected TagWithName<?> writeEntities(ChunkerColumn column) {
        ListTag outputList = new ListTag(TagType.COMPOUND, column.getEntities().size());
        for (Entity entity : column.getEntities()) {
            try {
                CompoundTag tag = this.writeEntity(column, entity);
                if (tag == null) continue;
                outputList.add(tag);
            }
            catch (Exception e) {
                this.converter.logNonFatalException(new Exception("Failed to process Entity " + String.valueOf(entity), e));
            }
        }
        return new TagWithName("Entities", outputList);
    }

    @Nullable
    protected CompoundTag writeEntity(ChunkerColumn chunkerColumn, Entity entity) {
        Optional<CompoundTag> compoundTag = this.resolvers.entityResolver().from(entity);
        if (compoundTag.isPresent()) {
            return compoundTag.get();
        }
        this.converter.logMissingMapping(Converter.MissingMappingType.ENTITY, String.valueOf(entity.getEntityType()));
        return null;
    }

    @Nullable
    protected TagWithName<?> writeBlockEntities(ChunkerColumn column) {
        ListTag outputList = new ListTag(TagType.COMPOUND, column.getBlockEntities().size());
        for (BlockEntity blockEntity : column.getBlockEntities()) {
            try {
                CompoundTag tag = this.writeBlockEntity(column, blockEntity);
                if (tag == null) continue;
                outputList.add(tag);
            }
            catch (Exception e) {
                this.converter.logNonFatalException(new Exception("Failed to process BlockEntity " + String.valueOf(blockEntity), e));
            }
        }
        return new TagWithName("TileEntities", outputList);
    }

    @Nullable
    protected CompoundTag writeBlockEntity(ChunkerColumn chunkerColumn, BlockEntity blockEntity) {
        Optional<CompoundTag> compoundTag = this.resolvers.blockEntityResolver().from(blockEntity);
        if (compoundTag.isPresent()) {
            return compoundTag.get();
        }
        this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK_ENTITY, blockEntity.getClass().getSimpleName());
        return null;
    }

    @Nullable
    protected TagWithName<?> writeChunks(ChunkerColumn column) {
        ListTag sections = new ListTag(TagType.COMPOUND, column.getChunks().size());
        JavaChunkWriter chunkWriter = this.createChunkWriter(column);
        FutureTask<List<CompoundTag>> outputs = Task.asyncForEach("Writing Chunk", TaskWeight.NORMAL, chunkWriter::writeChunk, column.getChunks().values());
        outputs.thenConsume("Writing Sections", TaskWeight.LOW, chunks -> {
            for (CompoundTag tag : chunks) {
                if (tag == null) continue;
                sections.add(tag);
            }
        });
        return new TagWithName("Sections", sections);
    }

    protected void preProcessColumn(ChunkerColumn column, CompoundTag columnNBT) {
        for (ChunkerChunk chunk : column.getChunks().values()) {
            this.resolvers.blockEntityResolver().generateBeforeWriteBlockEntities(column, chunk);
            this.resolvers.entityResolver().generateBeforeWriteEntities(column, chunk);
        }
        List<BlockEntity> blockEntities = column.getBlockEntities();
        for (int i = 0; i < blockEntities.size(); ++i) {
            BlockEntity blockEntity2 = blockEntities.get(i);
            BlockEntity replacement = this.resolvers.blockEntityResolver().updateBeforeWrite(column, blockEntity2.getX(), blockEntity2.getY(), blockEntity2.getZ(), blockEntity2);
            if (replacement == blockEntity2) continue;
            blockEntities.set(i, replacement);
        }
        List<Entity> entities = column.getEntities();
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity2 = entities.get(i);
            Entity replacement = this.resolvers.entityResolver().updateBeforeWrite(column, entity2);
            if (replacement == entity2) continue;
            entities.set(i, replacement);
        }
        column.getBlockEntities().removeIf(blockEntity -> this.shouldRemoveBlockEntityBeforeWrite(column, (BlockEntity)blockEntity));
        column.getEntities().removeIf(entity -> this.resolvers.entityResolver().shouldRemoveBeforeWrite(column, entity));
        if (this.converter.shouldPreventYBiomeBlending() && !column.getChunks().isEmpty()) {
            byte highestChunkY;
            Byte2ObjectMap.Entry last = (Byte2ObjectMap.Entry)column.getChunks().byte2ObjectEntrySet().last();
            byte by = highestChunkY = this.converter.level().map(a -> a.getSettings().CavesAndCliffs).orElse(false) != false ? (byte)23 : 15;
            if (!((ChunkerChunk)last.getValue()).isEmpty() && last.getByteKey() < highestChunkY) {
                ChunkerChunk emptyChunk = new ChunkerChunk((byte)(last.getByteKey() + 1));
                emptyChunk.setPalette(ChunkerBlockIdentifier.AIR.asFilledChunkPalette());
                column.getChunks().put(emptyChunk.getY(), emptyChunk);
            }
        }
    }

    protected boolean shouldRemoveBlockEntityBeforeWrite(ChunkerColumn column, BlockEntity blockEntity) {
        ChunkerBlockIdentifier blockIdentifier = column.getBlock(blockEntity.getX(), blockEntity.getY(), blockEntity.getZ());
        if (blockIdentifier.isAir()) {
            return true;
        }
        Optional<Identifier> result = this.resolvers.writeBlockIdentifier(blockIdentifier, false);
        if (result.isEmpty() || result.get().getIdentifier().equals("minecraft:air")) {
            return true;
        }
        return this.resolvers.blockEntityResolver().shouldRemoveBeforeWrite(column, blockEntity.getX(), blockEntity.getY(), blockEntity.getZ(), blockEntity);
    }

    protected void postProcessColumn(ChunkerColumn column, CompoundTag columnNBT) {
    }

    protected CompoundTag nestColumnNBT(CompoundTag columnNBT) {
        CompoundTag root = new CompoundTag(1);
        root.put("Level", columnNBT);
        return root;
    }

    protected void writeNBT(ChunkerColumn column, CompoundTag columnNBT) throws Exception {
        CompoundTag root = this.nestColumnNBT(columnNBT);
        root.put("DataVersion", this.resolvers.dataVersion().getDataVersion());
        this.parent.writeMCAData(this.dimension, column.getPosition(), root);
    }

    protected void writePOI(ChunkerColumn chunkerColumn) throws Exception {
        Optional<ChunkerLevel> optionalChunkerLevel = this.converter.level();
        if (optionalChunkerLevel.isEmpty()) {
            return;
        }
        List<ChunkerPortal> portals = optionalChunkerLevel.get().getPortals();
        if (portals.isEmpty()) {
            return;
        }
        Byte2ObjectOpenHashMap<List> portalBlocks = new Byte2ObjectOpenHashMap<List>();
        for (ChunkerPortal chunkerPortal : portals) {
            if (chunkerPortal.getDimension() != this.dimension) continue;
            List<BlockPosition> list = chunkerPortal.getHorizontalBlocks(chunkerColumn.getPosition());
            for (BlockPosition horizontalBlock : list) {
                ChunkerBlockIdentifier blockIdentifier;
                int y = horizontalBlock.y();
                while ((blockIdentifier = chunkerColumn.getBlock(horizontalBlock.x(), y, horizontalBlock.z())).getType() == ChunkerVanillaBlockType.NETHER_PORTAL) {
                    List list2 = portalBlocks.computeIfAbsent(Byte.valueOf((byte)(y >> 4)), ignored -> new ArrayList());
                    list2.add(new BlockPosition(horizontalBlock.x(), y, horizontalBlock.z()));
                    ++y;
                }
            }
        }
        if (portalBlocks.isEmpty()) {
            return;
        }
        CompoundTag sections = new CompoundTag(portalBlocks.size());
        for (Map.Entry entry : portalBlocks.entrySet()) {
            CompoundTag section = new CompoundTag(2);
            section.put("Valid", (byte)1);
            ListTag records = new ListTag(TagType.COMPOUND, ((List)entry.getValue()).size());
            for (BlockPosition blockPosition : (List)entry.getValue()) {
                CompoundTag record = new CompoundTag(3);
                record.put("type", "minecraft:nether_portal");
                record.put("pos", new int[]{blockPosition.x(), blockPosition.y(), blockPosition.z()});
                record.put("free_tickets", 0);
                records.add(record);
            }
            section.put("Records", records);
            sections.put(((Byte)entry.getKey()).toString(), section);
        }
        CompoundTag compoundTag = new CompoundTag(2);
        compoundTag.put("Sections", sections);
        compoundTag.put("DataVersion", this.resolvers.dataVersion().getDataVersion());
        this.parent.writePOIData(this.dimension, chunkerColumn.getPosition(), compoundTag);
    }

    public JavaChunkWriter createChunkWriter(ChunkerColumn column) {
        return new JavaChunkWriter(this.converter, this.resolvers, this.dimension, column);
    }
}

