/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimMaterial;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class JavaTrimMaterialResolver
implements Resolver<String, ChunkerTrimMaterial> {
    private final InvertibleMap<ChunkerTrimMaterial, String> mapping = InvertibleMap.enumKeys(ChunkerTrimMaterial.class);

    public JavaTrimMaterialResolver(Version version) {
        this.mapping.put(ChunkerTrimMaterial.AMETHYST, "minecraft:amethyst");
        this.mapping.put(ChunkerTrimMaterial.COPPER, "minecraft:copper");
        this.mapping.put(ChunkerTrimMaterial.DIAMOND, "minecraft:diamond");
        this.mapping.put(ChunkerTrimMaterial.EMERALD, "minecraft:emerald");
        this.mapping.put(ChunkerTrimMaterial.GOLD, "minecraft:gold");
        this.mapping.put(ChunkerTrimMaterial.IRON, "minecraft:iron");
        this.mapping.put(ChunkerTrimMaterial.LAPIS, "minecraft:lapis");
        this.mapping.put(ChunkerTrimMaterial.NETHERITE, "minecraft:netherite");
        this.mapping.put(ChunkerTrimMaterial.QUARTZ, "minecraft:quartz");
        this.mapping.put(ChunkerTrimMaterial.REDSTONE, "minecraft:redstone");
        if (version.isGreaterThanOrEqual(1, 21, 4)) {
            this.mapping.put(ChunkerTrimMaterial.RESIN, "minecraft:resin");
        }
    }

    @Override
    public Optional<String> from(ChunkerTrimMaterial input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerTrimMaterial> to(String input) {
        if (!((String)input).contains(":")) {
            input = "minecraft:" + (String)input;
        }
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

